/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteredListModel
extends AbstractListModel {
    private final DefaultListModel _source;
    private Filter _filter;
    private final ArrayList<Integer> _indices = new ArrayList();
    private ListDataListener mListener;

    public FilteredListModel(DefaultListModel source) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this._source = source;
        this.mListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }
        };
        this._source.addListDataListener(this.mListener);
    }

    public void setFilter(Filter f) {
        this._filter = f;
        this.doFilter();
    }

    private void doFilter() {
        this._indices.clear();
        Filter f = this._filter;
        if (f != null) {
            int count = this._source.getSize();
            for (int i = 0; i < count; ++i) {
                Object element = this._source.getElementAt(i);
                if (!f.accept(element)) continue;
                this._indices.add(i);
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        } else {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public int getSize() {
        return this._filter != null ? this._indices.size() : this._source.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        return this._filter != null ? this._source.getElementAt(this._indices.get(index)) : this._source.getElementAt(index);
    }

    public static abstract class Filter<T> {
        private String mText;

        public abstract boolean accept(T var1);

        public String getText() {
            return this.mText;
        }

        public void setText(String pText) {
            this.mText = pText;
        }
    }
}

