/*
    SPDX-FileCopyrightText: 2021, 2024 Ralf Habacker ralf.habacker @freenet.de

    This file is part of libalkimia.

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef ALK_VERSION_H
#define ALK_VERSION_H

#include <QString>
#include <alkimia/alk_export.h>

#define ALK_VERSION_STRING "8.2.0"
#define ALK_VERSION_MAJOR 8
#define ALK_VERSION_MINOR 2
#define ALK_VERSION_PATCH 0
#define ALK_VERSION ALK_VERSION_CHECK(8, 2, 0)
/*
   can be used like #if (ALK_VERSION >= ALK_VERSION_CHECK(8, 1, 0))
*/
#define ALK_VERSION_CHECK(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/**
 * Returns the version number of Alkimia at run-time as a string (for example, "5.19.0").
 * This may be a different version than the version the application was compiled against.
 * @since 8.2
 */
ALK_EXPORT QString alkVersionString();

/**
 * Returns a numerical version number of Alkimia at run-time in the form 0xMMNNPP
 * (MM = major, NN = minor, PP = patch)
 * This can be compared using the macro QT_VERSION_CHECK or ALK_VERSION_CHECK
 *
 * For example:
 * \code
 * if (alkVersion() < QT_VERSION_CHECK(5,19,0))
 * \endcode
 *
 * This may be a different version than the version the application was compiled against.
 * @since 8.20
 */
ALK_EXPORT unsigned int alkVersion();

#endif
