/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GuiSizesHelper;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResizeMode;
import org.openstreetmap.josm.tools.Logging;

public class ImageResource {
    private final Map<Integer, BufferedImage> imgCache = new ConcurrentHashMap<Integer, BufferedImage>(4);
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);
    protected List<ImageOverlay> overlayInfo;
    protected boolean isDisabled;
    private Image baseImage;

    public ImageResource(Image img) {
        CheckParameterUtil.ensureParameterNotNull(img);
        this.baseImage = img;
    }

    public ImageResource(SVGDiagram svg) {
        CheckParameterUtil.ensureParameterNotNull(svg);
        this.svg = svg;
    }

    public ImageResource(ImageResource res, List<ImageOverlay> overlayInfo) {
        this.svg = res.svg;
        this.baseImage = res.baseImage;
        this.overlayInfo = overlayInfo;
    }

    public ImageResource setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        return this;
    }

    public void attachImageIcon(AbstractAction a) {
        a.putValue("SmallIcon", this.getImageIcon(ImageProvider.ImageSizes.SMALLICON.getImageDimension()));
        a.putValue("SwingLargeIconKey", this.getImageIcon(ImageProvider.ImageSizes.LARGEICON.getImageDimension()));
    }

    public void attachImageIcon(AbstractAction a, boolean attachImageResource) {
        this.attachImageIcon(a);
        if (attachImageResource) {
            a.putValue("ImageResource", this);
        }
    }

    public static ImageResource getAttachedImageResource(Action a) {
        return (ImageResource)a.getValue("ImageResource");
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public ImageIcon getImageIcon(Dimension dim) {
        return this.getImageIcon(dim, true, null);
    }

    ImageIcon getImageIcon(Dimension dim, boolean multiResolution, ImageResizeMode resizeMode) {
        return this.getImageIconAlreadyScaled(GuiSizesHelper.getDimensionDpiAdjusted(dim), multiResolution, false, resizeMode);
    }

    ImageIcon getImageIconAlreadyScaled(Dimension dim, boolean multiResolution, boolean highResolution, ImageResizeMode resizeMode) {
        CheckParameterUtil.ensureThat(!(dim.width <= 0 && dim.width != -1 || dim.height <= 0 && dim.height != -1), () -> dim + " is invalid");
        if (resizeMode == null && this.svg != null) {
            resizeMode = ImageResizeMode.AUTO;
        } else if (resizeMode == null) {
            resizeMode = ImageResizeMode.BOUNDED;
        }
        int cacheKey = resizeMode.cacheKey(dim);
        BufferedImage img = this.imgCache.get(cacheKey);
        if (img == null) {
            if (this.svg != null) {
                img = ImageProvider.createImageFromSvg(this.svg, dim, resizeMode);
                if (img == null) {
                    return null;
                }
            } else {
                if (this.baseImage == null) {
                    throw new AssertionError();
                }
                ImageIcon icon = new ImageIcon(this.baseImage);
                if (dim.width == icon.getIconWidth() && dim.height == icon.getIconHeight()) {
                    return icon;
                }
                img = resizeMode.createBufferedImage(dim, new Dimension(icon.getIconWidth(), icon.getIconHeight()), null, icon.getImage());
            }
            if (this.overlayInfo != null) {
                for (ImageOverlay o : this.overlayInfo) {
                    o.process(img, highResolution);
                }
            }
            if (this.isDisabled) {
                Icon disabledIcon = UIManager.getLookAndFeel().getDisabledIcon(null, new ImageIcon(img));
                if (disabledIcon == null) {
                    return null;
                }
                img = new BufferedImage(img.getWidth(), img.getHeight(), 6);
                disabledIcon.paintIcon(new JPanel(), img.getGraphics(), 0, 0);
            }
            this.imgCache.put(cacheKey, img);
        }
        if (!multiResolution || this.svg == null) {
            return new ImageIcon(img);
        }
        try {
            Image mrImg = HiDPISupport.getMultiResolutionImage(img, this, resizeMode);
            return new ImageIcon(mrImg);
        }
        catch (NoClassDefFoundError e) {
            Logging.trace(e);
            return new ImageIcon(img);
        }
    }

    public ImageIcon getImageIconBounded(Dimension maxSize) {
        return this.getImageIcon(maxSize, true, ImageResizeMode.BOUNDED);
    }

    public ImageIcon getPaddedIcon(Dimension iconSize) {
        return this.getImageIcon(iconSize, true, ImageResizeMode.PADDED);
    }

    public String toString() {
        return "ImageResource [" + (String)(this.svg != null ? "svg=" + this.svg : "") + (String)(this.baseImage != null ? "baseImage=" + this.baseImage : "") + "]";
    }
}

