/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GuiSizesHelper;

enum ImageResizeMode {
    AUTO{

        @Override
        Dimension computeDimension(Dimension dim, Dimension icon) {
            CheckParameterUtil.ensureThat(!(dim.width <= 0 && dim.width != -1 || dim.height <= 0 && dim.height != -1), () -> dim + " is invalid");
            if (dim.width == -1 && dim.height == -1) {
                return new Dimension(GuiSizesHelper.getSizeDpiAdjusted(icon.width), GuiSizesHelper.getSizeDpiAdjusted(icon.height));
            }
            if (dim.width == -1) {
                return new Dimension(Math.max(1, icon.width * dim.height / icon.height), dim.height);
            }
            if (dim.height == -1) {
                return new Dimension(dim.width, Math.max(1, icon.height * dim.width / icon.width));
            }
            if (icon.getWidth() / dim.getWidth() > icon.getHeight() / dim.getHeight()) {
                return this.computeDimension(new Dimension(dim.width, -1), icon);
            }
            return this.computeDimension(new Dimension(-1, dim.height), icon);
        }
    }
    ,
    BOUNDED{

        @Override
        Dimension computeDimension(Dimension dim, Dimension icon) {
            CheckParameterUtil.ensureThat(!(dim.width <= 0 && dim.width != -1 || dim.height <= 0 && dim.height != -1), () -> dim + " is invalid");
            int maxWidth = Math.min(dim.width, icon.width);
            int maxHeight = Math.min(dim.height, icon.height);
            return AUTO.computeDimension(new Dimension(maxWidth, maxHeight), icon);
        }
    }
    ,
    PADDED{

        @Override
        Dimension computeDimension(Dimension dim, Dimension icon) {
            CheckParameterUtil.ensureThat(dim.width > 0 && dim.height > 0, () -> dim + " is invalid");
            return dim;
        }

        @Override
        void prepareGraphics(Dimension icon, BufferedImage image, Graphics2D g) {
            g.setClip(0, 0, image.getWidth(), image.getHeight());
            double scale = Math.min((double)image.getWidth() / icon.getWidth(), (double)image.getHeight() / icon.getHeight());
            g.translate(((double)image.getWidth() - icon.getWidth() * scale) / 2.0, ((double)image.getHeight() - icon.getHeight() * scale) / 2.0);
            g.scale(scale, scale);
        }
    };


    abstract Dimension computeDimension(Dimension var1, Dimension var2);

    BufferedImage createBufferedImage(Dimension dim, Dimension icon, Consumer<Graphics2D> renderer, Image sourceIcon) {
        Dimension real = this.computeDimension(dim, icon);
        BufferedImage bufferedImage = new BufferedImage(real.width, real.height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (renderer != null) {
            this.prepareGraphics(icon, bufferedImage, g);
            renderer.accept(g);
        } else if (sourceIcon != null) {
            sourceIcon = sourceIcon.getScaledInstance(real.width, real.height, 4);
            g.drawImage(sourceIcon, 0, 0, null);
        } else {
            throw new IllegalArgumentException("renderer or sourceIcon");
        }
        return bufferedImage;
    }

    void prepareGraphics(Dimension icon, BufferedImage image, Graphics2D g) {
        g.setClip(0, 0, image.getWidth(), image.getHeight());
        g.scale((double)image.getWidth() / icon.getWidth(), (double)image.getHeight() / icon.getHeight());
    }

    int cacheKey(Dimension dim) {
        return this.ordinal() << 28 | (dim.width & 0xFFF) << 16 | dim.height & 0xFFF;
    }
}

