/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import tim.prune.data.TrackInfo;

public abstract class PointColourer {
    private Color _defaultColour = Color.BLUE;
    private Color _startColour = null;
    private Color _endColour = null;
    private int _maxColours = 1;

    public PointColourer(Color color, Color color2, int n) {
        this._startColour = color;
        this._endColour = color2;
        this._maxColours = n;
    }

    public PointColourer(Color color, Color color2) {
        this(color, color2, -1);
    }

    public abstract void calculateColours(TrackInfo var1);

    public Color getColour(int n) {
        return this._defaultColour;
    }

    protected void setDefaultColour(Color color) {
        if (color != null) {
            this._defaultColour = color;
        }
    }

    protected Color getDefaultColour() {
        return this._defaultColour;
    }

    protected Color getStartColour() {
        return this._startColour;
    }

    protected Color getEndColour() {
        return this._endColour;
    }

    protected int getMaxColours() {
        return this._maxColours;
    }

    protected Color mixColour(float f) {
        if (this._startColour == null && this._endColour == null) {
            return this.getDefaultColour();
        }
        if (this._startColour == null) {
            return this._endColour;
        }
        if (this._endColour == null || (double)f < 0.0 || (double)f > 1.0) {
            return this._startColour;
        }
        float[] fArray = Color.RGBtoHSB(this._startColour.getRed(), this._startColour.getGreen(), this._startColour.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(this._endColour.getRed(), this._endColour.getGreen(), this._endColour.getBlue(), null);
        return Color.getHSBColor(fArray[0] + (fArray2[0] - fArray[0]) * f, fArray[1] + (fArray2[1] - fArray[1]) * f, fArray[2] + (fArray2[2] - fArray[2]) * f);
    }
}

