export import tsutil = require("./tsutil");
export interface NameFilter {
    (schemaName: string): boolean;
}
export interface IConfig {
    /**
     * if set to true it will be possible to pass numbers to string parameters
     * @type {boolean}
     */
    numberIsString: boolean;
    /**
     * If it set to true system will create named interfaces for parameters defenition otherwise,
     * it will use structural types
     * Use named interfaces
     */
    createTypesForResources: boolean;
    /**
     * If this option is set to true query parameters will be placed as second argument when method has body
     */
    queryParametersSecond: boolean;
    /**
     * If this option is set to true .get() will be collapsed to ()
     */
    collapseGet: boolean;
    /**
     * If this option is set to true method references will be collapsed if it is only method in the resource
     * foo.get() => foo()
     */
    collapseOneMethod: boolean;
    /**
     * If this option is set to true media type parameters will be removed from declarations
     */
    collapseMediaTypes: boolean;
    /**
     * For example, let resource 'somerRes' have GET, POST and PUT methods.
     * If 'false', generates get(), post() and put() for 'someResource'
     * If 'true', generates getSomeRes(), postSomeRes() and putSomeRes() for
     * parent of 'someRes'. If 'someRes' does not itself has child resources, it is not generated.
     * @type {boolean}
     */
    methodNamesAsPrefixes: boolean;
    /**
     * If this option is set to 'true', the executor combines request and response into a HAR entry
     * and places it into the '__$harEntry__' field of ramlscript response.
     */
    storeHarEntry: boolean;
    /**
     * If it set to true system will create named interfaces for parameters defenition otherwise,
     * it will use structural types
     * Use named interfaces
     */
    createTypesForParameters: any;
    /**
     * It true geneartor will try to reuse parameter types when possible
     * and redeclare using type =
     */
    reuseTypeForParameters: boolean;
    /**
     * If true will not reuse structural types for schemas
     */
    createTypesForSchemaElements: boolean;
    reuseTypesForSchemaElements: boolean;
    /**
     * If 'true', exception is thrown for statuses > 399
     */
    throwExceptionOnIncorrectStatus: boolean;
    /**
     * generate asynchronous client
     **/
    async: boolean;
    debugOptions: {
        generateImplementation: boolean;
        generateSchemas: boolean;
        generateInterface: boolean;
        schemaNameFilter: NameFilter;
    };
    /**
     * Whether to overwrite the 'node_modules' folder for the generated notebook.
     * If the folder is known to be consistent, the option may be set to 'false'
     * in order to save time.
     */
    overwriteModules: boolean;
}
export declare var MODEL_CLASS_MODEL_ELEMENT: string;
export declare var MODEL_CLASS_TYPE_DECLARATION: string;
export declare var MODEL_CLASS_INTERFACE: string;
export declare var MODEL_CLASS_CLASS_DECLARATION: string;
export declare var MODEL_CLASS_ANNOTATION_DECLARATION: string;
export declare var MODEL_CLASS_ENUM_DECLARATION: string;
export declare var MODEL_CLASS_TYPE_ASSERTION: string;
export declare var MODEL_CLASS_API_MODULE: string;
export declare var MODEL_CLASS_UNIVERSE: string;
export declare var MODEL_CLASS_MEMBER: string;
export declare var MODEL_CLASS_UNION_TYPE_REFERENCE: string;
export declare var MODEL_CLASS_SIMPLE_TYPE_REFERENCE: string;
export declare var MODEL_CLASS_FUNCTION_REFERENCE: string;
export declare var MODEL_CLASS_ARRAY_REFERENCE: string;
export declare var MODEL_CLASS_DECLARED_INTERFACE_REFERENCE: string;
export declare var MODEL_CLASS_ANY_TYPE_REFERENCE: string;
export declare var MODEL_CLASS_STRUCTURAL_TYPE_REFERENCE: string;
export declare var MODEL_CLASS_PARAM: string;
export declare var MODEL_CLASS_STRING_VALUE: string;
export declare var MODEL_CLASS_ARRAY_VALUE: string;
export declare var MODEL_CLASS_API_ELEMENT_DECLARATION: string;
export declare var MODEL_CLASS_CONSTRUCTOR: string;
export interface TSModelVisitor {
    startTypeDeclaration(decl: TSTypeDeclaration): boolean;
    endTypeDeclaration(decl: TSTypeDeclaration): void;
    betweenElements(): void;
    startVisitElement(decl: TSAPIElementDeclaration): boolean;
    endVisitElement(decl: TSAPIElementDeclaration): void;
}
export interface Serializer {
    serialize(model: TSModelElement<any>, forImplementation?: boolean): string;
}
export interface IModelElement {
    modelClass(): string;
}
export declare class TSModelElement<T extends TSModelElement<any>> implements IModelElement {
    protected _parent: TSModelElement<any>;
    private _children;
    protected _config: IConfig;
    _comment: string;
    meta: {
        [key: string]: any;
    };
    private _annotations;
    annotations(): IAnnotationReference[];
    patchParent(parent: TSModelElement<any>): void;
    isEmpty(): boolean;
    parent(): TSModelElement<any>;
    children(): T[];
    comment(): string;
    root(): TSAPIModule;
    constructor(parent?: TSModelElement<any>, config?: IConfig);
    protected setParent(parent: TSModelElement<any>): void;
    removeChild(child: T): void;
    addChild(child: T): void;
    serializeToString(isImpl?: boolean): string;
    modelClass(): string;
}
export declare class TSTypeDeclaration extends TSModelElement<TSAPIElementDeclaration> {
    canBeOmmited: () => boolean;
    locked: boolean;
    extras: string[];
    addCode(code: string): void;
    toReference(): TSTypeReference<any>;
    hash(): string;
    isFunctor(): boolean;
    constructor(parent?: TSModelElement<any>);
    getFunctor(): TSAPIElementDeclaration;
    visit(v: TSModelVisitor): void;
    modelClass(): string;
}
export declare class TSInterface extends TSTypeDeclaration {
    name: string;
    extends: TSTypeReference<any>[];
    implements: TSTypeReference<any>[];
    typeParameters: string[];
    typeSignature(): string;
    hash(): string;
    toReference(): TSTypeReference<any>;
    constructor(p: TSModelElement<any>, name: string);
    decl(): string;
    serializeToString(): string;
    private extendsString();
    private implementsString();
    insertComment(): string;
    modelClass(): string;
    protected isImpl(): boolean;
}
export declare class TSClassDecl extends TSInterface {
    decl(): string;
    modelClass(): string;
    protected isImpl(): boolean;
}
export declare class TSAnnotationDecl extends TSInterface {
    decl(): string;
    modelClass(): string;
    toReference(): TSTypeReference<any>;
}
export declare class TSEnumDecl extends TSInterface {
    decl(): string;
    enumConstants: string[];
    modelClass(): string;
}
export declare class TSTypeAssertion extends TSTypeDeclaration {
    private _name;
    private _ref;
    toReference(): TSTypeReference<any>;
    constructor(p: TSModelElement<any>, _name: string, _ref: TSTypeReference<any>);
    serializeToString(): string;
    ref(): TSTypeReference<any>;
    name(): string;
    modelClass(): string;
}
export declare class TSUniverse extends TSModelElement<any> {
    constructor();
    addChild(child: any): void;
    setConfig(cfg: IConfig): void;
    getConfig(): IConfig;
    modelClass(): string;
}
export declare var Universe: TSUniverse;
export declare class TSAPIModule extends TSModelElement<TSInterface> {
    serializer: Serializer;
    getInterface(nm: string): TSInterface;
    serializeToString(): string;
    modelClass(): string;
}
export interface NoChildren extends TSModelElement<NoChildren> {
}
export declare class TSMember<T extends TSModelElement<any>> extends TSModelElement<T> {
    optional: boolean;
    modelClass(): string;
}
export interface TSTypeReference<T extends TSModelElement<any>> extends TSModelElement<T> {
    array(): boolean;
    locked: boolean;
    canBeOmmited(): boolean;
    isFunctor(): boolean;
    getFunctor(): TSAPIElementDeclaration;
    union(q: TSTypeReference<any>): TSTypeReference<any>;
}
export declare class TSUnionTypeReference extends TSModelElement<TSTypeReference<any>> implements TSTypeReference<TSTypeReference<any>> {
    array: () => boolean;
    locked: boolean;
    getFunctor(): TSAPIElementDeclaration;
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    isFunctor(): boolean;
    canBeOmmited(): boolean;
    serializeToString(): string;
    removeChild(child: TSTypeReference<any>): void;
    addChild(child: TSTypeReference<any>): void;
    modelClass(): string;
}
export declare class TSSimpleTypeReference extends TSModelElement<NoChildren> implements TSTypeReference<NoChildren> {
    locked: boolean;
    typeParameters: TSTypeReference<any>[];
    isEmpty(): boolean;
    getFunctor(): TSAPIElementDeclaration;
    canBeOmmited(): boolean;
    isFunctor(): boolean;
    array: () => boolean;
    constructor(p: TSModelElement<any>, tn: string);
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    name: string;
    genericStr: () => string;
    serializeToString(): string;
    modelClass(): string;
}
export declare class TSFunctionReference extends TSModelElement<NoChildren> implements TSTypeReference<NoChildren> {
    locked: boolean;
    rangeType: TSTypeReference<any>;
    parameters: Param[];
    isEmpty(): boolean;
    getFunctor(): TSAPIElementDeclaration;
    canBeOmmited(): boolean;
    isFunctor(): boolean;
    array: () => boolean;
    constructor(p: TSModelElement<any>);
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    serializeToString(): string;
    paramStr: (appendDefault?: boolean) => string;
    modelClass(): string;
}
export declare class TSArrayReference extends TSModelElement<NoChildren> implements TSTypeReference<NoChildren> {
    locked: boolean;
    componentType: TSTypeReference<any>;
    isEmpty(): boolean;
    getFunctor(): TSAPIElementDeclaration;
    canBeOmmited(): boolean;
    isFunctor(): boolean;
    array: () => boolean;
    constructor(componentType?: TSTypeReference<any>);
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    serializeToString(): string;
    modelClass(): string;
}
export interface IAnnotationReference {
    name: string;
    values: {
        [key: string]: Value;
    };
    value(key: string): Value;
}
export declare class TSDeclaredInterfaceReference extends TSSimpleTypeReference {
    private _data;
    isEmpty(): boolean;
    getFunctor(): TSAPIElementDeclaration;
    canBeOmmited(): boolean;
    constructor(p: TSModelElement<any>, tn: string, _data: TSInterface);
    getOriginal(): TSInterface;
    modelClass(): string;
}
export declare class TSAnnotationReference extends TSSimpleTypeReference implements IAnnotationReference {
    constructor(p: TSModelElement<any>, tn: string, values?: {
        [key: string]: Value;
    });
    values: {
        [key: string]: Value;
    };
    value(key?: string): Value;
}
export declare class TSDeclaredAnnotationReference extends TSDeclaredInterfaceReference implements IAnnotationReference {
    values: {
        [key: string]: Value;
    };
    value(key?: string): Value;
}
export declare class AnyType extends TSSimpleTypeReference {
    constructor(nm?: string);
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    modelClass(): string;
}
export declare class TSStructuralTypeReference extends TSTypeDeclaration implements TSTypeReference<TSAPIElementDeclaration> {
    visitReturnType(v: TSModelVisitor): void;
    toReference(): TSTypeReference<any>;
    union(q: TSTypeReference<any>): TSTypeReference<any>;
    array: () => boolean;
    constructor(parent?: TSModelElement<any>);
    serializeToString(): string;
    canBeOmmited: () => boolean;
    modelClass(): string;
}
export declare enum ParamLocation {
    URI = 0,
    BODY = 1,
    OPTIONS = 2,
    OTHER = 3,
}
export declare class Param extends TSModelElement<TSTypeReference<any>> {
    name: string;
    ptype: TSTypeReference<any>;
    optional: boolean;
    location: ParamLocation;
    defaultValue: any;
    isEmpty(): boolean;
    constructor(p: TSAPIElementDeclaration, nm: string, location: ParamLocation, tp?: TSTypeReference<any>, defaultValue?: any);
    serializeToString(appendDefault?: boolean): string;
    modelClass(): string;
}
export interface Value extends TSMember<NoChildren> {
    value(): any;
}
export declare class StringValue extends TSMember<NoChildren> implements Value {
    private _value;
    constructor(_value: string);
    value(): string;
    serializeToString(): string;
    modelClass(): string;
}
export declare class ArrayValue extends TSMember<NoChildren> implements Value {
    private _values;
    constructor(_values: Value[]);
    value(): string;
    serializeToString(): string;
    values(): Value[];
    modelClass(): string;
}
export declare class TSAPIElementDeclaration extends TSMember<TSTypeReference<any>> {
    name: string;
    rangeType: TSTypeReference<any>;
    parameters: Param[];
    optional: boolean;
    value: Value;
    isPrivate: boolean;
    isStatic: boolean;
    isFunc: boolean;
    _body: string;
    visit(v: TSModelVisitor): void;
    constructor(p: TSModelElement<any>, name: string);
    paramStr: (appendDefault?: boolean) => string;
    protected serializeParam: (p: Param, appendDefault: boolean) => string;
    isFunction: () => boolean;
    isAnonymousFunction: () => boolean;
    returnStr: () => string;
    commentCode(): string;
    serializeToString(isImpl?: boolean): string;
    body(): string;
    private escapeDot(name);
    isInterfaceMethodWithBody(): boolean;
    modelClass(): string;
}
export declare class TSConstructor extends TSAPIElementDeclaration {
    constructor(p: TSModelElement<any>);
    protected serializeParam: (p: Param, appendDefault: boolean) => string;
    modelClass(): string;
}
