/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.data;

import java.util.HashMap;
import java.util.List;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.plus.resources.RegionAddressRepository;
import net.sourceforge.offroad.data.QuadRectExtendable;

public class RegionAsMapObject
extends MapObject {
    private RegionAddressRepository mRegion;

    public RegionAsMapObject(RegionAddressRepository pRegion) {
        this.setRegion(pRegion);
        this.name = this.getRegion().getName();
        this.enName = this.getRegion().getLang();
        this.names = new HashMap();
        this.names.put(this.getRegion().getLang(), this.name);
        this.location = this.getRegion().getEstimatedRegionCenter();
        this.fileOffset = 0;
        this.id = this.getRegion().getFile().hashCode();
    }

    public RegionAddressRepository getRegion() {
        return this.mRegion;
    }

    public void setRegion(RegionAddressRepository pRegion) {
        this.mRegion = pRegion;
    }

    @Override
    public LatLon getLocation() {
        List<City> loadedCities = this.getRegion().getLoadedCities();
        if (loadedCities.isEmpty()) {
            return null;
        }
        QuadRectExtendable qr = new QuadRectExtendable(loadedCities.get(0).getLocation());
        for (City city : loadedCities) {
            LatLon cityLoc = city.getLocation();
            qr.insert(cityLoc);
        }
        return qr.getCenter();
    }
}

