/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AbstractLabelComponent;
import com.install4j.runtime.util.DisplayTextArea;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class MultilineLabelComponent
extends AbstractLabelComponent {
    private DisplayTextArea label;
    private boolean hideIfBlank;

    public boolean isHideIfBlank() {
        return this.replaceWithTextOverride("hideIfBlank", this.hideIfBlank);
    }

    public void setHideIfBlank(boolean hideIfBlank) {
        this.hideIfBlank = hideIfBlank;
    }

    @Override
    public Object getConfigurationObject() {
        return this.label;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JTextArea.class;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isInitLabelText()) {
            this.getFormEnvironment().bindTextWithVariables(this.getRawLabelText(), this.label);
        }
    }

    protected boolean isInitLabelText() {
        return true;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.label != null && formEnvironment != null) {
            this.label.setName(this.getLabelName(formEnvironment));
        }
    }

    protected String getLabelName(FormEnvironment formEnvironment) {
        return formEnvironment.getId(this);
    }

    @Override
    public JComponent createCenterComponent() {
        this.label = new DisplayTextArea();
        this.label.setText(this.getLabelText());
        this.label.setAlignmentX(0.0f);
        this.applyLabelColorAndFont(this.getLabelColor(), this.getLabelFont(), this.getLabelFontType(), this.getLabelFontStyle(), this.getLabelFontSizePercent(), this.label);
        return this.label;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String text = this.label.getText();
        if (!text.isEmpty()) {
            console.more(text);
        }
        return true;
    }

    @Override
    public boolean hasUserInput() {
        return false;
    }

    protected DisplayTextArea getLabel() {
        return this.label;
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        if (this.isHideIfBlank() && this.getLabelText().trim().isEmpty()) {
            this.setVisible(false);
        }
    }
}

