/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.ui.FlatSliderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.basic.BasicRangeSliderUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FlatRangeSliderUI
extends BasicRangeSliderUI {
    protected int trackWidth;
    protected Dimension thumbSize;
    protected int focusWidth;
    protected float thumbBorderWidth;
    protected Color trackValueColor;
    protected Color trackColor;
    protected Color thumbColor;
    protected Color thumbBorderColor;
    protected Color focusBaseColor;
    protected Color focusedColor;
    protected Color focusedThumbBorderColor;
    protected Color hoverTrackColor;
    protected Color hoverThumbColor;
    protected Color pressedTrackColor;
    protected Color pressedThumbColor;
    protected Color disabledTrackColor;
    protected Color disabledThumbColor;
    protected Color disabledThumbBorderColor;
    private Color defaultBackground;
    private Color defaultForeground;
    private Object[] oldRenderingHints;

    public static ComponentUI createUI(JComponent c) {
        LookAndFeelFactory.installJideExtension();
        return new FlatRangeSliderUI();
    }

    public FlatRangeSliderUI() {
        super(null);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateLabelUIs(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.updateLabelUIs(c);
        super.uninstallUI(c);
    }

    protected void updateLabelUIs(JComponent c) {
        Dictionary labelTable = ((JSlider)c).getLabelTable();
        if (labelTable == null) {
            return;
        }
        Enumeration e = labelTable.elements();
        while (e.hasMoreElements()) {
            JComponent label = (JComponent)e.nextElement();
            label.updateUI();
            label.setSize(label.getPreferredSize());
        }
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        LookAndFeel.installProperty(slider, "opaque", false);
        this.trackWidth = UIManager.getInt("Slider.trackWidth");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        this.focusWidth = FlatUIUtils.getUIInt("Slider.focusWidth", 4);
        this.thumbBorderWidth = FlatUIUtils.getUIFloat("Slider.thumbBorderWidth", 1.0f);
        this.trackValueColor = FlatUIUtils.getUIColor("Slider.trackValueColor", "Slider.thumbColor");
        this.trackColor = UIManager.getColor("Slider.trackColor");
        this.thumbColor = UIManager.getColor("Slider.thumbColor");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.focusBaseColor = UIManager.getColor("Component.focusColor");
        this.focusedColor = FlatUIUtils.getUIColor("Slider.focusedColor", this.focusBaseColor);
        this.focusedThumbBorderColor = FlatUIUtils.getUIColor("Slider.focusedThumbBorderColor", "Component.focusedBorderColor");
        this.hoverTrackColor = FlatUIUtils.getUIColor("Slider.hoverTrackColor", "Slider.hoverThumbColor");
        this.hoverThumbColor = UIManager.getColor("Slider.hoverThumbColor");
        this.pressedTrackColor = FlatUIUtils.getUIColor("Slider.pressedTrackColor", "Slider.pressedThumbColor");
        this.pressedThumbColor = UIManager.getColor("Slider.pressedThumbColor");
        this.disabledTrackColor = UIManager.getColor("Slider.disabledTrackColor");
        this.disabledThumbColor = UIManager.getColor("Slider.disabledThumbColor");
        this.disabledThumbBorderColor = FlatUIUtils.getUIColor("Slider.disabledThumbBorderColor", "Component.disabledBorderColor");
        this.defaultBackground = UIManager.getColor("Slider.background");
        this.defaultForeground = UIManager.getColor("Slider.foreground");
    }

    @Override
    protected void uninstallDefaults(JSlider slider) {
        super.uninstallDefaults(slider);
        this.trackValueColor = null;
        this.trackColor = null;
        this.thumbColor = null;
        this.thumbBorderColor = null;
        this.focusBaseColor = null;
        this.focusedColor = null;
        this.focusedThumbBorderColor = null;
        this.hoverTrackColor = null;
        this.hoverThumbColor = null;
        this.pressedTrackColor = null;
        this.pressedThumbColor = null;
        this.disabledTrackColor = null;
        this.disabledThumbColor = null;
        this.disabledThumbBorderColor = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new FlatRangeTrackListener(super.createTrackListener(slider));
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        if (this.slider.getOrientation() == 1) {
            return -1;
        }
        FontMetrics fm = this.slider.getFontMetrics(this.slider.getFont());
        return this.trackRect.y + Math.round((float)(this.trackRect.height - fm.getHeight()) / 2.0f) + fm.getAscent() - 1;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return UIScale.scale(super.getPreferredHorizontalSize());
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return UIScale.scale(super.getPreferredVerticalSize());
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return UIScale.scale(super.getMinimumHorizontalSize());
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return UIScale.scale(super.getMinimumVerticalSize());
    }

    @Override
    protected int getTickLength() {
        return UIScale.scale(super.getTickLength());
    }

    @Override
    protected Dimension getThumbSize() {
        return FlatSliderUI.calcThumbSize(this.slider, this.thumbSize, this.focusWidth);
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        super.paint(g2, c);
        FlatUIUtils.resetRenderingHints(g2, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paintLabels(Graphics g2) {
        FlatUIUtils.runWithoutRenderingHints(g2, this.oldRenderingHints, () -> super.paintLabels(g2));
    }

    @Override
    public void paintFocus(Graphics g2) {
    }

    @Override
    public void paintTrack(Graphics g2) {
        RoundRectangle2D.Float track;
        float tw;
        boolean enabled = this.slider.isEnabled();
        float arc = tw = UIScale.scale((float)this.trackWidth);
        Point p = this.adjustThumbForHighValue();
        Rectangle thumbRect2 = new Rectangle(this.thumbRect);
        this.restoreThumbForLowValue(p);
        RoundRectangle2D.Float coloredTrack = null;
        if (this.slider.getOrientation() == 0) {
            float y = (float)this.trackRect.y + ((float)this.trackRect.height - tw) / 2.0f;
            if (enabled) {
                Rectangle thumbRect1 = this.thumbRect;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    Rectangle temp = thumbRect1;
                    thumbRect1 = thumbRect2;
                    thumbRect2 = temp;
                }
                int cx = thumbRect1.x + thumbRect1.width / 2;
                int cw = thumbRect2.x - thumbRect1.x;
                coloredTrack = new RoundRectangle2D.Float(cx, y, cw, tw, arc, arc);
            }
            track = new RoundRectangle2D.Float(this.trackRect.x, y, this.trackRect.width, tw, arc, arc);
        } else {
            float x = (float)this.trackRect.x + ((float)this.trackRect.width - tw) / 2.0f;
            if (enabled) {
                int cy = thumbRect2.y + thumbRect2.height / 2;
                int ch = this.thumbRect.y - thumbRect2.y;
                coloredTrack = new RoundRectangle2D.Float(x, cy, tw, ch, arc, arc);
            }
            track = new RoundRectangle2D.Float(x, this.trackRect.y, tw, this.trackRect.height, arc, arc);
        }
        g2.setColor(enabled ? this.getTrackColor() : this.disabledTrackColor);
        ((Graphics2D)g2).fill(track);
        if (coloredTrack != null) {
            boolean trackHover = this.hover && this.rollover1 && this.rollover2;
            boolean trackPressed = this.pressed1 && this.pressed2;
            Color trackValueColor = this.getTrackValueColor();
            Color color = FlatSliderUI.stateColor(this.slider, trackHover, trackPressed, trackValueColor, null, null, this.hoverTrackColor, this.pressedTrackColor);
            g2.setColor(FlatUIUtils.deriveColor(color, trackValueColor));
            ((Graphics2D)g2).fill(coloredTrack);
        }
    }

    @Override
    public void paintThumb(Graphics g2) {
        boolean thumbHover = this.hover && (!this.second && this.rollover1 || this.second && this.rollover2);
        boolean thumbPressed = !this.second && this.pressed1 || this.second && this.pressed2;
        Color thumbColor = this.getThumbColor();
        Color color = FlatSliderUI.stateColor(this.slider, thumbHover, thumbPressed, thumbColor, this.disabledThumbColor, null, this.hoverThumbColor, this.pressedThumbColor);
        color = FlatUIUtils.deriveColor(color, thumbColor);
        Color foreground = this.slider.getForeground();
        Color borderColor = this.thumbBorderColor != null && foreground == this.defaultForeground ? FlatSliderUI.stateColor(this.slider, false, false, this.thumbBorderColor, this.disabledThumbBorderColor, this.focusedThumbBorderColor, null, null) : null;
        Color focusedColor = FlatUIUtils.deriveColor(this.focusedColor, foreground != this.defaultForeground ? foreground : this.focusBaseColor);
        FlatSliderUI.paintThumb(g2, this.slider, this.thumbRect, this.isRoundThumb(), color, borderColor, focusedColor, this.thumbBorderWidth, this.focusWidth);
    }

    protected Color getTrackValueColor() {
        Color foreground = this.slider.getForeground();
        return foreground != this.defaultForeground ? foreground : this.trackValueColor;
    }

    protected Color getTrackColor() {
        Color backround = this.slider.getBackground();
        return backround != this.defaultBackground ? backround : this.trackColor;
    }

    protected Color getThumbColor() {
        Color foreground = this.slider.getForeground();
        return foreground != this.defaultForeground ? foreground : this.thumbColor;
    }

    protected boolean isRoundThumb() {
        return !this.slider.getPaintTicks() && !this.slider.getPaintLabels();
    }

    protected class FlatRangeTrackListener
    extends BasicRangeSliderUI.RangeTrackListener {
        public FlatRangeTrackListener(BasicSliderUI.TrackListener listener) {
            super(FlatRangeSliderUI.this, listener);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            if (!FlatRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (UIManager.getBoolean("Slider.scrollOnTrackClick")) {
                super.mousePressed(e);
                return;
            }
            int x = e.getX();
            int handle = FlatRangeSliderUI.this.getMouseHandle(x, y = e.getY());
            if (handle != 5 && handle != 6) {
                super.mousePressed(e);
                return;
            }
            if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            Rectangle thumbRect = FlatRangeSliderUI.this.thumbRect;
            if (handle == 6) {
                Point p = FlatRangeSliderUI.this.adjustThumbForHighValue();
                thumbRect = new Rectangle(FlatRangeSliderUI.this.thumbRect);
                FlatRangeSliderUI.this.restoreThumbForLowValue(p);
            }
            int tx = thumbRect.x + thumbRect.width / 2 - x;
            int ty = thumbRect.y + thumbRect.height / 2 - y;
            e.translatePoint(tx, ty);
            super.mousePressed(e);
            e.translatePoint(-tx, -ty);
            this.mouseDragged(e);
        }
    }
}

