/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMapInt<V> {
    private Entry<V>[] table;
    private int count;
    volatile transient Set<V> keySet = null;
    volatile transient Collection<Integer> values = null;
    private int threshold;
    private final float loadFactor;
    private final boolean identity;
    private transient Set<Entry<V>> entrySet = null;

    public HashMapInt() {
        this(20, 0.75f, false);
    }

    public HashMapInt(boolean identity) {
        this(20, 0.75f, identity);
    }

    public HashMapInt(int initialCapacity, boolean identity) {
        this(initialCapacity, 0.75f, identity);
    }

    public HashMapInt(int initialCapacity, float loadFactor, boolean identity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.identity = identity;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.table = new Entry[initialCapacity];
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(int value2) {
        Entry<V>[] tab = this.table;
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry<V> e = tab[i2];
            while (e != null) {
                if (e.value == value2) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(int value2) {
        return this.contains(value2);
    }

    public boolean containsKey(Object key2) {
        Entry<V>[] tab = this.table;
        int hash2 = this.getHash(key2);
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        while (e != null) {
            if (e.hash == hash2 && e.key.equals(key2)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int get(V key2) {
        Entry<V>[] tab = this.table;
        int hash2 = this.getHash(key2);
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        while (e != null) {
            if (e.hash == hash2 && this.keyMatches(key2, e)) {
                return e.value;
            }
            e = e.next;
        }
        return -1;
    }

    private <V> int getHash(V key2) {
        return this.identity ? System.identityHashCode(key2) : key2.hashCode();
    }

    private <V> boolean keyMatches(V key2, Entry<V> e) {
        return this.identity ? e.key == key2 : e.key.equals(key2);
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry<V> old = oldMap[i2];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index2 = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index2];
                newMap[index2] = e;
            }
        }
    }

    Entry<V> getEntry(V key2) {
        Entry<V>[] tab = this.table;
        int hash2 = this.getHash(key2);
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        while (e != null) {
            if (e.hash == hash2 && this.keyMatches(key2, e)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public int put(V key2, int value2) {
        Entry<V>[] tab = this.table;
        int hash2 = this.getHash(key2);
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        while (e != null) {
            if (e.hash == hash2 && this.keyMatches(key2, e)) {
                int old = e.value;
                e.value = value2;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        }
        tab[index2] = e = new Entry<V>(hash2, key2, value2, tab[index2]);
        ++this.count;
        return -1;
    }

    public int remove(V key2) {
        Entry<V>[] tab = this.table;
        int hash2 = this.getHash(key2);
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        Entry<V> prev = null;
        while (e != null) {
            if (e.hash == hash2 && this.keyMatches(key2, e)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index2] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return -1;
    }

    public synchronized void clear() {
        Entry<V>[] tab = this.table;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    Iterator<V> newKeyIterator() {
        return new KeyIterator(this);
    }

    Iterator<Integer> newValueIterator() {
        return new ValueIterator(this);
    }

    Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator(this);
    }

    public Set<V> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<Integer> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Entry<V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public String toString() {
        Iterator<Entry<V>> i2 = this.entrySet().iterator();
        if (!i2.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Entry<V> e;
            V key2;
            sb.append((Object)((key2 = (e = i2.next()).getKey()) == this ? "(this IntHashMap)" : key2));
            sb.append('=');
            sb.append(e.getValue());
            if (!i2.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public Object clone() {
        HashMapInt<V> newMap = new HashMapInt<V>(this.table.length, this.loadFactor, this.identity);
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry<V> entry = this.table[i2];
            while (entry != null) {
                newMap.put(entry.getKey(), entry.getValue());
                entry = entry.next;
            }
        }
        return newMap;
    }

    public static <U> HashMapInt<U> nullMap() {
        return NullMap.INSTANCE;
    }

    public static class Entry<V> {
        final int hash;
        final V key;
        int value;
        Entry<V> next;

        protected Entry(int hash2, V key2, int value2, Entry<V> next2) {
            this.hash = hash2;
            this.key = key2;
            this.value = value2;
            this.next = next2;
        }

        public V getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class KeyIterator
    extends HashIterator<V> {
        private KeyIterator(HashMapInt hashMapInt) {
        }

        @Override
        public V next() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends HashIterator<Integer> {
        private ValueIterator(HashMapInt hashMapInt) {
        }

        @Override
        public Integer next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends HashIterator<Entry<V>> {
        private EntryIterator(HashMapInt hashMapInt) {
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet<V> {
        private KeySet() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashMapInt.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashMapInt.this.count;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return HashMapInt.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            HashMapInt.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<Integer> {
        private Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return HashMapInt.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashMapInt.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return HashMapInt.this.containsValue((Integer)o);
        }

        @Override
        public void clear() {
            HashMapInt.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return HashMapInt.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = HashMapInt.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return HashMapInt.this.count;
        }

        @Override
        public void clear() {
            HashMapInt.this.clear();
        }
    }

    private static final class NullMap<U>
    extends HashMapInt<U> {
        static final NullMap INSTANCE = new NullMap();

        private NullMap() {
            super(0, true);
        }

        @Override
        public boolean contains(int value2) {
            return false;
        }

        @Override
        public boolean containsKey(Object key2) {
            return false;
        }

        @Override
        public int get(Object key2) {
            return -1;
        }

        @Override
        public int put(Object key2, int value2) {
            return -1;
        }

        @Override
        public int remove(Object key2) {
            return -1;
        }

        @Override
        protected void rehash() {
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        Entry<V> next;
        int index;

        HashIterator() {
            Entry<V>[] t = HashMapInt.this.table;
            int i2 = t.length;
            Entry n = null;
            if (HashMapInt.this.count != 0) {
                while (i2 > 0 && (n = t[--i2]) == null) {
                }
            }
            this.next = n;
            this.index = i2;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry<V>[] t = HashMapInt.this.table;
            int i2 = this.index;
            while (n == null && i2 > 0) {
                n = t[--i2];
            }
            this.index = i2;
            this.next = n;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

