/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.impl.utils.MapDeepEquals;

public class GraphAttributesImpl {
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public synchronized Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public synchronized void setValue(String key, Object value) {
        if (value != null) {
            this.checkSupportedTypes(value.getClass());
        }
        this.attributes.put(key, AttributeUtils.standardizeValue(value));
    }

    public synchronized void removeValue(String key) {
        this.attributes.remove(key);
    }

    public synchronized Object getValue(String key) {
        return this.attributes.get(key);
    }

    public synchronized Object getValue(String key, double timestamp) {
        return this.getValueInternal(key, timestamp);
    }

    public synchronized Object getValue(String key, Interval interval) {
        return this.getValueInternal(key, interval);
    }

    private Object getValueInternal(String key, Object timeObj) {
        TimeMap valueSet = (TimeMap)this.attributes.get(key);
        if (valueSet != null) {
            return valueSet.get(timeObj, null);
        }
        return null;
    }

    public synchronized void removeValue(String key, double timestamp) {
        this.removeValueInternal(key, timestamp);
    }

    public synchronized void removeValue(String key, Interval interval) {
        this.removeValueInternal(key, interval);
    }

    private void removeValueInternal(String key, Object timeObj) {
        TimeMap timeMap = (TimeMap)this.attributes.get(key);
        if (timeMap != null && timeMap.remove(timeObj) && timeMap.isEmpty()) {
            this.attributes.remove(key);
        }
    }

    public synchronized void setValue(String key, Object value, double timestamp) {
        this.setValueInternal(key, value, timestamp);
    }

    public synchronized void setValue(String key, Object value, Interval interval) {
        this.setValueInternal(key, value, interval);
    }

    private void setValueInternal(String key, Object value, Object timeObj) {
        if (value == null) {
            throw new NullPointerException("The value can't be null for the key '" + key + "'");
        }
        TimeMap valueSet = null;
        if (this.attributes.containsKey(key)) {
            valueSet = (TimeMap)this.attributes.get(key);
            if (!value.getClass().equals(valueSet.getTypeClass())) {
                throw new IllegalArgumentException("The value type " + value.getClass().getName() + " doesn't match with the expected type " + valueSet.getTypeClass().getName());
            }
        } else {
            if (timeObj instanceof Interval) {
                this.checkSupportedIntervalTypes(value.getClass());
            } else {
                this.checkSupportedTimestampTypes(value.getClass());
            }
            try {
                valueSet = timeObj instanceof Interval ? (TimeMap)AttributeUtils.getIntervalMapType(value.getClass()).newInstance() : (TimeMap)AttributeUtils.getTimestampMapType(value.getClass()).newInstance();
                this.attributes.put(key, valueSet);
            }
            catch (Exception ex) {
                throw new RuntimeException("The dynamic type can't be created", ex);
            }
        }
        valueSet.put(timeObj, value);
    }

    protected void setGraphAttributes(GraphAttributesImpl graphAttributes) {
        this.attributes.putAll(graphAttributes.attributes);
    }

    private void checkSupportedTypes(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unknown type " + type.getName());
        }
    }

    private void checkSupportedTimestampTypes(Class type) {
        try {
            AttributeUtils.getTimestampMapType(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported dynamic type " + type.getName());
        }
    }

    private void checkSupportedIntervalTypes(Class type) {
        try {
            AttributeUtils.getIntervalMapType(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported dynamic type " + type.getName());
        }
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 47 * hash + (this.attributes != null ? this.attributes.hashCode() : 0);
        return hash;
    }

    public boolean deepEquals(GraphAttributesImpl obj) {
        if (obj == null) {
            return false;
        }
        return MapDeepEquals.mapDeepEquals(this.attributes, obj.attributes);
    }
}

