"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renameSymbol = renameSymbol;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const checker_js_1 = require("../checker.js");
const index_js_1 = require("../index.js");
const types_js_1 = require("../types.js");
const util_js_1 = require("./util.js");
function renameSymbol(doc, sourceFile, position, newName) {
    if (!sourceFile.symbols)
        throw "sourceFile is not bound";
    if (!newName)
        return undefined;
    const g = sourceFile.graph;
    if (!g)
        return undefined;
    const offset = doc.offsetAt(position);
    const node = (0, checker_js_1.findNodeAtOffset)(g, offset);
    if (!node)
        return undefined;
    const parent = node.parent;
    if ((0, index_js_1.isIdentifierNode)(node) &&
        isRenamableIdentifier(node) &&
        !!parent &&
        isRenameableNode(parent)) {
        const nodeSymbol = node.symbol;
        if (!nodeSymbol)
            throw "node.symbol is not bound";
        const r = nodeSymbol.references;
        const refs = r ? [nodeSymbol.firstMention, ...r] : [nodeSymbol.firstMention];
        const ranges = (0, util_js_1.syntaxNodesToRanges)(doc, sourceFile, refs);
        const uri = doc.uri;
        const res = {
            changes: {
                [uri]: ranges.map(r => vscode_languageserver_types_1.TextEdit.replace(r, newName)),
            },
        };
        return res;
    }
    debugger;
    return undefined;
}
function isRenameableNode(node) {
    return (node.kind === types_js_1.SyntaxKind.NodeId ||
        node.kind === types_js_1.SyntaxKind.DirectedGraph ||
        node.kind === types_js_1.SyntaxKind.UndirectedGraph);
}
function isRenamableIdentifier(node) {
    return node.kind !== types_js_1.SyntaxKind.QuotedTextIdentifier;
}
//# sourceMappingURL=rename.js.map