/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.UnsolvableVersionConflictException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public final class NearestVersionSelector
extends ConflictResolver.VersionSelector {
    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        ConflictGroup group2 = new ConflictGroup();
        for (ConflictResolver.ConflictItem item : context.getItems()) {
            boolean hardConstraint;
            DependencyNode node2 = item.getNode();
            VersionConstraint constraint = node2.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = constraint.getRange() != null;
            if (hardConstraint && group2.constraints.add(constraint) && group2.winner != null && !constraint.containsVersion(group2.winner.getNode().getVersion())) {
                backtrack = true;
            }
            if (this.isAcceptable(group2, node2.getVersion())) {
                group2.candidates.add(item);
                if (backtrack) {
                    this.backtrack(group2, context);
                    continue;
                }
                if (group2.winner != null && !this.isNearer(item, group2.winner)) continue;
                group2.winner = item;
                continue;
            }
            if (!backtrack) continue;
            this.backtrack(group2, context);
        }
        context.setWinner(group2.winner);
    }

    private void backtrack(ConflictGroup group2, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
        group2.winner = null;
        Iterator<ConflictResolver.ConflictItem> it = group2.candidates.iterator();
        while (it.hasNext()) {
            ConflictResolver.ConflictItem candidate = it.next();
            if (!this.isAcceptable(group2, candidate.getNode().getVersion())) {
                it.remove();
                continue;
            }
            if (group2.winner != null && !this.isNearer(candidate, group2.winner)) continue;
            group2.winner = candidate;
        }
        if (group2.winner == null) {
            throw this.newFailure(context);
        }
    }

    private boolean isAcceptable(ConflictGroup group2, Version version) {
        for (VersionConstraint constraint : group2.constraints) {
            if (constraint.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearer(ConflictResolver.ConflictItem item1, ConflictResolver.ConflictItem item2) {
        if (item1.isSibling(item2)) {
            return item1.getNode().getVersion().compareTo(item2.getNode().getVersion()) > 0;
        }
        return item1.getDepth() < item2.getDepth();
    }

    private UnsolvableVersionConflictException newFailure(ConflictResolver.ConflictContext context) {
        DependencyFilter filter2 = (node2, parents2) -> {
            Objects.requireNonNull(node2, "node cannot be null");
            Objects.requireNonNull(parents2, "parents cannot be null");
            return context.isIncluded(node2);
        };
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(filter2);
        context.getRoot().accept(visitor);
        return new UnsolvableVersionConflictException(visitor.getPaths());
    }

    static final class ConflictGroup {
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Collection<ConflictResolver.ConflictItem> candidates = new ArrayList<ConflictResolver.ConflictItem>(64);
        ConflictResolver.ConflictItem winner;

        ConflictGroup() {
        }

        public String toString() {
            return String.valueOf(this.winner);
        }
    }
}

