/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api.project;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.spi.project.ProjectContentsSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectContentsSupport {
    private static final ClientUtils.SourceCodeSelection[] EMPTY_SELECTION = new ClientUtils.SourceCodeSelection[0];
    private static ProjectContentsSupport DEFAULT;
    private final Collection<? extends ProjectContentsSupportProvider> providers;

    public ClientUtils.SourceCodeSelection[] getProfilingRoots(FileObject profiledClassFile, boolean profileSubprojects) {
        if (this.providers == null) {
            return EMPTY_SELECTION;
        }
        HashSet<ClientUtils.SourceCodeSelection> allRoots = new HashSet<ClientUtils.SourceCodeSelection>();
        for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
            ClientUtils.SourceCodeSelection[] roots = projectContentsSupportProvider.getProfilingRoots(profiledClassFile, profileSubprojects);
            if (roots == null || roots.length <= 0) continue;
            allRoots.addAll(Arrays.asList(roots));
        }
        return allRoots.toArray(new ClientUtils.SourceCodeSelection[0]);
    }

    public String getInstrumentationFilter(boolean profileSubprojects) {
        if (this.providers == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
            String filter = projectContentsSupportProvider.getInstrumentationFilter(profileSubprojects);
            if (filter == null || filter.isEmpty()) continue;
            buffer.append(filter).append(" ");
        }
        return buffer.toString().trim();
    }

    public void reset() {
        if (this.providers != null) {
            for (ProjectContentsSupportProvider projectContentsSupportProvider : this.providers) {
                projectContentsSupportProvider.reset();
            }
        }
    }

    private ProjectContentsSupport(Collection<? extends ProjectContentsSupportProvider> providers) {
        this.providers = providers;
    }

    private static synchronized ProjectContentsSupport defaultImpl() {
        if (DEFAULT == null) {
            DEFAULT = new ProjectContentsSupport(null);
        }
        return DEFAULT;
    }

    public static ProjectContentsSupport get(Lookup.Provider project) {
        Collection providers;
        Collection collection = providers = project != null ? project.getLookup().lookupAll(ProjectContentsSupportProvider.class) : null;
        if (providers == null || providers.isEmpty()) {
            return ProjectContentsSupport.defaultImpl();
        }
        return new ProjectContentsSupport(providers);
    }
}

