/*
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Spicebird code.
#
# The Initial Developer of the Original Code is
# Synovel Software Technologies
# Portions created by the Initial Developer are Copyright (C) 2007-2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Prasad Sunkari <prasad@synovel.com> (Original Author)
#   Ashok Gudibandla <ashok@synovel.com> 
#   Sivakrishna Edpuganti <sivakrishna@synovel.com> 
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
*/

var gCurrentApplication = null;

var gHomeAppName = "home";
var gFocusElements = {};

var gObserverService = Components.classes["@mozilla.org/observer-service;1"]
                        .getService(Components.interfaces.nsIObserverService);

var gIsCustomizeFrameworkToolbarWindowOpen = false;

function setCurrentApp(aCurrent)
{
    /*
     * Work on the previous application/tab
     */
    var oldTab = null;
    if (gCurrentApplication)
        oldTab = document.getElementById ("tab-" + gCurrentApplication);

    // Store focus element for previous application
    // only if the focus belongs to the application tab
    if (oldTab && getLinkedTabPanel(oldTab)
                    .hasChild(document.commandDispatcher.focusedElement))
      gFocusElements[gCurrentApplication] = document.commandDispatcher
                                                    .focusedElement;

    // Remove old tab's controllers 
    if (oldTab)
        _removeControllersOfTab(oldTab);

    /*
     * Set the current application/tab
     */
    gCurrentApplication = aCurrent;

    var tab = document.getElementById ("tab-" + gCurrentApplication);
    setCurrentTab(tab);

    // Notify the applications so they can do they application specific stuff
    gObserverService.notifyObservers(null, "csApplicationSwitched", gCurrentApplication);
}

function _removeControllersOfTab(aTab)
{
    var controllers = getLinkedTabPanel(aTab).controllers;
    var count = controllers.getControllerCount();
    for (var i = 0; i < count; i++) {
      try {
         var controller = controllers.getControllerAt(i);
         top.controllers.removeController(controller); 
       } catch(e) {}
    }
}

function setCurrentTab(aTab)
{
    // Update the tab selection if not already done
    var tabcollab = document.getElementById("tabcollab");
    if (tabcollab.selectedItem != aTab)
        tabcollab.selectedItem = aTab;

    // Update the toolbar
    _updateToolbar();

    // Update the menubar
    _updateMenubar();
    
    // Update the statusbar
    _updateStatusLabels(gCurrentApplication);

    // Update the window title
    _updateWindowTitle();

    // Update controllers
    _updateControllers(aTab);
}

function _updateToolbar()
{
    var toolbar = document.getElementById("framework-toolbox").firstChild.nextSibling;
    while (toolbar) {
        var re = new RegExp("\\b" + gCurrentApplication + "\\b");
        if (toolbar.getAttribute("tags").match(re)) {
          toolbar.removeAttribute("collapsed");
        } else {
          if (!toolbar.hasAttribute("collapsed"))
            toolbar.setAttribute("collapsed", "true");
        }
        toolbar = toolbar.nextSibling;
    }
}

function _updateMenubar()
{
    // Force update menubar at the top level and mark the subsequent level as
    // dirty so that they are updated also but only if/when required.
    var menubar = document.getElementById("framework-menubar");
    menubar.setAttribute ("dirty", "true");
    csCreateAppMenus ("framework-menubar");

    var menu = menubar.firstChild;
    while (menu) {
        menu.firstChild.setAttribute("dirty", "true");
        menu = menu.nextSibling;
    }
}

function _updateWindowTitle(aTab)
{
    var brandBundle = document.getElementById("bundle_brand");
    var brandFullName = brandBundle.getString("brandFullName");
    if (aTab) {
        var title = aTab.getAttribute("title") || aTab.getAttribute("label");
        document.title = title + " - " + brandFullName;
    } else {
        document.title = brandFullName;
    }
}

function _updateControllers(aTab)
{
    var controllers = getLinkedTabPanel(aTab).controllers;
    var count = controllers.getControllerCount();
    for (var i = 0; i < count; i++) {
      try {
         var controller = controllers.getControllerAt(i);
         addCommonController(controller);
       } catch(e) {}
    }
}

var homeAppObserver = {
   observe: function (aSubject, aTopic, aCurrentApp) {
      if (aTopic == "csApplicationSwitched" && aCurrentApp == gHomeAppName) 
         this.switchToHome();
   },

   switchToHome : function() {
      var focusElement = gFocusElements[gHomeAppName];
      if (focusElement)
        focusElement.focus();
   },
}

/**
  * show only relevant labels on status bar.
  */
function _updateStatusLabels(appName) {
  var statusBar = document.getElementById("status-bar");
  var children = statusBar.getElementsByAttribute("app", "*");

  for (var i=0; i < children.length; i++ ) {
    var item = children[i];
    if (item.getAttribute("app").indexOf(appName) == -1)
       item.setAttribute("collapsed", "true");
    else 
       item.removeAttribute("collapsed");
  }
}

function addCommonController (aController) {
   try {
      top.controllers.getControllerId(aController);
   }
   catch (e) { // not present.
      top.controllers.insertControllerAt(0, aController);
   }
}

function initCollabSuite()
{
    var toolbox = document.getElementById("framework-toolbox");
    toolbox.customizeDone = CustomizeFrameworkToolbarDone;
    top.controllers.appendController(csDefaultController);
    gHomeApplets.create();

    // Check if the splash screen is waiting to be closed
    var windowMediator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                                   .getService(Components.interfaces.nsIWindowMediator);
    var splash = windowMediator.getMostRecentWindow("splash:window");
    if (splash)
      splash.close();
}

var currentAppControllers = [];
function setAppControllers(aControllers)
{
   for each (var controller in aControllers)
      top.controllers.insertControllerAt(0, controller);

   currentAppControllers = aControllers;
}

function openAboutCollab()
{
#ifdef XP_MACOSX
  var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                     .getService(Components.interfaces.nsIWindowMediator);
  var win = wm.getMostRecentWindow("collab:about");
  if (win)  // If we have an open about dialog, just focus it.
    win.focus();
  else {
    // Define minimizable=no although it does nothing on OS X
    // (see Bug 287162); remove this comment once Bug 287162 is fixed...
    window.open("chrome://collab/content/about.xul", "About",
                "chrome, resizable=no, minimizable=no");
  }
#else
  window.openDialog("chrome://collab/content/about.xul", "About", "modal,centerscreen,chrome,resizable=no");
#endif
}

function getCurrentTab()
{
  var tabcollab = document.getElementById("tabcollab");
  return tabcollab.selectedItem;
}

function getLinkedTabPanel(aTab)
{
  var tabpanelId = aTab.linkedPanel;
  if (tabpanelId)
    return document.getElementById(tabpanelId);
  return null;
}

function getCurrentTabPanel()
{
  return getLinkedTabPanel(getCurrentTab());
}

function collapseSliderBox()
{
    var sliderBox = document.getElementById("sliderbox-vbox");
    if(sliderBox)
      sliderBox.setAttribute("collapsed", "true");
}

function toggleStatusbar()
{
    var statusbar = document.getElementById("status-bar");
    if(!statusbar)
        return;

    if( statusbar.hidden == true )
        statusbar.hidden = false;
    else
        statusbar.hidden = true;
}

function csCreateAppMenus(aElementId)
{
    /* Obviously, I am not happy about it, there should be cleaner way */
    var element = document.getElementById(aElementId);
    if (!element)
        return;

    if (element.getAttribute("dirty") != "true")
        return;

    csCreateAppMenusForElement(element);
}

function csCreateAppMenusForElement(element)
{
    var children = element.getElementsByAttribute ("app", "*");

    for (var i = 0; i < children.length; i++) {
      if (children[i].getAttribute("app").split(' ').indexOf(gCurrentApplication) != -1) {
        children[i].removeAttribute ("hidden");
      } else {
        children[i].setAttribute ("hidden", "true");
      }
    }

    /* Separator removal */
    var lastSeparator;
    var visibleNodeAppeared = false;
    for (var i = 0; i < element.childNodes.length; i++) {
      if (element.childNodes[i].tagName == "menuseparator")
        element.childNodes[i].removeAttribute ("hidden");

      if (element.childNodes[i].getAttribute ("hidden") == "true")
        continue;

      if (element.childNodes[i].tagName == "menuseparator") {
        /* This will eliminate separators appearing at the begining */
        if (!visibleNodeAppeared)
          element.childNodes[i].setAttribute ("hidden", "true");
          
        /* This will eliminate consecutive separators */
        if (lastSeparator)
          lastSeparator.setAttribute ("hidden", "true");

        lastSeparator = element.childNodes[i];
      } else {
        lastSeparator = null;
        visibleNodeAppeared = true;
      }
    }
    /* This will eliminate the tailing separators */
    if (lastSeparator)
      lastSeparator.setAttribute ("hidden", "true");

    element.removeAttribute("dirty");
}

function goUpdateCommandset(commandset)
{
  for (var i = 0; i < commandset.childNodes.length; i++)
  {
    var commandID = commandset.childNodes[i].getAttribute("id");
    if (commandID)
      goUpdateCommand(commandID);
  }
}

function initFileMenu()
{
    csCreateAppMenus("file-menupopup"); 

    goUpdateCommand('cmd_print');
    goUpdateCommand('cmd_printPreview');

    document.commandDispatcher.updateCommands('create-menu-file');
}

function goUpdateCollabToolbarItems()
{
  // The edit menu commands get updated automatically
  // through another function call.
  goUpdateCommand('cmd_print');
  goUpdateCommand('cmd_printPreview');
}

function initEditMenu()
{
    csCreateAppMenus("edit-menupopup"); 

    document.commandDispatcher.updateCommands('create-menu-edit');
}

function initViewMenu()
{
    // Update sidebar status
    var sidebarCommand = document.getElementById("cmd_viewSidebar");
    var collapsed = getCurrentTabPanel().isSidebarCollapsed();
    sidebarCommand.setAttribute("checked", !collapsed);

    // Update statusbar status
    var statusbaritem = document.getElementById("view-statusbar-item");
    var statusbar = document.getElementById("status-bar");

    if(statusbar && statusbaritem) 
        statusbaritem.setAttribute("checked", !statusbar.hidden);

    csCreateAppMenus("view-menupopup"); 
    document.commandDispatcher.updateCommands('create-menu-view');
}

function initViewToolbarsPopup(aEvent, aToolboxID)
{
    var toolbox = document.getElementById(aToolboxID);
    if (!toolbox) 
      return;

    var toolbarsVisible = !toolbox.hasAttribute("toolbars") || 
                          (toolbox.getAttribute("toolbars") != "hidden");

    var mode = 'none';
    if (toolbarsVisible) 
      mode = toolbox.getAttribute('mode');

    document.getElementById("cmd-toolbar-mode-" + mode).setAttribute("checked", "true");

    goUpdateCommand('cmd_customizeFWToolbar');
}

function initGoMenu()
{
    csCreateAppMenus ("go-menupopup");
    document.commandDispatcher.updateCommands('create-menu-go');
}

function initToolsMenu()
{
    csCreateAppMenus("tools-menupopup"); 
    document.commandDispatcher.updateCommands('create-menu-tools');
}

function initHelpMenu()
{
    document.commandDispatcher.updateCommands('create-menu-help');
    buildUpdateMenuItem();
}

function showJavascriptConsole()
{
    toOpenWindowByType("global:console", "chrome://global/content/console.xul");
}

function toOpenWindowByType(inType, uri, features)
{
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
    var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
    var topWindow = windowManagerInterface.getMostRecentWindow(inType);

    if (topWindow)
        topWindow.focus();
    else if (features)
        window.open(uri, "_blank", features);
    else
        window.open(uri, "_blank", "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar");
}

function showApplicationManager()
{
    const EMTYPE = "Extension:Manager";
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                       .getService(Components.interfaces.nsIWindowMediator);
    var theEM = wm.getMostRecentWindow(EMTYPE);
    if (theEM) {
        theEM.focus();
        return;
    }

    const EMURL = "chrome://mozapps/content/extensions/extensions.xul";
    const EMFEATURES = "chrome,menubar,extra-chrome,toolbar,dialog=no,resizable";
    window.openDialog(EMURL, "", EMFEATURES);
}

function CustomizeFrameworkToolbar()
{
    var menubar = document.getElementById("framework-menubar");
    for (var i = 0; i < menubar.childNodes.length; ++i)
        menubar.childNodes[i].setAttribute("disabled", true);

    gIsCustomizeFrameworkToolbarWindowOpen = true;

    var tabcollab = document.getElementById("tabcollab");
    window.openDialog("chrome://global/content/customizeToolbar.xul", 
                      "CustomizeToolbar", "chrome,all,dependent", 
                      document.getElementById("framework-toolbox"),
                      tabcollab? tabcollab.mTabContainer : null);
}

function CustomizeFrameworkToolbarDone()
{
    var menubar = document.getElementById("framework-menubar");
    for (var i = 0; i < menubar.childNodes.length; ++i)
        menubar.childNodes[i].removeAttribute("disabled");

    gIsCustomizeFrameworkToolbarWindowOpen = false;
}

function setToolbarMode(aToolboxID, aModeValue)
{
  var toolbox = document.getElementById(aToolboxID);
  if (!toolbox) 
    return;

  if (aModeValue == 'none') {
    toolbox.setAttribute("toolbars", "hidden");
    document.persist(toolbox.id, "toolbars");
    return;
  } 
  toolbox.removeAttribute("toolbars");
  document.persist(toolbox.id, "toolbars");

  toolbox.setAttribute("mode", aModeValue);
  document.persist(toolbox.id, "mode");

  for (var i = 0; i < toolbox.childNodes.length; ++i) {
    var toolbar = toolbox.childNodes[i];
    if (toolbar.localName == "toolbar" && 
        toolbar.getAttribute("customizable") == "true" ) {
      toolbar.setAttribute("mode", aModeValue);
      document.persist(toolbar.id, "mode");
    }
  }
}

/*
 * Provides framework level handlers for few commands.
 * Also checks of any of the installed application is ready to
 * handle other commands and hands them off to the corresponding
 * application
 */
var csDefaultController = 
{    
    supportsCommand: function(aCommand) 
    {
        switch (aCommand)
        {
            case "cmd_pageSetup":
                return true;
            case "cmd_viewSidebar":
                return true;
            case "cmd_customizeFWToolbar":
                return true;
        }
        return false;
    },

    isCommandEnabled: function(aCommand)
    {
        switch (aCommand)
        {
            case "cmd_pageSetup":
                return true;
            case "cmd_viewSidebar":
                return getCurrentTabPanel().hasSidebar();
            case "cmd_customizeFWToolbar":
                return !gIsCustomizeFrameworkToolbarWindowOpen;
        }
        return false;
    },

    doCommand: function(aCommand)
    {
        if (!this.isCommandEnabled(aCommand))
            return;

        switch (aCommand)
        {
            case "cmd_pageSetup":
                return PrintUtils.showPageSetup();
            case "cmd_viewSidebar":
                return getCurrentTabPanel().toggleSidebar();
            case "cmd_customizeFWToolbar":
                return CustomizeFrameworkToolbar();
        }
        return false;
    },
};

/**
 * Opens the update manager and checks for updates to the application.
 */

function checkForUpdates()
{
  var um =
      Components.classes["@mozilla.org/updates/update-manager;1"].
      getService(Components.interfaces.nsIUpdateManager);
  var prompter =
      Components.classes["@mozilla.org/updates/update-prompt;1"].
      createInstance(Components.interfaces.nsIUpdatePrompt);

  // If there's an update ready to be applied, show the "Update Downloaded"
  // UI instead and let the user know they have to restart the application for
  // the changes to be applied.
  if (um.activeUpdate && um.activeUpdate.state == "pending")
    prompter.showUpdateDownloaded(um.activeUpdate);
  else
  prompter.checkForUpdates();
}

// XXX: check and use
function buildUpdateMenuItem()
{
  var updates =
      Components.classes["@mozilla.org/updates/update-service;1"].
      getService(Components.interfaces.nsIApplicationUpdateService);
  var um =
      Components.classes["@mozilla.org/updates/update-manager;1"].
      getService(Components.interfaces.nsIUpdateManager);

  // Disable the UI if the update enabled pref has been locked by the
  // administrator or if we cannot update for some other reason
  var checkForUpdates = document.getElementById("help-update-item");
  var canUpdate = updates.canUpdate;
  checkForUpdates.setAttribute("disabled", !canUpdate);
  if (!canUpdate)
    return;

  var collabBundle = document.getElementById("bundle_collab");
  var activeUpdate = um.activeUpdate;

  // If there's an active update, substitute its name into the label
  // we show for this item, otherwise display a generic label.
  function getStringWithUpdateName(key) {
    if (activeUpdate && activeUpdate.name)
      return collabBundle.getFormattedString(key, [activeUpdate.name]);
    return collabBundle.getString(key + "Fallback");
    }

  // By default, show "Check for Updates..."
  var key = "default";
  if (activeUpdate) {
    switch (activeUpdate.state) {
    case "downloading":
      // If we're downloading an update at present, show the text:
      // "Downloading Firefox x.x..." otherwise we're paused, and show
      // "Resume Downloading Firefox x.x..."
      key = updates.isDownloading ? "downloading" : "resume";
      break;
    case "pending":
      // If we're waiting for the user to restart, show: "Apply Downloaded
      // Updates Now..."
      key = "pending";
      break;
    }
  }

  checkForUpdates.label = getStringWithUpdateName("updatesItem_" + key);
  if (um.activeUpdate && updates.isDownloading)
    checkForUpdates.setAttribute("loading", "true");
  else
    checkForUpdates.removeAttribute("loading");
}

function OnLoadCollab () {
    var tabcollab = document.getElementById ("tabcollab");
    if (!tabcollab)
      return;

    var newTab = tabcollab.addTab (10);
    var StringBundle = document.getElementById("bundle_collab");
    newTab.setAttribute ("label", StringBundle.getString("homeTitle"));

    newTab.setAttribute ("onselect", "setCurrentApp('"+ gHomeAppName +"')");
    newTab.setAttribute ("image", "chrome://collab/skin/16x16/go-home.png");
    newTab.setAttribute ("type", "home");
    newTab.setAttribute ("id", "tab-home");
    newTab.setAttribute ("selected", "true");
    newTab.setAttribute ("linkedpanel", "tabpanel-home");

    gObserverService.addObserver(homeAppObserver, "csApplicationSwitched", false);
    setCurrentApp(gHomeAppName);
}

function openTimezoneSelectDialog() {
   window.openDialog("chrome://collab/content/timezoneSelect.xul",
                    "",
                    "chrome,modal=yes,resizable=no, width=400, height=500, centerscreen",
                    null);
}

addEventListener("load", OnLoadCollab, true);
