/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Spicebird code.
 *
 * The Initial Developer of the Original Code is
 * Synovel Software Technologies
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Prasad Sunkari <prasad@synovel.com> (Original Author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _csTPChannel_H_
#define _csTPChannel_H_

#include "nsStringGlue.h"
#include "nsCOMPtr.h"
#include "csITPChannel.h"
#include "csITPChannelGroup.h"
#include "csITPChannelChatState.h"
#include "csITPChannelPassword.h"
#include "csITPChannelInterfaces.h"

#include "telepathy-glib/channel.h"

class nsIMutableArray;

/*
 * Is there a need to create csTPChannel instances directly?
 * We should only need creation of the derived classes.
 */

class csTPChannel : public csITPChannel,
                    public csITPChannelGroup,
                    public csITPChannelChatState,
                    public csITPChannelPassword
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CSITPPROXY
  NS_DECL_CSITPCHANNEL
  NS_DECL_CSITPCHANNELGROUP
  NS_DECL_CSITPCHANNELCHATSTATE
  NS_DECL_CSITPCHANNELPASSWORD

  csTPChannel();
  void ChannelReady();
  void ChannelClosed();
  void GroupFlagsChanged(PRUint32 aAdded, PRUint32 aRemoved);
  void SelfHandleChanged(PRUint32 aSelfHandle);
  void HandleOwnersChanged(GHashTable *aAdded, const GArray *aRemoved);
  void MembersChanged(const gchar *aMessage, const GArray *aAdded, 
                      const GArray *aRemoved, const GArray *aLocalPending, 
                      const GArray *aRemotePending, guint aActor, guint aReason); 
  void PasswordFlagsChanged(PRUint32 aFlagsAdded, PRUint32 aFlagsRemoved);
  void ChatStateChanged(PRUint32 aContactHandle, PRUint32 aChatState);

protected:
  ~csTPChannel();

  TpChannel *m_Channel;
  TpDBusDaemon *m_BusDaemon;
  TpConnection *m_Connection;

  /* Observer arrays for Channel */
  nsCOMPtr<nsIMutableArray> m_CloseObservers;
  nsCOMPtr<nsIMutableArray> m_ChannelReadyObservers;

  /* Observer arrays for ChannelGroup */
  nsCOMPtr<nsIMutableArray> m_GroupMembersChangeObservers;
  nsCOMPtr<nsIMutableArray> m_GroupFlagsChangeObservers;
  nsCOMPtr<nsIMutableArray> m_GroupHandleOwnersChangeObservers;
  nsCOMPtr<nsIMutableArray> m_GroupSelfHandleChangeObservers;

  /* Observer arrays for ChatState */
  nsCOMPtr<nsIMutableArray> m_ChatStateObservers;

  /* Observer arrays fro ChannelPassword */
  nsCOMPtr<nsIMutableArray> m_PasswordFlagsChangeObservers;

  /* Variables used by Group interface */
  PRUint32 m_GroupFlags;
  PRUint32 m_SelfHandle;

  CS_TELEPATHY_DECL_PROXY
};

#endif
