#! /bin/bash
# Copyright 2020 Yann MRN
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.

####################### LIBRARIES THAT CAN BE CALLED BEFORE G2S ####################

################## ECHO VERSION ##################################
check_appname_version() {
check_package_manager
APPNAME_VERSION=$($PACKVERSION $APPNAME )
G2S="glade2script$G2SPY_VERSION"; G2S_VERSION=$($PACKVERSION $G2S )  # dpkg-query -W -f='${Version}' paquet
[[ "$1" ]] && echo "$APPNAME version : $APPNAME_VERSION "
[[ "$DEBBUG" ]] && echo "G2S version : $G2S_VERSION"
}

#################### CHECK PACKAGE MANAGER ############################
check_package_manager() {
if [[ "$(type -p apt-get)" ]];then
	PACKMAN=apt-get
	PACKYES="-y"
	PACKINS=install
	PACKPURGE=purge
	PACKUPD="-y update"
	PACKVERSION='dpkg-query -W -f=${Version}'
elif [[ "$(type -p yum)" ]];then
	PACKMAN=yum
	PACKYES=-y
	PACKINS=install
	PACKPURGE=erase
	PACKUPD=makecache
	PACKVERSION='rpm -q --qf=%{version}'
elif [[ "$(type -p zypper)" ]];then
	PACKMAN='zypper --non-interactive'
	PACKYES=''
	PACKINS=in
	PACKPURGE=rm
	PACKUPD=ref
	PACKVERSION="zypper se -s --match-exact"
elif [[ "$(type -p pacman)" ]];then
	PACKMAN=pacman
	PACKYES='' #--noconfirm unrecognized
	PACKINS=-Sy
	PACKPURGE=-R
	PACKUPD="-Sy --noconfirm pacman; pacman-db-upgrade"
	PACKVERSION="pacman -Q"
else
    echo "Current distribution is not supported. Please use Boot-Repair-Disk."
	[[ "$GUI" ]] && zenity --width=400 --error --text"Current distribution is not supported. Please use Boot-Repair-Disk." 2>/dev/null
	choice="exit"; [[ "$GUI" ]] && echo 'EXIT@@' || exit 1
fi
}


######################### CHECK EFI PARTITIONS #########################
esp_check() {
#ESP with Windows bootmgr: http://ubuntuforums.org/showthread.php?t=2090605
part="${LISTOFPARTITIONS[$i]}" #eg mapper/isw_beaibbhjji_Volume0p1
d="${DISKNB_PART[$i]}"
f=""
while read line;do
	if [[ "$line" =~ /dev/ ]];then
		[[ "$line" =~ "/dev/${DISK_PART[$i]}:" ]] && f=ok || f=""
	fi #eg 11:162GB:162GB:210MB:fat32::boot, hidden;
	EFIPARTNUMERO="${line%%:*}" #eg 1
	#echo "[debug] WWW $line <$EFIPARTNUMERO>${part##*[a-z]}>" #
	if [[ "$EFIPARTNUMERO" = "${part##*[a-z]}" ]] && [[ "$f" ]];then
		if [[ "$(echo "$line" | grep fat | grep boot | grep -v hidden | grep -v ext4)" ]] \
		|| [[ "$(echo "$line" | grep fat | grep esp | grep -v hidden | grep -v ext4)" ]] \
		|| [[ "$(echo "$line" | grep fat | grep ':EFI system partition:' | grep -v hidden | grep -v ext4)" ]];then #exclude ext4 because hidden win esp: 3:548MB:1079MB:531MB:ext4:DUPFAT32:boot, hidden, esp;
			this_part_is_esp
		elif [[ "$(echo "$line" | grep fat | grep boot | grep -v ext4)" ]] \
		|| [[ "$(echo "$line" | grep fat | grep esp | grep -v ext4)" ]] \
		|| [[ "$(echo "$line" | grep fat | grep ':EFI system partition:' | grep -v ext4)" ]];then
			this_part_maybe_esp #hidden esp
		fi
	fi
done < <(echo "$PARTEDLM")
#if partedlm is broken, then checks EFI in fdisk
while read line;do 
	if [[ "$line" =~ "/dev/$part " ]];then
		#EFI working without GPT: http://forum.ubuntu-fr.org/viewtopic.php?pid=9962371#p9962371
		if [[ "$(echo "$line" | grep "dev/$part " | grep '*' | grep -i fat | grep -v ext4 | grep -vi ntfs | grep -v hidden)" ]] \
		|| [[ "$(echo "$line" | grep "dev/$part " | grep 'EFI' | grep -v ext4 | grep -v hidden)" ]];then #don't add grep fat here. https://launchpadlibrarian.net/299779679/Boot-Repair%20bug.txt
			#hidden partitions are shown as normal in fdisk, and some hidden win esp are shown as normal EFI
			this_part_is_in_partedlm=""
			f=""
			while read line;do
				if [[ "$line" =~ /dev/ ]];then
					[[ "$line" =~ "/dev/${DISK_PART[$i]}:" ]] && f=ok || f=""
				fi
				EFIPARTNUMERO="${line%%:*}" #eg 1
				if [[ "$EFIPARTNUMERO" = "${part##*[a-z]}" ]] && [[ "$f" ]];then
					this_part_is_in_partedlm=yes
				fi
			done < <(echo "$PARTEDLM")
			[[ ! "$this_part_is_in_partedlm" ]] && this_part_is_esp  #if partedlm is broken, then assumes it's ESP
		fi
	fi
done < <(echo "$FDISKL")
}

this_part_is_esp() {
if [[ "${EFI_TYPE[$i]}" != is---ESP ]];then
	[[ "${GPT_DISK[$d]}" = is-GPT ]] && (( NB_EFIPARTONGPT += 1 ))
	EFI_DISK[$d]=has---ESP
	EFI_TYPE[$i]=is---ESP
	(( NB_BISEFIPART += 1 ))
fi
}

this_part_maybe_esp() {
if [[ "${EFI_TYPE[$i]}" != is---ESP ]];then
	[[ "${EFI_DISK[$d]}" != has---ESP ]] && EFI_DISK[$d]=mayhavESP
	EFI_TYPE[$i]=maybeESP
fi
}

esp_detect() {
. /usr/share/boot-sav/bs-common.sh
blkid_fdisk_and_parted_update
check_blkid_partitions
for ((i=1;i<=NBOFPARTITIONS;i++)); do
	esp_check
	if [[ "${EFI_TYPE[$i]}" = is---ESP ]];then
		echo "${LISTOFPARTITIONS[$i]} is ESP"
	elif [[ "${EFI_TYPE[$i]}" = maybeESP ]];then
		echo "${LISTOFPARTITIONS[$i]} may be ESP"
	else
		echo "${LISTOFPARTITIONS[$i]} is not ESP"
	fi
done
}

########################## CHECK IF LIVE-SESSION #######################
check_if_live_session() {
local DR
DR="$(df / | grep /dev/ )"; DR="${DR%% *}"; DR="${DR#*v/}"
hash lsb_release && DISTRIB_DESCRIPTION="$(lsb_release -ds)" || DISTRIB_DESCRIPTION=Unknown-name
if [ "$(grep -E '(boot=casper)|(boot=live)' /proc/cmdline)" ] || [[ "$DR" =~ loop ]] || [[ "$(df -Th / | grep -E 'aufs|overlay')" ]];then #aufs bug#1281815, overlay since 19.10
	LIVESESSION=live   #if (mount | grep -E 'aufs|overlay' | grep -q 'on / type'); then live
else
	LIVESESSION=installed
	CURRENTSESSIONNAME="$The_system_now_in_use - $DISTRIB_DESCRIPTION"
	CURRENTSESSIONPARTITION="$DR"
fi
}


################################### CHECK EFI DMSG #####################
check_efi_dmesg() {
#http://forum.ubuntu-fr.org/viewtopic.php?id=742721
local ue="$(dmesg | grep EFI | grep -v Variables )"
SECUREBOOT='maybe enabled'
if [[ -d /sys/firmware/efi ]];then #http://paste.ubuntu.com/1176988
	EFIDMESG="BIOS is EFI-compatible, and is setup in EFI-mode for this $LIVESESSION-session."
	[[ ! "$ue" ]] && EFIDMESG="$EFIDMESG
No EFI in dmseg."
	#SecureBoot http://launchpadlibrarian.net/119223180/ubiquity_2.12.8_2.12.9.diff.gz
	local efi_vars sb_var
	efi_vars=/sys/firmware/efi/vars
	sb_var="$efi_vars/SecureBoot-8be4df61-93ca-11d2-aa0d-00e098032b8c/data"
	sb_var2="$efi_vars/SecureBoot-a8be4df61-93ca-11d2-aa0d-00e098032b8c/data"
	if [[ ! -d $efi_vars ]];then
		SECUREBOOT=disabled
	elif [[ -e "$sb_var" ]];then
		[[ "$(printf %x \'"$(cat "$sb_var")")" = 1 ]] && SECUREBOOT=enabled || SECUREBOOT=disabled
	elif [[ -e "$sb_var2" ]];then #http://paste.ubuntu.com/1643471
		[[ "$(printf %x \'"$(cat "$sb_var2")")" = 1 ]] && SECUREBOOT=enabled || SECUREBOOT=disabled
	else
		[[ -f "$sb_var" ]] || [[ -f "$sb_var2" ]] && echo "Warning: sbvar. $PLEASECONTACT"
		for tst in $(ls $efi_vars );do
            if [[ "$tst" =~ "Secure" ]];then
                if [ -e "$efi_vars/$tst/data" ];then
                    [ "$(printf %x \'"$(cat "$efi_vars/$tst/data")")" = 1 ] && SECUREBOOT=enabled || SECUREBOOT=disabled
                    EFIDMESG="$EFIDMESG
Found $efi_vars/$tst/data. $PLEASECONTACT"
                elif [[ -f "$efi_vars/$tst/data" ]];then
                    SECUREBOOT=disabled
                    EFIDMESG="$EFIDMESG
Warning: $tst/data . $PLEASECONTACT"
                fi
            fi
        done
#		a=""; for b in $(ls $efi_vars);do a="$b, $a";done
#		EFIDMESG="$EFIDMESG
#ls $efi_vars
#$a"
	fi
	if [[ "$SECUREBOOT" = 'maybe enabled' ]] && [[ "$(grep signed /proc/cmdline)" ]];then
		SECUREBOOT=enabled
		a=""; for b in $(ls $efi_vars);do a="$b,$a";done
		EFIDMESG="$EFIDMESG
Special SecureBoot - $PLEASECONTACT
ls $efi_vars : $a"
	fi
    [[ "$SECUREBOOT" != 'maybe enabled' ]] && EFIDMESG="$EFIDMESG
SecureBoot $SECUREBOOT."
	if [[ "$(type -p efibootmgr)" ]];then
		EFIDMESG="$EFIDMESG

efibootmgr -v
$(LANGUAGE=C LC_ALL=C efibootmgr -v)" # | sed 's|\\|\\\\|g'
	else
		EFIDMESG="$EFIDMESG
Please install package efibootmgr and retry."
	fi
else
	#[[ "$LIVESESSION" = installed ]] && SECUREBOOT=disabled
	if [[ "$WINEFIFILEPRESENCE" ]];then
		EFIDMESG="BIOS is EFI-compatible, but it is not setup in EFI-mode for this $LIVESESSION-session."
		#ex of efi win with no efi dmsg: http://paste.ubuntu.com/1079434 , http://paste.ubuntu.com/1088771
	elif [[ "$(lsb_release -is)" = Debian ]];then
		EFIDMESG="This $LIVESESSION-session is not in EFI-mode. See https://wiki.debian.org/UEFI"
	else # http://paste.ubuntu.com/1001831 , http://paste.ubuntu.com/966239 , http://paste.ubuntu.com/934497
		EFIDMESG="This $LIVESESSION-session is not in EFI-mode."
	fi
	[[ "$ue" ]] && EFIDMESG="$EFIDMESG
EFI in dmesg.
$ue" #ex: http://paste.ubuntu.com/1354258
fi
}

paragraph_syst_info(){
ECHO_ARCH_SECTION=""
[[ ! "$1" ]] && ECHO_ARCH_SECTION="$(title_gen "Architecture/Host Info" )
"
ECHO_ARCH_SECTION="$ECHO_ARCH_SECTION
CPU architecture: $ARCHIPC-bit"
[[ "$(uname -m)" =~ 64 ]] && LIVE_ARCH=64 || LIVE_ARCH=32
[[ "$LIVESESSION" != installed ]] && ECHO_ARCH_SECTION="$ECHO_ARCH_SECTION
Live-session OS is $(lsb_release -is) $LIVE_ARCH-bit ($DISTRIB_DESCRIPTION, $(lsb_release -cs), $(uname -m))"
[[ "$LIVESESSION" = installed ]] && ECHO_ARCH_SECTION="$ECHO_ARCH_SECTION
BOOT_IMAGE of the installed session in use:
$(cat /proc/cmdline | sed 's/BOOT_IMAGE=//g' )"
}

################################### TAIL COMMON LOGS #####################
# https://bugs.launchpad.net/boot-info/+bug/1719537
tail_common_logs() {
for ((i=1;i<=NBOFPARTITIONS;i++)); do
	for j in syslog kern.log Xorg.0.log dpkg.log journal;do
		if [[ -f "${BLKIDMNT_POINT[$i]}/var/log/$j" ]];then
			title_gen "tail -n $1 ${LISTOFPARTITIONS[$i]}/var/log/$j"
			tail -n $1 "${BLKIDMNT_POINT[$i]}/var/log/$j"
		fi
	done
done
}


bootinfo-cli() {
. /usr/share/boot-sav/gui-init.sh
translat_init
lib_init
check_os_and_mount_blkid_partitions_gui
check_which_mbr_can_be_restored
mainwindow_filling
warnings_and_show_mainwindow
UPLOAD="$1"
justbootinfo_br_and_bi
}


########################### CHECKS THE OS NAMES AND PARTITIONS AND TYPES ##################################
### TOTAL_QUANTITY_OF_OS must be initialized before first use
check_os_detected_by_os-prober() {
local ligne temp part disk tempp ADDOS m i
OSPROBER="$(os-prober)"
if [[ "$LIVESESSION" = installed ]];then
    #Add CurrentSession at the beginning of OSPROBER (so that GRUB reinstall of CurrentSession is selected by default)
    OSPROBER="/dev/${CURRENTSESSIONPARTITION}:$CURRENTSESSIONNAME CurrentSession:linux
$OSPROBER"
fi
if [[ "$OSPROBER" ]];then
	while read ligne; do
		if [[ "$ligne" =~ '/dev/' ]] && [[ "$ligne" =~ ':' ]] \
        && [[ ! "$ligne" =~ "@/efi/" ]] && [[ ! "$ligne" =~ "@/EFI/" ]] \
        && [[ ! "$(echo "$ligne" | grep indows | grep boot )" ]] \
        && [[ ! "$ligne" =~ '(boot)' ]];then #exclude 'Windows 10 (boot)' /dev/sda2@/efi/Microsoft/Boot/bootmgfw.efi:Windows Boot Manager:Windows:efi , or /dev/nvme0n1p1@/efi/Microsoft/Boot/bootmgfw.efi:Windows Boot Manager:Windows:efi
			temp=${ligne##*/dev/}
			part=${temp%%:*}
            ADDOS=yes
            for ((j=1;j<=TOTAL_QUANTITY_OF_OS;j++));do #To avoid duplicates since os-prober is run twice (bef and aft mount)
                [[ "${OS__PARTITION[$j]}" = "$part" ]] && ADDOS=""
            done
            if [[ "$ADDOS" ]];then
                (( TOTAL_QUANTITY_OF_OS += 1 ))
                OS__PARTITION[$TOTAL_QUANTITY_OF_OS]=$part			#e.g. "sda1" or "sdc10"
                determine_disk_from_part
                OS__DISK[$TOTAL_QUANTITY_OF_OS]=$disk				#e.g. "sda" or "sdc"
                tempp=${ligne#*:}
                OS__COMPLETE_NAME[$TOTAL_QUANTITY_OF_OS]=$tempp		#e.g. "Ubuntu 10.04.1 LTS (10.04):Ubuntu:linux" or "Windows 7:Windows:chain"
                temp=${tempp%%:*}									#e.g. "Ubuntu 10.04.1 LTS (10.04)"
                if [[ "$temp" ]];then
                    if [[ "$temp" =~ Ubuntu ]];then
                        OS__NAME[$TOTAL_QUANTITY_OF_OS]=${temp% (*}		#e.g. "Ubuntu 10.04.1 LTS"
                    else
                        OS__NAME[$TOTAL_QUANTITY_OF_OS]=${temp}		#e.g. "Windows 7"
                    fi
                else
                    OS__NAME[$TOTAL_QUANTITY_OF_OS]=${tempp#*:}		#e.g. "Arch:linux"
                fi
            fi
		fi
	done < <(echo "$OSPROBER")
fi
}

########################################### REMOVE STAGE1 FROM UNWANTED PARTITIONS #############################################
remove_stage1_from_other_os_partitions() {
[[ "$DEBBUG" ]] && echo "[debug]Remove_mislocated_stage1"
local i temp j
for ((i=1;i<=NBOFPARTITIONS;i++)); do
	if [[ -d "${BLKIDMNT_POINT[$i]}/Boot" ]] || [[ -d "${BLKIDMNT_POINT[$i]}/BOOT" ]] && [[ -d "${BLKIDMNT_POINT[$i]}/boot" ]];then
		temp=0
		for j in $(ls "${BLKIDMNT_POINT[$i]}/"); do #For fat (case insensitive)
			[[ "$j" = Boot ]] || [[ "$j" = BOOT ]] || [[ "$j" = boot ]] && (( temp += 1 ))
		done
		if [[ "$temp" != 1 ]];then
			echo "
$DASH Several ($temp) /boot folders exist in ${LISTOFPARTITIONS[$i]}/ and may disturb os-prober, boot renamed into oldbooot."
			mv "${BLKIDMNT_POINT[$i]}/boot" "${BLKIDMNT_POINT[$i]}/oldbooot"
		fi
	fi
	if [[ -f "${BLKIDMNT_POINT[$i]}/boot.ini" ]] || [[ -f "${BLKIDMNT_POINT[$i]}/ntldr" ]] \
	|| [[ -f "${BLKIDMNT_POINT[$i]}/bootmgr" ]] || [[ -f "${BLKIDMNT_POINT[$i]}/Windows/System32/winload.exe" ]] \
	&& [[ ! -d "${BLKIDMNT_POINT[$i]}/selinux" ]];then
		if [[ -d "${BLKIDMNT_POINT[$i]}/boot/grub" ]];then
			echo "
GRUB detected inside Windows partition. ${LISTOFPARTITIONS[$i]}/boot/grub renamed into boot/grub_old"
			mv "${BLKIDMNT_POINT[$i]}/boot/grub" "${BLKIDMNT_POINT[$i]}/boot/grub_old"
		fi
		if [[ -d "${BLKIDMNT_POINT[$i]}/grub" ]];then
			echo "
GRUB detected inside Windows partition. ${LISTOFPARTITIONS[$i]}/grub renamed into grub_old"
			mv "${BLKIDMNT_POINT[$i]}/grub" "${BLKIDMNT_POINT[$i]}/grub_old"
		fi
	#elif [[ -d "${BLKIDMNT_POINT[$i]}/selinux" ]] && [[ -d "${BLKIDMNT_POINT[$i]}/grub" ]];then
	#	echo "/grub detected inside a Linux partition. Rename ${BLKIDMNT_POINT[$i]}/grub into grub_old"
	#	mv "${BLKIDMNT_POINT[$i]}/grub" "${BLKIDMNT_POINT[$i]}/grub_old"
	fi
done
}


## generates the ${name}${file} title bar to always be 80 characters in length. ##
title_gen() {
  local name_file name_file_length equal_signs_line_length equal_signs_line;
  name_file="${1}${2}";
  name_file_length=${#name_file};
  equal_signs_line_length=$(((80-${name_file_length})/2-1));
  # Build "===" string.
  printf -v equal_signs_line "%${equal_signs_line_length}s";
  printf -v equal_signs_line "%s" "${equal_signs_line// /=}";
  if [ "$((${name_file_length}%2))" -eq 1 ]; then
     # If ${name_file_length} is odd, add an extra "=" at the end.
     printf "\n%s %s %s=\n\n" "${equal_signs_line}" "${name_file}" "${equal_signs_line}"
  else
     printf "\n%s %s %s\n\n" "${equal_signs_line}" "${name_file}" "${equal_signs_line}"
  fi
}
