/*********************************************************************/
// webdar - a web server and interface program to libdar
// Copyright (C) 2013-2025 Denis Corbin
//
// This file is part of Webdar
//
//  Webdar is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  Webdar is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with Webdar.  If not, see <http://www.gnu.org/licenses/>
//
//----
//  to contact the author: dar.linux@free.fr
/*********************************************************************/

#ifndef HTML_DOUBLE_BUTTON_HPP
#define HTML_DOUBLE_BUTTON_HPP

    // C system header files
#include "my_config.h"
extern "C"
{

}

    // C++ system header files
#include <string>

    // webdar headers
#include "events.hpp"
#include "actor.hpp"
#include "html_static_url.hpp"
#include "html_div.hpp"
#include "css_class_group.hpp"
#include "html_button.hpp"

    /// html_button equivalent with changing path to trigger the button event

class html_double_button : public body_builder, public events, public actor
{
public:
    html_double_button(const std::string & label, const std::string & x_event_name);
    html_double_button(const html_double_button & ref) = delete;
    html_double_button(html_double_button && ref) noexcept = delete;
    html_double_button & operator = (const html_double_button & ref) = delete;
    html_double_button & operator = (html_double_button && ref) noexcept = delete;
    ~html_double_button() = default;

        /// the inherited add_css_class() applies to the html_div around, this one to the url inside
    void url_add_css_class(const std::string & name) { one.url_add_css_class(name); two.url_add_css_class(name); };

	/// add a several CSS classes at once for the url inside the double_button
    void url_add_css_class(const css_class_group & cg) { one.url_add_css_class(cg); two.url_add_css_class(cg); };

        /// the inherited add_css_class() applies to the html_div around, this one to the url inside
    void url_remove_css_class(const std::string & name) { one.url_remove_css_class(name); two.url_remove_css_class(name); };

        /// the inherited add_css_class() applies to the html_div around, this one to the url inside
    void url_clear_css_classes() { one.url_clear_css_classes(); two.url_clear_css_classes(); };

        /// the label is the text show for the URL
    void change_label(const std::string & label) { one.change_label(label); two.change_label(label); };

    std::string get_label() const { return one.get_label(); };

	/// get the URL that will lead this double_button to be clicked
    std::string get_url() const { return one.get_url(); };

	/// change the name of the event generating by a click on the html_double_button

	/// all registered actor are kept on the renamed event
    void change_event_name_to(const std::string & x_event_name) { one.change_event_name_to(x_event_name); two.change_event_name_to(x_event_name); };

	/// get the name of the event generated by this object
    const std::string & get_event_name() const { return one.get_event_name(); };

	/// whether to download or display the URL target
    void set_download(bool mode) { one.set_download(mode); two.set_download(mode); };

	/// change the filename to create on client/browser side if download is set to true
	/// \note providing a empty string get to the default behavior (no filename specified in URL)
    void set_filename(const std::string & name) { one.set_filename(name); two.set_filename(name); };

	/// inherited from actor
    virtual void on_event(const std::string & event_name) override;

	/// inherited from body_builder
    virtual void bind_to_anchor(const std::string & val) override { one.bind_to_anchor(val); two.bind_to_anchor(val); };

protected:

	/// inherited from body_builder
    virtual std::string inherited_get_body_part(const chemin & path,
						const request & req) override;

	/// inheroted from body_builder
    virtual void css_classes_have_changed() override;


private:
    static const std::string event_one;
    static const std::string event_two;

    std::string my_event_name;
    html_button one;
    html_button two;

    void swap(bool show_one);
};

#endif
