/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * Feebruary 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  VDKIMAGE_H
#define  VDKIMAGE_H

#include <vdk/vdkobj.h>
#include <vdk/rawpixbuf.h>
class VDKTooltip;
/*!
  \class VDKImage
  \brief Provides an image widget
  This widget should substitute VDKPixmap object that from now
  should be considered deprecated.
  \par TIP
  Constructing with <pixfile> or <pixdata> set to NULL will make
  only the inner event box. Thus allowing to construct an empty
  image that can be later initialized with SetImage().
  User should cast NULL to either char* or char** to avoid ambiguity
 */

class VDKImage: public VDKObject
{

protected:
  int width,height;
  VDKPixbuf* pixmap;
  GtkWidget* pixmapWid;
  VDKTooltip* tip;
  VDKPixbuf* oldRawPix;
public:
  /*!
    Constructor
    \param owner
    \param pixfile
    \param tip
   */
  VDKImage(VDKForm* owner,
	   const char* pixfile, 
	   char* tip = NULL,
	   bool sensitive = false);
  /*!
    Constructor
    \param owner
    \param pixdata
    \param tip
   */
  VDKImage(VDKForm* owner,
	    const char** pixdata, 
	   char* tip = NULL,
	   bool sensitive = false);
  /*!
    Destructor
  */
  virtual ~VDKImage();
  /*!
    Return image width
   */
  int Width() { return width; }
  /*!
    Return image height
   */
  int Height() { return height; }
  /*!
    Returns the pixbuf contained into VDKImage
   */
  VDKPixbuf* SetImage() { return oldRawPix; }
  /*!
    Change the raw pixbuf contained into VDKImage
    \param file pixbuf file
   */
  VDKPixbuf* SetImage(const char* file);
  /*!
    Change the raw pixmap contained into VDKImage
    \param newpix 
   */
  VDKPixbuf* SetImage(VDKPixbuf* newpix);
  /*!
    Change the raw pixbuf contained into VDKImage
    \param pixdata pixmap data
   */
  VDKPixbuf* SetImage(const char** pixdata);
};
#endif
