# 2025-05-27 Triage Log

A week dominated by new sources of noise. By and large there were not that many real changes to compiler performance. Some highlights of real change to focus on are an improvement in rustdoc that had large wins in a few key benchmarks and an improvement in trait selection that comes from moving from an if/else chain to pattern matching.

Triage done by **@rylev**.
Revision range: [59372f2c..2805e1dc](https://perf.rust-lang.org/?start=59372f2c81ba74554d9a71b12a4ed7f29adb33a2&end=2805e1dc4c18ed4c84d161502c48da870c56f68a&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.1%, 7.5%]    | 73    |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.1%, 6.8%]    | 34    |
| Improvements ✅ <br /> (primary)   | -4.0% | [-78.5%, -0.1%] | 41    |
| Improvements ✅ <br /> (secondary) | -6.2% | [-22.1%, -0.1%] | 28    |
| All ❌✅ (primary)                 | -1.0% | [-78.5%, 7.5%]  | 114   |


5 Regressions, 7 Improvements, 8 Mixed; 9 of them in rollups
45 artifact comparisons made in total

#### Regressions

Add `std::io::Seek` instance for `std::io::Take` [#138023](https://github.com/rust-lang/rust/pull/138023) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59372f2c81ba74554d9a71b12a4ed7f29adb33a2&end=60dabef95a3de3ec974dcb50926e4bfe743f078f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.0% | [1.0%, 3.0%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.0% | [1.0%, 1.0%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.0% | [1.0%, 3.0%] | 2     |
- Noise in newly added benchmarks.


update llvm-tools logic for `dist` and `install` steps [#140932](https://github.com/rust-lang/rust/pull/140932) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=28174fc1a0525888615c8bce8f4ecec13c85ecc6&end=6cab15c1aef39456d86ce51be6096088cb2ef1da&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0% | [3.0%, 3.0%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.4%, 0.4%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.0% | [3.0%, 3.0%] | 1     |
- Noise


Rollup of 7 pull requests [#141345](https://github.com/rust-lang/rust/pull/141345) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=356f2d077498d0ebe5ec4f9cfef04293a2b17611&end=462cc099c93b2915eef61c3fbc504588b41b27d1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1% | [0.1%, 0.1%] | 6     |
| Regressions ❌ <br /> (secondary)  | 1.1% | [0.8%, 1.4%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.1% | [0.1%, 0.1%] | 6     |
- All of the regressions seem like slight returns back to a previous mean so I don't think this merits an investigation.


Defer evaluating type system constants when they use infers or params [#140553](https://github.com/rust-lang/rust/pull/140553) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e7f4317ea0e891296163414c6f681ccec976abc3&end=52bf0cf795dfecc8b929ebb1c1e2545c3f41d4c9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.1%, 0.5%] | 15    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.1%, 0.5%] | 15    |
- perf regressions were expected, but checking with the author/reviewer to make sure the magnitude seen is still acceptable.


Rollup of 8 pull requests [#141567](https://github.com/rust-lang/rust/pull/141567) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=46264e6dfd8f0bacae05c520b4617e054d6ef990&end=95a2212587f1b8500af1ac630322b0cb2e030c61&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0% | [3.0%, 3.0%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.1% | [0.1%, 0.1%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.0% | [3.0%, 3.0%] | 1     |
- clap_derive is noisy, and has since gone back to its previous state.


#### Improvements

Rollup of 5 pull requests [#141270](https://github.com/rust-lang/rust/pull/141270) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=60dabef95a3de3ec974dcb50926e4bfe743f078f&end=a8e4c68dcb4dc1e48a0db294c5323cab0227fcb9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-2.8%, -1.1%] | 5     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary)                 | -1.5% | [-2.8%, -1.1%] | 5     |


Rollup of 7 pull requests [#141292](https://github.com/rust-lang/rust/pull/141292) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6cab15c1aef39456d86ce51be6096088cb2ef1da&end=444a62712a29e14d3b6147b51fd24e623496bf58&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-3.0%, -1.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.4%, -1.4%] | 1     |
| All ❌✅ (primary)                 | -2.3% | [-3.0%, -1.5%] | 2     |


Fast path for processing some obligations in the new solver [#141135](https://github.com/rust-lang/rust/pull/141135) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1d679446b01e65f9bc9ae609d0ae1e4a9c0ccaa3&end=d423c815a69bbcfb4abcd23a828b9a513c397632&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-5.0%, -0.1%] | 16    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Rollup of 6 pull requests [#141545](https://github.com/rust-lang/rust/pull/141545) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=88b3b520e852e01970c3f519339ba64ed3e7db6d&end=283db70ace62a0ae704a624e43b68c2ee44b87a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


interpret: do not force_allocate all return places [#141406](https://github.com/rust-lang/rust/pull/141406) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=95a2212587f1b8500af1ac630322b0cb2e030c61&end=b5eb9893f42a469d330046089539f908d4728384&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.6% | [-2.9%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.5% | [-4.6%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -1.6% | [-2.9%, -0.2%] | 2     |


Fold predicate fast path in canonicalizer and eager resolver [#141442](https://github.com/rust-lang/rust/pull/141442) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b5eb9893f42a469d330046089539f908d4728384&end=9c0bcb514f49cd1e6a30affb2fe4cfca060129a2&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -     | -               | 0     |
| Improvements ✅ <br /> (secondary) | -6.1% | [-15.7%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -     | -               | 0     |


Don't rerun goals if none of their vars have changed [#141500](https://github.com/rust-lang/rust/pull/141500) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c0bcb514f49cd1e6a30affb2fe4cfca060129a2&end=40d2563ea200f9327a8cb8b99a0fb82f75a7365c&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]    | 1     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.2%, -0.1%]  | 2     |
| Improvements ✅ <br /> (secondary) | -4.1% | [-17.9%, -0.3%] | 9     |
| All ❌✅ (primary)                 | -0.1% | [-0.2%, -0.1%]  | 2     |


#### Mixed

Match on lang item kind instead of using an if/else chain [#140386](https://github.com/rust-lang/rust/pull/140386) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c43786c9b7b8d8dcc3f9c604e0e3074c16ed69d3&end=356f2d077498d0ebe5ec4f9cfef04293a2b17611&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.7%, -0.1%] | 55    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 3     |
| All ❌✅ (primary)                 | -0.2% | [-0.7%, 0.7%]  | 57    |
- Improvements vastly outweigh regressions


Rollup of 7 pull requests [#141396](https://github.com/rust-lang/rust/pull/141396) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2eef47813f25df637026ce3288880e5c587abd92&end=912981a9eab199a6429d3c65a58f1b80487620ea&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |
- Small enough regressions that I don't think it warrants an investigation


Rollup of 7 pull requests [#141463](https://github.com/rust-lang/rust/pull/141463) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e88e85463468ce5d5ce468414eb69e3b15fa8d42&end=3e674b06b5c74adea662bd0b0b06450757994b16&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 1.2%]   | 4     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.0%, -1.0%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.0% | [-1.0%, -1.0%] | 1     |
- The only significant regression is in the new trait solver stress test, and that benchmark is still settling so I don't think it's worth a deeper look.


rustdoc: Speed up `TypeAliasPart::get` [#141421](https://github.com/rust-lang/rust/pull/141421) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=80c34983c63968c204096e79b9126c0039790741&end=105354db48223b7bf799b05d4dd3a412aca7bd05&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%   | [0.2%, 0.2%]    | 1     |
| Improvements ✅ <br /> (primary)   | -19.5% | [-78.7%, -0.3%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.2%  | [-0.2%, -0.2%]  | 1     |
| All ❌✅ (primary)                 | -19.5% | [-78.7%, -0.3%] | 8     |
- Pure rustdoc change, so coercions result is just noise.


Rollup of 6 pull requests [#141506](https://github.com/rust-lang/rust/pull/141506) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3de4f1ccf3873782fae2a3883d029ed3d4542581&end=038d599eda4fe3e3d78103fba51ee663df86dadf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0%  | [3.0%, 3.0%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 3.0%  | [3.0%, 3.0%]   | 1     |
- Noise in the clap benchmark


Use the fn_span when emitting function calls for better debug info. [#141372](https://github.com/rust-lang/rust/pull/141372) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=038d599eda4fe3e3d78103fba51ee663df86dadf&end=5e16c662062fd6dee91f0fe2a1580483488d80cf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.9%  | [2.8%, 3.0%]   | 2     |
| Improvements ✅ <br /> (primary)   | -2.8% | [-2.8%, -2.8%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.8% | [-2.8%, 0.3%]  | 3     |
- the big improvement is noise, but some of the regressions seem legit. It seems like perhaps more time is being spent in codegen_module which I suspect tracks well with the change here


Implement `advance_by` via `try_fold` for `Sized` iterators [#141086](https://github.com/rust-lang/rust/pull/141086) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aa57e46e24a4a08cc336325e92567b40b0c2ba62&end=88b3b520e852e01970c3f519339ba64ed3e7db6d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.6%, 3.0%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 3.6%  | [0.3%, 6.8%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 1.0%  | [-0.3%, 3.0%]  | 5     |
- the regression in clap is noise, but the regressions in ripgrep seem to be legit. This might just be more time spent in LLM crunching through things. 


Rollup of 10 pull requests [#141605](https://github.com/rust-lang/rust/pull/141605) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=40d2563ea200f9327a8cb8b99a0fb82f75a7365c&end=2805e1dc4c18ed4c84d161502c48da870c56f68a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.1%, 7.8%]   | 37    |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [0.2%, 2.6%]   | 26    |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.8%, -0.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 1.2%  | [-1.8%, 7.8%]  | 39    |
- Investigation into this is underway.

