# Dalli 4.0

This major version update contains several backwards incompatible changes.

## Breaking Changes

* **Ruby 3.1+ required** - Support for Ruby 2.6, 2.7, and 3.0 has been dropped.
* **Dalli::Server removed** - The deprecated `Dalli::Server` alias has been removed. Use `Dalli::Protocol::Binary` instead if you were referencing this directly.
* **:compression option removed** - Use `:compress` instead. The old option name was deprecated in 3.x.
* **close_on_fork removed** - Use `reconnect_on_fork` instead. The old method name was deprecated in 3.x.

## New Features

* **Security warning for Marshal** - Dalli now warns when using the default Marshal serializer, as deserializing untrusted data with Marshal can lead to remote code execution. Silence with `silence_marshal_warning: true` if you understand the risks, or switch to a safer serializer like JSON.
* **string_fastpath option** - New option to skip serialization for simple strings, improving performance for string-only workloads.
* **Meta protocol improvements** - Performance improvements for set operations when using the meta protocol.

## Other Changes

* Defense-in-depth input validation for stats command arguments
* Fix connection_pool 3.0 compatibility for Rack session store
* Fix session recovery after deletion
* Graceful reconnection when a fork is detected (instead of crashing)
* Support for SERVER_ERROR response from Memcached

## Migration Guide

1. **Update Ruby version** - Ensure you're running Ruby 3.1 or later.

2. **Update deprecated options** - If you use any of these, update them:
   ```ruby
   # Before
   Dalli::Client.new(servers, compression: true)

   # After
   Dalli::Client.new(servers, compress: true)
   ```

3. **Consider serializer security** - If you're caching user-controlled data, consider switching from Marshal to a safer serializer:
   ```ruby
   Dalli::Client.new(servers, serializer: JSON)
   ```

4. **Update Dalli::Server references** - If you referenced `Dalli::Server` directly (unlikely), update to `Dalli::Protocol::Binary`.
