# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.voice.v1.dialing_permissions.bulk_country_update import BulkCountryUpdateList
from twilio.rest.voice.v1.dialing_permissions.country import CountryList
from twilio.rest.voice.v1.dialing_permissions.settings import SettingsList


class DialingPermissionsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the DialingPermissionsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsList
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsList
        """
        super(DialingPermissionsList, self).__init__(version)

        # Path Solution
        self._solution = {}

        # Components
        self._countries = None
        self._settings = None
        self._bulk_country_updates = None

    @property
    def countries(self):
        """
        Access the countries

        :returns: twilio.rest.voice.v1.dialing_permissions.country.CountryList
        :rtype: twilio.rest.voice.v1.dialing_permissions.country.CountryList
        """
        if self._countries is None:
            self._countries = CountryList(self._version, )
        return self._countries

    @property
    def settings(self):
        """
        Access the settings

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsList
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsList
        """
        if self._settings is None:
            self._settings = SettingsList(self._version, )
        return self._settings

    @property
    def bulk_country_updates(self):
        """
        Access the bulk_country_updates

        :returns: twilio.rest.voice.v1.dialing_permissions.bulk_country_update.BulkCountryUpdateList
        :rtype: twilio.rest.voice.v1.dialing_permissions.bulk_country_update.BulkCountryUpdateList
        """
        if self._bulk_country_updates is None:
            self._bulk_country_updates = BulkCountryUpdateList(self._version, )
        return self._bulk_country_updates

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.DialingPermissionsList>'


class DialingPermissionsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the DialingPermissionsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsPage
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsPage
        """
        super(DialingPermissionsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DialingPermissionsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsInstance
        """
        return DialingPermissionsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.DialingPermissionsPage>'


class DialingPermissionsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the DialingPermissionsInstance

        :returns: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsInstance
        """
        super(DialingPermissionsInstance, self).__init__(version)

        # Context
        self._context = None
        self._solution = {}

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.DialingPermissionsInstance>'
