# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.maintenance.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ApplyUpdate(Resource):
    """Apply Update request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.maintenance.models.SystemData
    :ivar status: The status. Known values are: "Pending", "InProgress", "Completed", "RetryNow",
     "RetryLater", "NoUpdatesPending", "Cancel", and "Cancelled".
    :vartype status: str or ~azure.mgmt.maintenance.models.UpdateStatus
    :ivar resource_id: The resourceId.
    :vartype resource_id: str
    :ivar last_update_time: Last Update time.
    :vartype last_update_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "last_update_time": {"key": "properties.lastUpdateTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.UpdateStatus"]] = None,
        resource_id: Optional[str] = None,
        last_update_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status. Known values are: "Pending", "InProgress", "Completed",
         "RetryNow", "RetryLater", "NoUpdatesPending", "Cancel", and "Cancelled".
        :paramtype status: str or ~azure.mgmt.maintenance.models.UpdateStatus
        :keyword resource_id: The resourceId.
        :paramtype resource_id: str
        :keyword last_update_time: Last Update time.
        :paramtype last_update_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.resource_id = resource_id
        self.last_update_time = last_update_time


class ConfigurationAssignment(Resource):
    """Configuration Assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.maintenance.models.SystemData
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar maintenance_configuration_id: The maintenance configuration Id.
    :vartype maintenance_configuration_id: str
    :ivar resource_id: The unique resourceId.
    :vartype resource_id: str
    :ivar filter: Properties of the configuration assignment.
    :vartype filter: ~azure.mgmt.maintenance.models.ConfigurationAssignmentFilterProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "filter": {"key": "properties.filter", "type": "ConfigurationAssignmentFilterProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        filter: Optional["_models.ConfigurationAssignmentFilterProperties"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        :keyword maintenance_configuration_id: The maintenance configuration Id.
        :paramtype maintenance_configuration_id: str
        :keyword resource_id: The unique resourceId.
        :paramtype resource_id: str
        :keyword filter: Properties of the configuration assignment.
        :paramtype filter: ~azure.mgmt.maintenance.models.ConfigurationAssignmentFilterProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.maintenance_configuration_id = maintenance_configuration_id
        self.resource_id = resource_id
        self.filter = filter


class ConfigurationAssignmentFilterProperties(_serialization.Model):
    """Azure query for the update configuration.

    :ivar resource_types: List of allowed resources.
    :vartype resource_types: list[str]
    :ivar resource_groups: List of allowed resource groups.
    :vartype resource_groups: list[str]
    :ivar os_types: List of allowed operating systems.
    :vartype os_types: list[str]
    :ivar locations: List of locations to scope the query to.
    :vartype locations: list[str]
    :ivar tag_settings: Tag settings for the VM.
    :vartype tag_settings: ~azure.mgmt.maintenance.models.TagSettingsProperties
    """

    _attribute_map = {
        "resource_types": {"key": "resourceTypes", "type": "[str]"},
        "resource_groups": {"key": "resourceGroups", "type": "[str]"},
        "os_types": {"key": "osTypes", "type": "[str]"},
        "locations": {"key": "locations", "type": "[str]"},
        "tag_settings": {"key": "tagSettings", "type": "TagSettingsProperties"},
    }

    def __init__(
        self,
        *,
        resource_types: Optional[List[str]] = None,
        resource_groups: Optional[List[str]] = None,
        os_types: Optional[List[str]] = None,
        locations: Optional[List[str]] = None,
        tag_settings: Optional["_models.TagSettingsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_types: List of allowed resources.
        :paramtype resource_types: list[str]
        :keyword resource_groups: List of allowed resource groups.
        :paramtype resource_groups: list[str]
        :keyword os_types: List of allowed operating systems.
        :paramtype os_types: list[str]
        :keyword locations: List of locations to scope the query to.
        :paramtype locations: list[str]
        :keyword tag_settings: Tag settings for the VM.
        :paramtype tag_settings: ~azure.mgmt.maintenance.models.TagSettingsProperties
        """
        super().__init__(**kwargs)
        self.resource_types = resource_types
        self.resource_groups = resource_groups
        self.os_types = os_types
        self.locations = locations
        self.tag_settings = tag_settings


class ErrorDetails(_serialization.Model):
    """An error response details received from the Azure Maintenance service.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class InputLinuxParameters(_serialization.Model):
    """Input properties for patching a Linux machine.

    :ivar package_name_masks_to_exclude: Package names to be excluded for patching.
    :vartype package_name_masks_to_exclude: list[str]
    :ivar package_name_masks_to_include: Package names to be included for patching.
    :vartype package_name_masks_to_include: list[str]
    :ivar classifications_to_include: Classification category of patches to be patched.
    :vartype classifications_to_include: list[str]
    """

    _attribute_map = {
        "package_name_masks_to_exclude": {"key": "packageNameMasksToExclude", "type": "[str]"},
        "package_name_masks_to_include": {"key": "packageNameMasksToInclude", "type": "[str]"},
        "classifications_to_include": {"key": "classificationsToInclude", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        package_name_masks_to_exclude: Optional[List[str]] = None,
        package_name_masks_to_include: Optional[List[str]] = None,
        classifications_to_include: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_name_masks_to_exclude: Package names to be excluded for patching.
        :paramtype package_name_masks_to_exclude: list[str]
        :keyword package_name_masks_to_include: Package names to be included for patching.
        :paramtype package_name_masks_to_include: list[str]
        :keyword classifications_to_include: Classification category of patches to be patched.
        :paramtype classifications_to_include: list[str]
        """
        super().__init__(**kwargs)
        self.package_name_masks_to_exclude = package_name_masks_to_exclude
        self.package_name_masks_to_include = package_name_masks_to_include
        self.classifications_to_include = classifications_to_include


class InputPatchConfiguration(_serialization.Model):
    """Input configuration for a patch run.

    :ivar reboot_setting: Possible reboot preference as defined by the user based on which it would
     be decided to reboot the machine or not after the patch operation is completed. Known values
     are: "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or ~azure.mgmt.maintenance.models.RebootOptions
    :ivar windows_parameters: Input parameters specific to patching a Windows machine. For Linux
     machines, do not pass this property.
    :vartype windows_parameters: ~azure.mgmt.maintenance.models.InputWindowsParameters
    :ivar linux_parameters: Input parameters specific to patching Linux machine. For Windows
     machines, do not pass this property.
    :vartype linux_parameters: ~azure.mgmt.maintenance.models.InputLinuxParameters
    """

    _attribute_map = {
        "reboot_setting": {"key": "rebootSetting", "type": "str"},
        "windows_parameters": {"key": "windowsParameters", "type": "InputWindowsParameters"},
        "linux_parameters": {"key": "linuxParameters", "type": "InputLinuxParameters"},
    }

    def __init__(
        self,
        *,
        reboot_setting: Union[str, "_models.RebootOptions"] = "IfRequired",
        windows_parameters: Optional["_models.InputWindowsParameters"] = None,
        linux_parameters: Optional["_models.InputLinuxParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword reboot_setting: Possible reboot preference as defined by the user based on which it
         would be decided to reboot the machine or not after the patch operation is completed. Known
         values are: "IfRequired", "Never", and "Always".
        :paramtype reboot_setting: str or ~azure.mgmt.maintenance.models.RebootOptions
        :keyword windows_parameters: Input parameters specific to patching a Windows machine. For Linux
         machines, do not pass this property.
        :paramtype windows_parameters: ~azure.mgmt.maintenance.models.InputWindowsParameters
        :keyword linux_parameters: Input parameters specific to patching Linux machine. For Windows
         machines, do not pass this property.
        :paramtype linux_parameters: ~azure.mgmt.maintenance.models.InputLinuxParameters
        """
        super().__init__(**kwargs)
        self.reboot_setting = reboot_setting
        self.windows_parameters = windows_parameters
        self.linux_parameters = linux_parameters


class InputWindowsParameters(_serialization.Model):
    """Input properties for patching a Windows machine.

    :ivar kb_numbers_to_exclude: Windows KBID to be excluded for patching.
    :vartype kb_numbers_to_exclude: list[str]
    :ivar kb_numbers_to_include: Windows KBID to be included for patching.
    :vartype kb_numbers_to_include: list[str]
    :ivar classifications_to_include: Classification category of patches to be patched.
    :vartype classifications_to_include: list[str]
    :ivar exclude_kbs_requiring_reboot: Exclude patches which need reboot.
    :vartype exclude_kbs_requiring_reboot: bool
    """

    _attribute_map = {
        "kb_numbers_to_exclude": {"key": "kbNumbersToExclude", "type": "[str]"},
        "kb_numbers_to_include": {"key": "kbNumbersToInclude", "type": "[str]"},
        "classifications_to_include": {"key": "classificationsToInclude", "type": "[str]"},
        "exclude_kbs_requiring_reboot": {"key": "excludeKbsRequiringReboot", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kb_numbers_to_exclude: Optional[List[str]] = None,
        kb_numbers_to_include: Optional[List[str]] = None,
        classifications_to_include: Optional[List[str]] = None,
        exclude_kbs_requiring_reboot: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kb_numbers_to_exclude: Windows KBID to be excluded for patching.
        :paramtype kb_numbers_to_exclude: list[str]
        :keyword kb_numbers_to_include: Windows KBID to be included for patching.
        :paramtype kb_numbers_to_include: list[str]
        :keyword classifications_to_include: Classification category of patches to be patched.
        :paramtype classifications_to_include: list[str]
        :keyword exclude_kbs_requiring_reboot: Exclude patches which need reboot.
        :paramtype exclude_kbs_requiring_reboot: bool
        """
        super().__init__(**kwargs)
        self.kb_numbers_to_exclude = kb_numbers_to_exclude
        self.kb_numbers_to_include = kb_numbers_to_include
        self.classifications_to_include = classifications_to_include
        self.exclude_kbs_requiring_reboot = exclude_kbs_requiring_reboot


class ListApplyUpdate(_serialization.Model):
    """Response for ApplyUpdate list.

    :ivar value: The list of apply updates.
    :vartype value: list[~azure.mgmt.maintenance.models.ApplyUpdate]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplyUpdate]"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplyUpdate"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of apply updates.
        :paramtype value: list[~azure.mgmt.maintenance.models.ApplyUpdate]
        """
        super().__init__(**kwargs)
        self.value = value


class ListConfigurationAssignmentsResult(_serialization.Model):
    """Response for ConfigurationAssignments list.

    :ivar value: The list of configuration Assignments.
    :vartype value: list[~azure.mgmt.maintenance.models.ConfigurationAssignment]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigurationAssignment]"},
    }

    def __init__(self, *, value: Optional[List["_models.ConfigurationAssignment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of configuration Assignments.
        :paramtype value: list[~azure.mgmt.maintenance.models.ConfigurationAssignment]
        """
        super().__init__(**kwargs)
        self.value = value


class ListMaintenanceConfigurationsResult(_serialization.Model):
    """Response for MaintenanceConfigurations list.

    :ivar value: The list of maintenance Configurations.
    :vartype value: list[~azure.mgmt.maintenance.models.MaintenanceConfiguration]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MaintenanceConfiguration]"},
    }

    def __init__(self, *, value: Optional[List["_models.MaintenanceConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of maintenance Configurations.
        :paramtype value: list[~azure.mgmt.maintenance.models.MaintenanceConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value


class ListUpdatesResult(_serialization.Model):
    """Response for Updates list.

    :ivar value: The pending updates.
    :vartype value: list[~azure.mgmt.maintenance.models.Update]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Update]"},
    }

    def __init__(self, *, value: Optional[List["_models.Update"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The pending updates.
        :paramtype value: list[~azure.mgmt.maintenance.models.Update]
        """
        super().__init__(**kwargs)
        self.value = value


class MaintenanceConfiguration(Resource):  # pylint: disable=too-many-instance-attributes
    """Maintenance configuration record type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.maintenance.models.SystemData
    :ivar location: Gets or sets location of the resource.
    :vartype location: str
    :ivar tags: Gets or sets tags of the resource.
    :vartype tags: dict[str, str]
    :ivar namespace: Gets or sets namespace of the resource.
    :vartype namespace: str
    :ivar extension_properties: Gets or sets extensionProperties of the maintenanceConfiguration.
    :vartype extension_properties: dict[str, str]
    :ivar maintenance_scope: Gets or sets maintenanceScope of the configuration. Known values are:
     "Host", "Resource", "OSImage", "Extension", "InGuestPatch", "SQLDB", and "SQLManagedInstance".
    :vartype maintenance_scope: str or ~azure.mgmt.maintenance.models.MaintenanceScope
    :ivar visibility: Gets or sets the visibility of the configuration. The default value is
     'Custom'. Known values are: "Custom" and "Public".
    :vartype visibility: str or ~azure.mgmt.maintenance.models.Visibility
    :ivar install_patches: The input parameters to be passed to the patch run operation.
    :vartype install_patches: ~azure.mgmt.maintenance.models.InputPatchConfiguration
    :ivar start_date_time: Effective start date of the maintenance window in YYYY-MM-DD hh:mm
     format. The start date can be set to either the current date or future date. The window will be
     created in the time zone provided and adjusted to daylight savings according to that time zone.
    :vartype start_date_time: str
    :ivar expiration_date_time: Effective expiration date of the maintenance window in YYYY-MM-DD
     hh:mm format. The window will be created in the time zone provided and adjusted to daylight
     savings according to that time zone. Expiration date must be set to a future date. If not
     provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
    :vartype expiration_date_time: str
    :ivar duration: Duration of the maintenance window in HH:mm format. If not provided, default
     value will be used based on maintenance scope provided. Example: 05:00.
    :vartype duration: str
    :ivar time_zone: Name of the timezone. List of timezones can be obtained by executing
     [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC,
     W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
    :vartype time_zone: str
    :ivar recur_every: Rate at which a Maintenance window is expected to recur. The rate can be
     expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery:
     [Frequency as integer]['Day(s)']. If no frequency is provided, the default frequency is 1.
     Daily schedule examples are recurEvery: Day, recurEvery: 3Days.  Weekly schedule are formatted
     as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays
     Monday-Sunday]. Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week
     Saturday,Sunday. Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma
     separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First,
     Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No. of days)]. Offset
     value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month,
     recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery:
     Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday
     Offset6.
    :vartype recur_every: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "namespace": {"key": "properties.namespace", "type": "str"},
        "extension_properties": {"key": "properties.extensionProperties", "type": "{str}"},
        "maintenance_scope": {"key": "properties.maintenanceScope", "type": "str"},
        "visibility": {"key": "properties.visibility", "type": "str"},
        "install_patches": {"key": "properties.installPatches", "type": "InputPatchConfiguration"},
        "start_date_time": {"key": "properties.maintenanceWindow.startDateTime", "type": "str"},
        "expiration_date_time": {"key": "properties.maintenanceWindow.expirationDateTime", "type": "str"},
        "duration": {"key": "properties.maintenanceWindow.duration", "type": "str"},
        "time_zone": {"key": "properties.maintenanceWindow.timeZone", "type": "str"},
        "recur_every": {"key": "properties.maintenanceWindow.recurEvery", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        namespace: Optional[str] = None,
        extension_properties: Optional[Dict[str, str]] = None,
        maintenance_scope: Optional[Union[str, "_models.MaintenanceScope"]] = None,
        visibility: Optional[Union[str, "_models.Visibility"]] = None,
        install_patches: Optional["_models.InputPatchConfiguration"] = None,
        start_date_time: Optional[str] = None,
        expiration_date_time: Optional[str] = None,
        duration: Optional[str] = None,
        time_zone: Optional[str] = None,
        recur_every: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets or sets location of the resource.
        :paramtype location: str
        :keyword tags: Gets or sets tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword namespace: Gets or sets namespace of the resource.
        :paramtype namespace: str
        :keyword extension_properties: Gets or sets extensionProperties of the
         maintenanceConfiguration.
        :paramtype extension_properties: dict[str, str]
        :keyword maintenance_scope: Gets or sets maintenanceScope of the configuration. Known values
         are: "Host", "Resource", "OSImage", "Extension", "InGuestPatch", "SQLDB", and
         "SQLManagedInstance".
        :paramtype maintenance_scope: str or ~azure.mgmt.maintenance.models.MaintenanceScope
        :keyword visibility: Gets or sets the visibility of the configuration. The default value is
         'Custom'. Known values are: "Custom" and "Public".
        :paramtype visibility: str or ~azure.mgmt.maintenance.models.Visibility
        :keyword install_patches: The input parameters to be passed to the patch run operation.
        :paramtype install_patches: ~azure.mgmt.maintenance.models.InputPatchConfiguration
        :keyword start_date_time: Effective start date of the maintenance window in YYYY-MM-DD hh:mm
         format. The start date can be set to either the current date or future date. The window will be
         created in the time zone provided and adjusted to daylight savings according to that time zone.
        :paramtype start_date_time: str
        :keyword expiration_date_time: Effective expiration date of the maintenance window in
         YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to
         daylight savings according to that time zone. Expiration date must be set to a future date. If
         not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
        :paramtype expiration_date_time: str
        :keyword duration: Duration of the maintenance window in HH:mm format. If not provided, default
         value will be used based on maintenance scope provided. Example: 05:00.
        :paramtype duration: str
        :keyword time_zone: Name of the timezone. List of timezones can be obtained by executing
         [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC,
         W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
        :paramtype time_zone: str
        :keyword recur_every: Rate at which a Maintenance window is expected to recur. The rate can be
         expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery:
         [Frequency as integer]['Day(s)']. If no frequency is provided, the default frequency is 1.
         Daily schedule examples are recurEvery: Day, recurEvery: 3Days.  Weekly schedule are formatted
         as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays
         Monday-Sunday]. Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week
         Saturday,Sunday. Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma
         separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First,
         Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No. of days)]. Offset
         value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month,
         recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery:
         Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday
         Offset6.
        :paramtype recur_every: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.namespace = namespace
        self.extension_properties = extension_properties
        self.maintenance_scope = maintenance_scope
        self.visibility = visibility
        self.install_patches = install_patches
        self.start_date_time = start_date_time
        self.expiration_date_time = expiration_date_time
        self.duration = duration
        self.time_zone = time_zone
        self.recur_every = recur_every


class MaintenanceError(_serialization.Model):
    """An error response received from the Azure Maintenance service.

    :ivar error: Details of the error.
    :vartype error: ~azure.mgmt.maintenance.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Details of the error.
        :paramtype error: ~azure.mgmt.maintenance.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class Operation(_serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Display name of the operation.
    :vartype display: ~azure.mgmt.maintenance.models.OperationInfo
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: JSON
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationInfo"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        is_data_action: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Display name of the operation.
        :paramtype display: ~azure.mgmt.maintenance.models.OperationInfo
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: JSON
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties
        self.is_data_action = is_data_action


class OperationInfo(_serialization.Model):
    """Information about an operation.

    :ivar provider: Name of the provider.
    :vartype provider: str
    :ivar resource: Name of the resource type.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Name of the provider.
        :paramtype provider: str
        :keyword resource: Name of the resource type.
        :paramtype resource: str
        :keyword operation: Name of the operation.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(_serialization.Model):
    """Result of the List Operations operation.

    :ivar value: A collection of operations.
    :vartype value: list[~azure.mgmt.maintenance.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A collection of operations.
        :paramtype value: list[~azure.mgmt.maintenance.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class ScheduledEventApproveResponse(_serialization.Model):
    """Response of scheduled event acknowledge.

    :ivar value: Successfully Approved.
    :vartype value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Successfully Approved.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.maintenance.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.maintenance.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.maintenance.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.maintenance.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagSettingsProperties(_serialization.Model):
    """Tag filter information for the VM.

    :ivar tags: Dictionary of tags with its list of values.
    :vartype tags: dict[str, list[str]]
    :ivar filter_operator: Filter VMs by Any or All specified tags. Known values are: "All" and
     "Any".
    :vartype filter_operator: str or ~azure.mgmt.maintenance.models.TagOperators
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{[str]}"},
        "filter_operator": {"key": "filterOperator", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, List[str]]] = None,
        filter_operator: Optional[Union[str, "_models.TagOperators"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Dictionary of tags with its list of values.
        :paramtype tags: dict[str, list[str]]
        :keyword filter_operator: Filter VMs by Any or All specified tags. Known values are: "All" and
         "Any".
        :paramtype filter_operator: str or ~azure.mgmt.maintenance.models.TagOperators
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.filter_operator = filter_operator


class Update(_serialization.Model):
    """Maintenance update on a resource.

    :ivar maintenance_scope: The impact area. Known values are: "Host", "Resource", "OSImage",
     "Extension", "InGuestPatch", "SQLDB", and "SQLManagedInstance".
    :vartype maintenance_scope: str or ~azure.mgmt.maintenance.models.MaintenanceScope
    :ivar impact_type: The impact type. Known values are: "None", "Freeze", "Restart", and
     "Redeploy".
    :vartype impact_type: str or ~azure.mgmt.maintenance.models.ImpactType
    :ivar status: The status. Known values are: "Pending", "InProgress", "Completed", "RetryNow",
     "RetryLater", "NoUpdatesPending", "Cancel", and "Cancelled".
    :vartype status: str or ~azure.mgmt.maintenance.models.UpdateStatus
    :ivar impact_duration_in_sec: Duration of impact in seconds.
    :vartype impact_duration_in_sec: int
    :ivar not_before: Time when Azure will start force updates if not self-updated by customer
     before this time.
    :vartype not_before: ~datetime.datetime
    :ivar resource_id: The resourceId.
    :vartype resource_id: str
    """

    _attribute_map = {
        "maintenance_scope": {"key": "maintenanceScope", "type": "str"},
        "impact_type": {"key": "impactType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "impact_duration_in_sec": {"key": "impactDurationInSec", "type": "int"},
        "not_before": {"key": "notBefore", "type": "iso-8601"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        maintenance_scope: Optional[Union[str, "_models.MaintenanceScope"]] = None,
        impact_type: Optional[Union[str, "_models.ImpactType"]] = None,
        status: Optional[Union[str, "_models.UpdateStatus"]] = None,
        impact_duration_in_sec: Optional[int] = None,
        not_before: Optional[datetime.datetime] = None,
        resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword maintenance_scope: The impact area. Known values are: "Host", "Resource", "OSImage",
         "Extension", "InGuestPatch", "SQLDB", and "SQLManagedInstance".
        :paramtype maintenance_scope: str or ~azure.mgmt.maintenance.models.MaintenanceScope
        :keyword impact_type: The impact type. Known values are: "None", "Freeze", "Restart", and
         "Redeploy".
        :paramtype impact_type: str or ~azure.mgmt.maintenance.models.ImpactType
        :keyword status: The status. Known values are: "Pending", "InProgress", "Completed",
         "RetryNow", "RetryLater", "NoUpdatesPending", "Cancel", and "Cancelled".
        :paramtype status: str or ~azure.mgmt.maintenance.models.UpdateStatus
        :keyword impact_duration_in_sec: Duration of impact in seconds.
        :paramtype impact_duration_in_sec: int
        :keyword not_before: Time when Azure will start force updates if not self-updated by customer
         before this time.
        :paramtype not_before: ~datetime.datetime
        :keyword resource_id: The resourceId.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.maintenance_scope = maintenance_scope
        self.impact_type = impact_type
        self.status = status
        self.impact_duration_in_sec = impact_duration_in_sec
        self.not_before = not_before
        self.resource_id = resource_id
