//                                               -*- C++ -*-
/**
 *  @brief QWizardPage to define the design of experiments and the method of metamodel analysis
 *
 *  Copyright 2015-2025 EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef PERSALYS_INTROMETAMODELPAGE_HXX
#define PERSALYS_INTROMETAMODELPAGE_HXX

#include "persalys/DesignOfExperiment.hxx"
#include "persalys/Analysis.hxx"
#include "persalys/OutputsSelectionGroupBox.hxx"
#include "persalys/TemporaryLabel.hxx"

#include <QWizardPage>
#include <QComboBox>
#include <QStandardItemModel>
#include <QButtonGroup>

namespace PERSALYS
{

class PERSALYS_VIEW_API MetaModelIntroPage : public QWizardPage
{
  Q_OBJECT

public:
  enum Method {Chaos, Kriging, PolynomialRegression};

  explicit MetaModelIntroPage(QWidget* parent = nullptr);

  int nextId() const override;

  void initialize(const Analysis& analysis, QList<DesignOfExperiment> doesList);
  DesignOfExperiment getDesignOfExperiment() const;
  OT::Description getInterestVariables() const;
  int getMethodId() const;

  bool validatePage() override;

public slots:
  void updateDesignOfExperiment(int);
  void updateInterestVariables(QStringList);
signals:
  void designOfExperimentChanged(DesignOfExperiment);

private:
  QComboBox * doesComboBox_ = nullptr;
  QStandardItemModel * doesComboBoxModel_ = nullptr;
  QLabel * doeLabel_ = nullptr;
  OutputsSelectionGroupBox * outputsSelectionGroupBox_ = nullptr;
  QButtonGroup * methodGroup_ = nullptr;
  TemporaryLabel * errorMessageLabel_ = nullptr;
  OT::Description interestVariables_;
};
}
#endif
