Pass Tomb Basic
===

<!-- TOC -->

- [Introduction](#introduction)
- [Install](#install)
    - [Graveyard configuration](#graveyard-configuration)
- [Usage](#usage)
    - [Open a pass-tomb](#open-a-pass-tomb)
    - [Multiple identities](#multiple-identities)
    - [List your open pass-tombs](#list-your-open-pass-tombs)
    - [Close a pass-tomb](#close-a-pass-tomb)
- [Uninstall](#uninstall)
- [Status](#status)
- [Limitations](#limitations)

<!-- /TOC -->

# Introduction

This is an extension for `pass` and it supports any `tomb` file.

[Pass](https://www.passwordstore.org/) is the unix standard password manager.

[Tomb](https://www.dyne.org/software/tomb/) is a very handy script for creating and managing LUKS filesystems embedded in a file

The main idea is to join the two programs so that you can have a tomb or multiple tombs containing your passwords. I call these tombs "pass-tombs". With this extension you can easily open and close any "pass-tomb" and use `pass` as usual.

# Install

	cd /tmp
	git clone git@github.com:damko/pass-tomb-basic.git
	cd pass-tomb-basic
	sudo cp tomb-* /usr/lib/password-store/extensions
	sudo chmod +x /usr/lib/password-store/extensions

Edit your `~/.bashrc` (or your `~/.profile`) and add this content:
	
	# Enable pass extensions
	export PASSWORD_STORE_ENABLE_EXTENSIONS=true

	# Set pass default workspace. This will be tomb's mount point
	export PASS_STORE_DIR="${HOME}/.password-store";

	# Pass Tombs directory. This is where your pass-tombs live (:-D pun meant)
	export GRAVEYARD="${HOME}/.graveyard"

	# Pass Tombs' keys directory. This is where your pass-tombs' keys live.
	export GRAVEYARD_KEYS="${GRAVEYARD}/keys"

you can customize the paths as you like.

In your terminal:

	source ~/.bashrc
	mkdir -p ${GRAVEYARD}
	mkdir -p ${GRAVEYARD_KEYS}

## Graveyard configuration

The ${GRAVEYARD} directory contains your pass-tombs.

Create your pass-tombs using `tomb` as usual and save your tombs in your ${GRAVEYARD} directory.

A "pass-tomb" file name should follow this naming convention:

	"pass"-"identity_name".tomb

A "pass-tomb" key file name should follow this naming convention:

	"pass"-"identity_name".key.tomb

The ${GRAVEYARD} directory should look like this

	tree ${GRAVEYARD}
	├── keys
	│   ├── pass-id1.key.tomb
	│   ├── pass-id2.key.tomb
	│   ├── pass-id3.key.tomb
	│   └── pass-id4.key.tomb
	├── pass-id1.tomb
	├── pass-id2.tomb
	├── pass-id3.tomb
	├── pass-id4.tomb

# Usage

## Open a pass-tomb

Open a pass-tomb with this command:

	pass tomb-open _identity_name_

Expected output:

	tomb  .  Commanded to open tomb ~/.graveyard/pass-_identity-name_.tomb
	tomb  .  An active swap partition is detected...
	tomb (*) The undertaker found that all swap partitions are encrypted. Good.
	tomb  .  Valid tomb file found: ~/.graveyard/pass-_identity-name_.tomb
	tomb  .  Key is valid.
	tomb (*) Opening pass-_identity-name_ on ~/.password-store
	tomb  .  This tomb is a valid LUKS encrypted device.
	tomb  .  Cipher is "aes" mode "xts-plain64:sha256" hash "sha256"
	tomb  .  A password is required to use key ~/.graveyard/keys/pass-_identity-name_.key.tomb
	tomb  .  Password OK.
	tomb (*) Success unlocking tomb pass-_identity-name_
	tomb  .  Checking filesystem via /dev/loop0
	fsck from util-linux 2.29.2
	pass-_identity-name_: recovering journal
	pass-_identity-name_: clean, 18/3328 files, 1665/13312 blocks
	tomb (*) Success opening pass-_identity-name_.tomb on ~/.password-store
	tomb  .  Last visit by _username_(1000) from /dev/pts/2 on _hostname_
	tomb  .  on date Sat 29 Jul 2017 05:25:18 AM EEST

After this your pass-tomb is mounted in ~/.password-store and you can use `pass` as usual.

**NOTE**
If you have opened your just-created pass-tomb file, don't forget to initialize it by running for `pass`:

	pass init _your-gpg-id_

_ This means that your pass-tomb file will be protected, when closed, by the key that you forged during the creation of the tomb file while the content stored in the tomb file will be encrypted using your GPG key. Yes, double encryption.

Ex.: list your passwords with

	pass list

Expected output is something like:

	Password Store
	├── serverfault.com
	├── stackoverflow.com
	├── ...

## Multiple identities

This extension **does not** fordid to open a pass-tomb over another one already opened. Yes, it's a feature.

Basically, let's say that you open the pass-tomb for _id1_:

	pass tomb-open _id1_

but then you need to get a password from id2. You can do:

	pass tomb-open _id2_

This will mount id2's pass-tomb over id1's pass-tomb and then you can retrieve or edit any password for id2 without closing id1's pass-tomb.

Just be careful not to get confused among the multiple identities.

## List your open pass-tombs

List your mounted pass-tombs with:

	pass tomb-list

## Close a pass-tomb

	pass tomb-close _identity_name_

Expected outuput:

	tomb  .  Closing tomb [pass-_identity-name_] mounted on ~/.password-store
	tomb (*) Tomb [pass-_identity-name_] closed: your bones will rest in peace.
	tomb [E] I can't see any open tomb, may they all rest in peace.

# Uninstall

To uninstall this extension:

	sudo rm /usr/lib/password-store/extensions/tomb-*.bash

# Status

The development of this extension is in early stage but it's very simple code so it can be already used in "production", meaning that you can use it to open and close your pass-tombs without any issue.

# Limitations

* you can not create tomb files using this extension, so you have to create them using `tomb`
* you can not automatically close your pass-tombs after some time
* no bash autocompletion for the "tomb-" commands
* this extension, and `pass` and `tomb` as well, works only on unix based systems

