// sample code inspired by npm: bittorrent-tracker-client

var HTTPTracker = require('./client/http-tracker') // empty object in browser
var UDPTracker = require('./client/udp-tracker') // empty object in browser
var WebSocketTracker = require('./client/websocket-tracker')

function Client(protocol, announceUrl) {
	var self = this;
	if ((protocol === 'http:' || protocol === 'https:') &&
		typeof HTTPTracker === 'function') {
		return new HTTPTracker(self, announceUrl)
	} else if (protocol === 'udp:' && typeof UDPTracker === 'function') {
		return new UDPTracker(self, announceUrl)
	} else if ((protocol === 'ws:' || protocol === 'wss:')) {
		return new WebSocketTracker(self, announceUrl)
	}
	this.name = 'NULL';
}

module.exports = Client
