
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ValuePlotAttributes.h
    \\brief Definition of ValuePlot Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "ValuePlotWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


ValuePlotWrapper::ValuePlotWrapper(): valueplot_(new ValuePlot())

{

	
	
	ValuePlotBaseWrapper::object(valueplot_);
	
	
} 
ValuePlotWrapper::ValuePlotWrapper(ValuePlot* valueplot): valueplot_(valueplot)
{
	
	
	ValuePlotBaseWrapper::object(valueplot_);
	
} 

ValuePlotWrapper::~ValuePlotWrapper()
{
	
}

void ValuePlotWrapper::set(const MagRequest& request)
{
	
	
	
	ValuePlotBaseWrapper::set(request);
	

	if  (request.countValues("CONTOUR_GRID_VALUE_TYPE") ) {
		string type_value = request("CONTOUR_GRID_VALUE_TYPE");
		valueplot_->type_ = type_value;
		}
	
	
		string method_value = request.countValues("CONTOUR_GRID_VALUE_PLOT_TYPE") ?  (string) request("CONTOUR_GRID_VALUE_PLOT_TYPE") : "value";
	MagLog::debug() << " CONTOUR_GRID_VALUE_PLOT_TYPE set to " << method_value << endl;
	ValuePlotMethodWrapper* method_wrapper = 0;
	try
	{
		method_wrapper = SimpleFactory<ValuePlotMethodWrapper>::create(method_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << method_value << "] is not a valid value for method: reset to default -> [value]" << endl;
		method_wrapper = SimpleFactory<ValuePlotMethodWrapper>::create("value");
	}
	method_wrapper->set(request);
	valueplot_->method_ =  unique_ptr<ValuePlotMethod>(method_wrapper->object());
	delete method_wrapper;
	
}

void ValuePlotWrapper::print(ostream& out)  const
{
	out << "ValuePlotWrapper[]";
}


    



#include "ValuePlotMethodWrapper.h"

static SimpleObjectMaker<ValuePlotMethodWrapper> ValuePlot_contour_grid_value_plot_type_value_Wrapper("value");


#include "MarkerValuePlotMethodWrapper.h"
static SimpleObjectMaker<MarkerValuePlotMethod, ValuePlotMethod> ValuePlot_contour_grid_value_plot_type_marker ("marker");
static SimpleObjectMaker<MarkerValuePlotMethodWrapper, ValuePlotMethodWrapper> ValuePlot_contour_grid_value_plot_type_marker_wrapper ("marker");


#include "BothValuePlotMethodWrapper.h"
static SimpleObjectMaker<BothValuePlotMethod, ValuePlotMethod> ValuePlot_contour_grid_value_plot_type_both ("both");
static SimpleObjectMaker<BothValuePlotMethodWrapper, ValuePlotMethodWrapper> ValuePlot_contour_grid_value_plot_type_both_wrapper ("both");



