'\" t
.\" Manual page created with latex2man on Fri Aug 31 13:39:04 EEST 2012
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_BACKTRACE" "3" "31 August 2012" "Programming Library " "Programming Library "
.SH NAME
unw_backtrace
\-\- return backtrace for the calling program 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_backtrace(void **buffer,
int size);
.br
.PP
#include <execinfo.h>
.br
.PP
int
backtrace(void **buffer,
int size);
.br
.PP
.SH DESCRIPTION

.PP
unw_backtrace()
is a convenient routine for obtaining the backtrace for 
the calling program. The routine fills up to size
addresses in the array 
pointed by buffer\&.
The routine is only available for local unwinding. 
.PP
Note that many (but not all) systems provide practically identical function 
called backtrace().
The prototype for this function is usually obtained 
by including the <execinfo.h>
header file \-\- a prototype for 
backtrace()
is not provided by libunwind\&.
libunwind
weakly 
aliases backtrace()
to unw_backtrace(),
so when a program 
calling backtrace()
is linked against libunwind,
it may end up 
calling unw_backtrace().
.PP
.SH RETURN VALUE

.PP
The routine returns the number of addresses stored in the array pointed by 
buffer\&.
The return value may be zero to indicate that no addresses were 
stored. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_step(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
