## Contributing

We welcome contributions from anyone, even if you are new to open source. It
might sound daunting to contribute to a compiler at first, but please do, it is
not complicated. We will help you with any technical issues and help improve
your contribution so that it can be merged.

### Getting Started

To contribute, follow these steps:

1. **Fork the Repository**

    Fork the [LFortran repository](https://github.com/lfortran/lfortran) to 
    your GitHub account.

2. **Clone Your Fork**

   Clone your forked repository to your local machine:
   ```
   git clone https://github.com/<your-username>/lfortran.git
   cd lfortran
   ```

3. **Add the Upstream Repository**

    Add the original LFortran repository as the upstream remote.
    ```
    git remote add upstream https://github.com/lfortran/lfortran.git
    git fetch upstream --tags
    ```

4. **Install Dependencies and Build the Project**

    Follow the [installation guide](https://docs.lfortran.org/en/installation/#build-from-git) 
    to set up the required dependencies and build the project.

5. **Make Changes and Submit Your Contribution**

    Create a branch for your changes and make the necessary edits.
    When ready, push your changes to your fork and submit a Pull Request (PR) 
    against our repository at: https://github.com/lfortran/lfortran.

### Communication

If you have any questions or need help, please ask as at our
[mailinglist](https://groups.io/g/lfortran) or a
[chat](https://lfortran.zulipchat.com/).

### Code of Conduct

Please note that all participants of this project are expected to follow our
Code of Conduct. By participating in this project you agree to abide by its
terms. See [CODE_OF_CONDUCT.md](CODE_OF_CONDUCT.md).

### Licensing

By submitting a PR you agree to license your contribution under
the LFortran's BSD [license](LICENSE) unless explicitly noted otherwise.
