/* doscan - Denial Of Service Capable Auditing of Networks       -*- C++ -*-
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "utils.h"

#include <string>

std::string
quote(const std::string& source)
{
  std::string result;
  std::string::const_iterator p = source.begin();

  result.reserve(source.size() + 4);

  while (p != source.end()) {
    char ch = *p;
    switch (ch) {
    case '\t':
      result += '\\';
      result += 't';
      break;

    case '\r':
      result += '\\';
      result += 'r';
      break;

    case '\n':
      result += '\\';
      result += 'n';
      break;

    case '\\':
      result += '\\';
      result += '\\';
      break;

    default:
      if ((ch < ' ') || (ch > '~')) {
        // This assumes ASCII.
        result += '\\';
        result += '0' + ((ch >> 6) & 7);
        result += '0' + ((ch >> 3) & 7);
        result += '0' + (ch & 7);
      } else {
        result += *p;
      }
    }
    ++p;
  }

  return result;
}
