#!/bin/bash

. ../MasterTest.sh

# Clean
CleanFiles ptraj_netcdf.in trajectory.netcdf trajectory_test.mdcrd

TESTNAME='NetCDF tests'
Requires netcdf pnetcdf maxthreads 10

# Convert MDCRD to NETCDF and back again.
INPUT="ptraj_netcdf.in"
TOP="../tz2.truncoct.parm7"

cat > $INPUT <<EOF
trajin ../tz2.truncoct.crd
trajout trajectory.netcdf netcdf
EOF
RunCpptraj "Convert mdcrd -> NetCDF"
cat > $INPUT <<EOF
trajin trajectory.netcdf
trajout trajectory_test.mdcrd title "trajectory generated by ptraj"
EOF
RunCpptraj "Convert NetCDF -> mdcrd"
DoTest ../tz2.truncoct.crd trajectory_test.mdcrd

EndTest

exit 0
