/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PgView
extends PgRelation {
    private boolean declareColumnNames = false;
    private boolean materialized;
    private String query;
    private String with;
    private boolean temporary;
    private boolean recursive;

    public PgView(String string) {
        this.setName(string);
    }

    public void setDeclaredColumnNames(List<String> list) {
        assert (!this.declareColumnNames);
        assert (this.columns.isEmpty());
        if (list == null || list.isEmpty()) {
            return;
        }
        this.declareColumnNames = true;
        for (String string : list) {
            this.addColumn(new PgColumn(string));
        }
    }

    public List<String> getDeclaredColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.declareColumnNames) {
            return null;
        }
        for (PgColumn pgColumn : this.columns) {
            arrayList.add(pgColumn.getName());
        }
        return arrayList;
    }

    @Override
    public String getRelationKind() {
        if (this.materialized) {
            return "MATERIALIZED VIEW";
        }
        return "VIEW";
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(this.query.length() * 2);
        stringBuilder.append("CREATE ");
        stringBuilder.append(this.getRelationKind());
        stringBuilder.append(' ');
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        if (this.declareColumnNames) {
            assert (this.columns != null && !this.columns.isEmpty());
            stringBuilder.append(" (");
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(PgDiffUtils.getQuotedName(((PgColumn)this.columns.get(i)).getName()));
            }
            stringBuilder.append(')');
        }
        if (Objects.nonNull(this.with) && !this.with.isEmpty()) {
            stringBuilder.append(" WITH (");
            stringBuilder.append(this.with);
            stringBuilder.append(")");
        }
        stringBuilder.append(" AS");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\t");
        stringBuilder.append(this.query);
        stringBuilder.append(';');
        for (PgColumn pgColumn : this.getColumns()) {
            String string = pgColumn.getDefaultValue();
            if (string == null || string.isEmpty()) continue;
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("ALTER ");
            stringBuilder.append(this.getRelationKind());
            stringBuilder.append(' ');
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" ALTER COLUMN ");
            stringBuilder.append(PgDiffUtils.getQuotedName(pgColumn.getName()));
            stringBuilder.append(" SET DEFAULT ");
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        stringBuilder.append(this.getCommentDefinitionSQL());
        return stringBuilder.toString();
    }

    public void setMaterialized(boolean bl) {
        this.materialized = bl;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setWith(String string) {
        this.with = string;
    }

    public String getWith() {
        return this.with;
    }

    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public PgColumn getColumn(String string) {
        PgColumn pgColumn = super.getColumn(string);
        if (pgColumn == null && !this.declareColumnNames) {
            pgColumn = new PgColumn(string);
            this.addColumn(pgColumn);
        }
        return pgColumn;
    }

    @Override
    public boolean containsColumn(String string) {
        return true;
    }
}

