/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Props {
    static final long serialVersionUID = 1L;
    private final Properties hash = new Properties();
    private String header = new String();

    public void setHeader(String h) {
        this.header = h;
    }

    public void clear() {
        this.hash.clear();
    }

    public void remove(String key) {
        this.hash.remove(key);
    }

    public void set(String key, String value) {
        this.hash.setProperty(key, value);
    }

    public void set(String key, int value) {
        this.hash.setProperty(key, String.valueOf(value));
    }

    public void set(String key, boolean value) {
        this.hash.setProperty(key, String.valueOf(value));
    }

    public void set(String key, double value) {
        this.hash.setProperty(key, String.valueOf(value));
    }

    public String get(String key, String def) {
        String s = this.hash.getProperty(key, def);
        return this.removeComment(s);
    }

    public int get(String key, int def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        s = this.removeComment(s);
        return Props.parseString(s);
    }

    public int[] get(String key, int[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        s = this.removeComment(s);
        String[] members = s.split(",");
        int i = 0;
        while (i < members.length) {
            members[i] = Props.trim(members[i]);
            ++i;
        }
        int[] ret = new int[members.length];
        int i2 = 0;
        while (i2 < members.length) {
            ret[i2] = Props.parseString(members[i2]);
            ++i2;
        }
        return ret;
    }

    public String[] get(String key, String[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        s = this.removeComment(s);
        String[] members = s.split(",");
        int i = 0;
        while (i < members.length) {
            members[i] = Props.trim(members[i]);
            ++i;
        }
        return members;
    }

    public boolean get(String key, boolean def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        s = this.removeComment(s);
        return Boolean.valueOf(s);
    }

    public double get(String key, double def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        s = this.removeComment(s);
        return Double.valueOf(s);
    }

    public boolean save(String fname) {
        try {
            FileOutputStream f = new FileOutputStream(fname);
            this.hash.store(f, this.header);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean load(URL file) {
        try {
            InputStream f = file.openStream();
            this.hash.load(f);
            f.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean load(String fname) {
        try {
            FileInputStream f = new FileInputStream(fname);
            this.hash.load(f);
            f.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int parseString(String s) {
        int retval;
        if (s == null || s.length() == 0) {
            return -1;
        }
        if (s.charAt(0) == '0') {
            if (s.length() == 1) {
                return 0;
            }
            if (s.length() > 2 && s.charAt(1) == 'x') {
                return Integer.parseInt(s.substring(2), 16);
            }
            if (s.charAt(1) == 'b') {
                return Integer.parseInt(s.substring(2), 2);
            }
            return Integer.parseInt(s.substring(0), 8);
        }
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = 0;
        }
        return retval;
    }

    private String removeComment(String s) {
        int pos = s.indexOf(35);
        if (pos != -1) {
            return s.substring(0, pos);
        }
        return s;
    }

    private static String trim(String s) {
        int spos = 0;
        while (spos < s.length()) {
            if (s.charAt(spos) != ' ') break;
            ++spos;
        }
        int epos = s.length() - 1;
        while (epos > spos) {
            if (s.charAt(epos) != ' ') break;
            --epos;
        }
        return s.substring(spos, epos + 1);
    }
}

