/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class Palette {
    private final int size;
    private final byte[] r;
    private final byte[] g;
    private final byte[] b;
    private final byte[] a;
    private final byte[] y;
    private final byte[] cb;
    private final byte[] cr;
    private final boolean useBT601;

    static int[] YCbCr2RGB(int y, int cb, int cr, boolean useBT601) {
        double b;
        double g;
        double r;
        int[] rgb = new int[3];
        cb -= 128;
        cr -= 128;
        double y1 = (double)(y -= 16) * 1.164383562;
        if (useBT601) {
            r = y1 + (double)cr * 1.596026317;
            g = y1 - (double)cr * 0.8129674985 - (double)cb * 0.3917615979;
            b = y1 + (double)cb * 2.017232218;
        } else {
            r = y1 + (double)cr * 1.792741071;
            g = y1 - (double)cr * 0.5329093286 - (double)cb * 0.2132486143;
            b = y1 + (double)cb * 2.112401786;
        }
        rgb[0] = (int)(r + 0.5);
        rgb[1] = (int)(g + 0.5);
        rgb[2] = (int)(b + 0.5);
        int i = 0;
        while (i < 3) {
            if (rgb[i] < 0) {
                rgb[i] = 0;
            } else if (rgb[i] > 255) {
                rgb[i] = 255;
            }
            ++i;
        }
        return rgb;
    }

    static int[] RGB2YCbCr(int r, int g, int b, boolean useBT601) {
        double cr;
        double cb;
        double y;
        int[] yCbCr = new int[3];
        if (useBT601) {
            y = (double)r * 0.299 * 219.0 / 255.0 + (double)g * 0.587 * 219.0 / 255.0 + (double)b * 0.114 * 219.0 / 255.0;
            cb = (double)(-r) * 0.168736 * 224.0 / 255.0 - (double)g * 0.331264 * 224.0 / 255.0 + (double)b * 0.5 * 224.0 / 255.0;
            cr = (double)r * 0.5 * 224.0 / 255.0 - (double)g * 0.418688 * 224.0 / 255.0 - (double)b * 0.081312 * 224.0 / 255.0;
        } else {
            y = (double)r * 0.2126 * 219.0 / 255.0 + (double)g * 0.7152 * 219.0 / 255.0 + (double)b * 0.0722 * 219.0 / 255.0;
            cb = (double)(-r) * 0.2126 / 1.8556 * 224.0 / 255.0 - (double)g * 0.7152 / 1.8556 * 224.0 / 255.0 + (double)b * 0.5 * 224.0 / 255.0;
            cr = (double)r * 0.5 * 224.0 / 255.0 - (double)g * 0.7152 / 1.5748 * 224.0 / 255.0 - (double)b * 0.0722 / 1.5748 * 224.0 / 255.0;
        }
        yCbCr[0] = 16 + (int)(y + 0.5);
        yCbCr[1] = 128 + (int)(cb + 0.5);
        yCbCr[2] = 128 + (int)(cr + 0.5);
        int i = 0;
        while (i < 3) {
            if (yCbCr[i] < 16) {
                yCbCr[i] = 16;
            } else if (i == 0) {
                if (yCbCr[i] > 235) {
                    yCbCr[i] = 235;
                }
            } else if (yCbCr[i] > 240) {
                yCbCr[i] = 240;
            }
            ++i;
        }
        return yCbCr;
    }

    public Palette(int palSize, boolean use601) {
        this.size = palSize;
        this.useBT601 = use601;
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        this.a = new byte[this.size];
        this.y = new byte[this.size];
        this.cb = new byte[this.size];
        this.cr = new byte[this.size];
        int[] yCbCr = Palette.RGB2YCbCr(0, 0, 0, this.useBT601);
        int i = 0;
        while (i < palSize) {
            this.a[i] = 0;
            this.r[i] = 0;
            this.g[i] = 0;
            this.b[i] = 0;
            this.y[i] = (byte)yCbCr[0];
            this.cb[i] = (byte)yCbCr[1];
            this.cr[i] = (byte)yCbCr[2];
            ++i;
        }
    }

    public Palette(int palSize) {
        this(palSize, false);
    }

    public Palette(byte[] red, byte[] green, byte[] blue, byte[] alpha, boolean use601) {
        this.size = red.length;
        this.useBT601 = use601;
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        this.a = new byte[this.size];
        this.y = new byte[this.size];
        this.cb = new byte[this.size];
        this.cr = new byte[this.size];
        int i = 0;
        while (i < this.size) {
            this.a[i] = alpha[i];
            this.r[i] = red[i];
            this.g[i] = green[i];
            this.b[i] = blue[i];
            int[] yCbCr = Palette.RGB2YCbCr(this.r[i] & 0xFF, this.g[i] & 0xFF, this.b[i] & 0xFF, this.useBT601);
            this.y[i] = (byte)yCbCr[0];
            this.cb[i] = (byte)yCbCr[1];
            this.cr[i] = (byte)yCbCr[2];
            ++i;
        }
    }

    public Palette(byte[] red, byte[] green, byte[] blue, byte[] alpha) {
        this(red, green, blue, alpha, false);
    }

    public Palette(Palette p) {
        this.size = p.getSize();
        this.useBT601 = p.usesBT601();
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        this.a = new byte[this.size];
        this.y = new byte[this.size];
        this.cb = new byte[this.size];
        this.cr = new byte[this.size];
        int i = 0;
        while (i < this.size) {
            this.a[i] = p.a[i];
            this.r[i] = p.r[i];
            this.g[i] = p.g[i];
            this.b[i] = p.b[i];
            this.y[i] = p.y[i];
            this.cb[i] = p.cb[i];
            this.cr[i] = p.cr[i];
            ++i;
        }
    }

    public ColorModel getColorModel() {
        return new IndexColorModel(8, this.size, this.r, this.g, this.b, this.a);
    }

    public void setColor(int index, Color c) {
        this.setRGB(index, c.getRed(), c.getGreen(), c.getBlue());
        this.setAlpha(index, c.getAlpha());
    }

    public void setARGB(int index, int c) {
        int a1 = c >> 24 & 0xFF;
        int r1 = c >> 16 & 0xFF;
        int g1 = c >> 8 & 0xFF;
        int b1 = c & 0xFF;
        this.setRGB(index, r1, g1, b1);
        this.setAlpha(index, a1);
    }

    public Color getColor(int index) {
        return new Color(this.r[index] & 0xFF, this.g[index] & 0xFF, this.b[index] & 0xFF, this.a[index] & 0xFF);
    }

    public int getARGB(int index) {
        return (this.a[index] & 0xFF) << 24 | (this.r[index] & 0xFF) << 16 | (this.g[index] & 0xFF) << 8 | this.b[index] & 0xFF;
    }

    public Color[] getColors() {
        Color[] c = new Color[this.size];
        int i = 0;
        while (i < this.size) {
            c[i] = this.getColor(i);
            ++i;
        }
        return c;
    }

    public void setRGB(int index, int red, int green, int blue) {
        this.r[index] = (byte)red;
        this.g[index] = (byte)green;
        this.b[index] = (byte)blue;
        int[] yCbCr = Palette.RGB2YCbCr(red, green, blue, this.useBT601);
        this.y[index] = (byte)yCbCr[0];
        this.cb[index] = (byte)yCbCr[1];
        this.cr[index] = (byte)yCbCr[2];
    }

    public void setYCbCr(int index, int yn, int cbn, int crn) {
        this.y[index] = (byte)yn;
        this.cb[index] = (byte)cbn;
        this.cr[index] = (byte)crn;
        int[] rgb = Palette.YCbCr2RGB(yn, cbn, crn, this.useBT601);
        this.r[index] = (byte)rgb[0];
        this.g[index] = (byte)rgb[1];
        this.b[index] = (byte)rgb[2];
    }

    public void setAlpha(int index, int alpha) {
        this.a[index] = (byte)alpha;
    }

    public int getAlpha(int index) {
        return this.a[index] & 0xFF;
    }

    public byte[] getAlpha() {
        return this.a;
    }

    public int[] getRGB(int index) {
        int[] rgb = new int[]{this.r[index] & 0xFF, this.g[index] & 0xFF, this.b[index] & 0xFF};
        return rgb;
    }

    public int[] getYCbCr(int index) {
        int[] yCbCr = new int[]{this.y[index] & 0xFF, this.cb[index] & 0xFF, this.cr[index] & 0xFF};
        return yCbCr;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getG() {
        return this.g;
    }

    public byte[] getB() {
        return this.b;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getCb() {
        return this.cb;
    }

    public byte[] getCr() {
        return this.cr;
    }

    public int getSize() {
        return this.size;
    }

    public int getTransparentIndex() {
        int transpIdx = 0;
        int minAlpha = 256;
        int i = 0;
        while (i < this.size) {
            if ((this.a[i] & 0xFF) < minAlpha) {
                minAlpha = this.a[i] & 0xFF;
                transpIdx = i;
                if (minAlpha == 0) break;
            }
            ++i;
        }
        return transpIdx;
    }

    public boolean usesBT601() {
        return this.useBT601;
    }
}

