/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.ColorDialog;
import deadbeef.GUI.ConversionDialog;
import deadbeef.GUI.EditDialog;
import deadbeef.GUI.EditPane;
import deadbeef.GUI.ExportDialog;
import deadbeef.GUI.FramePalDialog;
import deadbeef.GUI.GfxPane;
import deadbeef.GUI.Help;
import deadbeef.GUI.MoveDialog;
import deadbeef.GUI.MyComboBoxEditor;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.Palette;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class MainFrame
extends JFrame
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPaneSrc = null;
    private JScrollPane jScrollPaneTrg = null;
    private JPanel jPanelUp = null;
    private JPanel jPanelDown = null;
    private JLabel jLabelAlphaThr = null;
    private JLabel jLabelHiMedThr = null;
    private JLabel jLabelMedLowThr = null;
    private JLabel jLabelOutFormat = null;
    private GfxPane jPanelSrc = null;
    private GfxPane jPanelTrg = null;
    private JComboBox jComboBoxSubNum = null;
    private JLabel jLabelSubNum = null;
    private JComboBox jComboBoxAlphaThr = null;
    private JComboBox jComboBoxHiMedThr = null;
    private JComboBox jComboBoxMedLowThr = null;
    private JComboBox jComboBoxOutFormat = null;
    private JLabel jLabelInfoSrc = null;
    private JLabel jLabelInfoTrg = null;
    private JPanel jPanelUp2 = null;
    private JPanel jPanelMid = null;
    private JMenuBar jMenuBar = null;
    private JMenu jMenuFile = null;
    private JMenuItem jMenuItemLoad = null;
    private JMenu jMenuRecent = null;
    private JMenuItem jMenuItemSave = null;
    private JMenuItem jMenuItemClose = null;
    private JMenuItem jMenuItemExit = null;
    private JMenu jMenuHelp = null;
    private JMenuItem jMenuItemHelp = null;
    private JMenu jMenuPrefs = null;
    private JMenuItem jMenuItemEditColors = null;
    private JMenuItem jMenuItemEditCurColors = null;
    private JMenuItem jMenuItemEditFramePalAlpha = null;
    private JMenuItem jMenuItemConversionSettings = null;
    private JCheckBoxMenuItem jMenuItemSwapCrCb = null;
    private JCheckBoxMenuItem jMenuItemVerbatim = null;
    private JCheckBoxMenuItem jMenuItemFixAlpha = null;
    private JMenu jMenuEdit = null;
    private JMenuItem jMenuItemEditFrame = null;
    private JMenuItem jMenuItemBatchMove = null;
    private JMenuItem jMenuItemResetCrop = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jPopupMenuItemCopy = null;
    private JMenuItem jPopupMenuItemClear = null;
    private JScrollPane jScrollPaneConsole = null;
    private JTextArea console = null;
    private EditPane jLayoutPane = null;
    private JComboBox jComboBoxPalette = null;
    private JLabel jLabelPalette = null;
    private JLabel jLabelFilter = null;
    private JComboBox jComboBoxFilter = null;
    private JTextField jTextSubNum = null;
    private JTextField jTextAlphaThr = null;
    private JTextField jTextHiMedThr = null;
    private JTextField jTextMedLowThr = null;
    private final Object threadSemaphore = new Object();
    private final JFrame mainFrame;
    private int subIndex;
    private String loadPath;
    private String saveFilename;
    private String savePath;
    private String colorPath;
    private final TransferHandler thandler;
    private final int fontSize = 12;
    private final Color errBgnd = new Color(-1987412);
    private final Color okBgnd = UIManager.getColor("TextField.background");

    public MainFrame(String fname) throws HeadlessException {
        this();
        this.loadPath = fname;
        this.load(fname);
    }

    public MainFrame() throws HeadlessException {
        this.jTextSubNum = new JTextField();
        this.jTextAlphaThr = new JTextField();
        this.jTextHiMedThr = new JTextField();
        this.jTextMedLowThr = new JTextField();
        this.initialize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                MainFrame.this.exit(0);
            }
        });
        ClassLoader loader = MainFrame.class.getClassLoader();
        Image img = Toolkit.getDefaultToolkit().getImage(loader.getResource("icon_32.png"));
        this.setIconImage(img);
        Core.setMainFrame(this);
        Core.init(this);
        int w = Core.props.get("frameWidth", 800);
        int h = Core.props.get("frameHeight", 600);
        this.setSize(w, h);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point p = ge.getCenterPoint();
        p.x -= this.getWidth() / 2;
        p.y -= this.getHeight() / 2;
        p.x = Core.props.get("framePosX", p.x);
        p.y = Core.props.get("framePosY", p.y);
        this.setLocation(p);
        this.loadPath = Core.props.get("loadPath", "");
        this.colorPath = Core.props.get("colorPath", "");
        this.mainFrame = this;
        this.subIndex = 0;
        this.updateRecentMenu();
        this.jComboBoxSubNum.setEditor(new MyComboBoxEditor(this.jTextSubNum));
        this.jComboBoxAlphaThr.setEditor(new MyComboBoxEditor(this.jTextAlphaThr));
        this.jComboBoxHiMedThr.setEditor(new MyComboBoxEditor(this.jTextHiMedThr));
        this.jComboBoxMedLowThr.setEditor(new MyComboBoxEditor(this.jTextMedLowThr));
        int i = 0;
        while (i < 256) {
            String s = Integer.toString(i);
            this.jComboBoxAlphaThr.addItem(s);
            this.jComboBoxHiMedThr.addItem(s);
            this.jComboBoxMedLowThr.addItem(s);
            ++i;
        }
        this.jComboBoxAlphaThr.setSelectedIndex(Core.getAlphaThr());
        this.jComboBoxHiMedThr.setSelectedIndex(Core.getLumThr()[0]);
        this.jComboBoxMedLowThr.setSelectedIndex(Core.getLumThr()[1]);
        Enum[] enumArray = Core.OutputMode.values();
        int n = enumArray.length;
        int s = 0;
        while (s < n) {
            Core.OutputMode m = enumArray[s];
            this.jComboBoxOutFormat.addItem(Core.getOutputFormatName(m));
            ++s;
        }
        this.jComboBoxOutFormat.setSelectedIndex(Core.getOutputMode().ordinal());
        enumArray = Core.PaletteMode.values();
        n = enumArray.length;
        s = 0;
        while (s < n) {
            Enum m = enumArray[s];
            this.jComboBoxPalette.addItem(Core.getPaletteModeName((Core.PaletteMode)m));
            ++s;
        }
        this.jComboBoxPalette.setSelectedIndex(Core.getPaletteMode().ordinal());
        enumArray = Core.ScalingFilters.values();
        n = enumArray.length;
        s = 0;
        while (s < n) {
            Enum s2 = enumArray[s];
            this.jComboBoxFilter.addItem(Core.getScalingFilterName((Core.ScalingFilters)s2));
            ++s;
        }
        this.jComboBoxFilter.setSelectedIndex(Core.getScalingFilter().ordinal());
        this.jMenuItemVerbatim.setSelected(Core.getVerbatim());
        this.jMenuItemFixAlpha.setSelected(Core.getFixZeroAlpha());
        Font f = new Font("Monospaced", 0, 12);
        this.console.setFont(f);
        this.getJPopupMenu();
        PopupListener popupListener = new PopupListener();
        this.console.addMouseListener(popupListener);
        this.setVisible(true);
        this.thandler = new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    MainFrame.this.load(((File)flist.get(0)).getAbsolutePath());
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        this.setTransferHandler(this.thandler);
        this.print(String.valueOf(Core.getProgVerName()) + " - a converter from Blu-Ray/HD-DVD SUP to DVD SUB/IDX and more\n");
        this.print(String.valueOf(Core.getAuthorDate()) + "\n");
        this.print("Official thread at Doom9: http://forum.doom9.org/showthread.php?t=145277\n\n");
        this.flush();
    }

    public void print(String s) {
        Document doc = this.console.getDocument();
        int length = doc.getLength();
        try {
            doc.insertString(length, s, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void flush() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.console.setCaretPosition(MainFrame.this.console.getDocument().getLength());
            }
        });
    }

    public void printOut(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.print(s);
            }
        });
    }

    public void printErr(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.print(s);
            }
        });
    }

    public void printWarn(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.print(s);
            }
        });
    }

    public void error(String s) {
        Core.printErr(s);
        JOptionPane.showMessageDialog(this.mainFrame, s, "Error!", 2);
    }

    private void refreshTrgFrame(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.jLayoutPane.setDim(Core.getTrgWidth(index), Core.getTrgHeight(index));
                MainFrame.this.jLayoutPane.setOffsets(Core.getTrgOfsX(index), Core.getTrgOfsY(index));
                MainFrame.this.jLayoutPane.setCropOfsY(Core.getCropOfsY());
                MainFrame.this.jLayoutPane.setImage(Core.getTrgImage(), Core.getTrgImgWidth(index), Core.getTrgImgHeight(index));
                MainFrame.this.jLayoutPane.setExcluded(Core.getTrgExcluded(index));
                MainFrame.this.jPanelTrg.setImage(Core.getTrgImage());
                MainFrame.this.printInfoTrg(index);
                MainFrame.this.jLayoutPane.repaint();
            }
        });
    }

    private void refreshSrcFrame(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage img = Core.getSrcImage();
                MainFrame.this.jPanelSrc.setImage(img);
                MainFrame.this.printInfoSrc(index);
            }
        });
    }

    private void exit(int code) {
        if (code == 0) {
            Dimension d = this.getSize();
            if (this.getExtendedState() != 6) {
                Core.props.set("frameWidth", d.width);
                Core.props.set("frameHeight", d.height);
                Point p = this.getLocation();
                Core.props.set("framePosX", p.x);
                Core.props.set("framePosY", p.y);
            }
            Core.props.set("loadPath", this.loadPath);
            Core.props.set("colorPath", this.colorPath);
        }
        Core.exit();
        System.exit(code);
    }

    private void setClipboard(String str) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(""), (ClipboardOwner)((Object)this.mainFrame));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), (ClipboardOwner)((Object)this.mainFrame));
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(700, 300));
        this.setJMenuBar(this.getjMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle(Core.getProgVerName());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelUp = new GridBagConstraints();
            gridBagPanelUp.gridx = 0;
            gridBagPanelUp.gridy = 0;
            gridBagPanelUp.anchor = 17;
            gridBagPanelUp.fill = 2;
            gridBagPanelUp.insets = new Insets(0, 4, 0, 4);
            gridBagPanelUp.weightx = 0.0;
            gridBagPanelUp.ipadx = 0;
            gridBagPanelUp.weighty = 0.0;
            GridBagConstraints gridBagPanelUp2 = new GridBagConstraints();
            gridBagPanelUp2.gridx = 0;
            gridBagPanelUp2.gridy = 1;
            gridBagPanelUp2.anchor = 18;
            gridBagPanelUp2.fill = 2;
            gridBagPanelUp2.insets = new Insets(4, 0, 0, 0);
            gridBagPanelUp2.weightx = 0.0;
            gridBagPanelUp2.weighty = 0.0;
            GridBagConstraints gridBagScrollPaneSup = new GridBagConstraints();
            gridBagScrollPaneSup.gridx = 0;
            gridBagScrollPaneSup.gridy = 2;
            gridBagScrollPaneSup.fill = 1;
            gridBagScrollPaneSup.anchor = 18;
            gridBagScrollPaneSup.weightx = 1.0;
            gridBagScrollPaneSup.weighty = 1.0;
            GridBagConstraints gridBagPanelMid = new GridBagConstraints();
            gridBagPanelMid.gridx = 0;
            gridBagPanelMid.gridy = 3;
            gridBagPanelMid.fill = 2;
            gridBagPanelMid.anchor = 17;
            gridBagPanelMid.gridwidth = 1;
            gridBagPanelMid.weighty = 0.0;
            gridBagPanelMid.weightx = 0.0;
            GridBagConstraints gridBagScrollPaneSub = new GridBagConstraints();
            gridBagScrollPaneSub.gridx = 0;
            gridBagScrollPaneSub.gridy = 4;
            gridBagScrollPaneSub.fill = 1;
            gridBagScrollPaneSub.anchor = 18;
            gridBagScrollPaneSub.weightx = 1.0;
            gridBagScrollPaneSub.weighty = 1.0;
            GridBagConstraints gridBagPanelDown = new GridBagConstraints();
            gridBagPanelDown.gridx = 0;
            gridBagPanelDown.gridy = 5;
            gridBagPanelDown.anchor = 16;
            gridBagPanelDown.fill = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setPreferredSize(new Dimension(800, 600));
            this.jContentPane.add((Component)this.getJPanelUp(), gridBagPanelUp);
            this.jContentPane.add((Component)this.getJPanelUp2(), gridBagPanelUp2);
            this.jContentPane.add((Component)this.getJScrollPaneSup(), gridBagScrollPaneSup);
            this.jContentPane.add((Component)this.getJPanelMid(), gridBagPanelMid);
            this.jContentPane.add((Component)this.getJScrollPaneSub(), gridBagScrollPaneSub);
            this.jContentPane.add((Component)this.getJPanelDown(), gridBagPanelDown);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPaneSup() {
        if (this.jScrollPaneSrc == null) {
            this.jScrollPaneSrc = new JScrollPane();
            this.jScrollPaneSrc.setHorizontalScrollBarPolicy(30);
            this.jScrollPaneSrc.setVerticalScrollBarPolicy(20);
            this.jScrollPaneSrc.setViewportView(this.getJPanelSup());
        }
        return this.jScrollPaneSrc;
    }

    private JScrollPane getJScrollPaneSub() {
        if (this.jScrollPaneTrg == null) {
            this.jScrollPaneTrg = new JScrollPane();
            this.jScrollPaneTrg.setViewportView(this.getJPanelSub());
        }
        return this.jScrollPaneTrg;
    }

    private JPanel getJPanelUp() {
        if (this.jPanelUp == null) {
            GridBagConstraints gridBagComboFilter = new GridBagConstraints();
            gridBagComboFilter.fill = 0;
            gridBagComboFilter.gridx = 7;
            gridBagComboFilter.gridy = 1;
            gridBagComboFilter.insets = new Insets(0, 4, 0, 4);
            gridBagComboFilter.anchor = 17;
            gridBagComboFilter.ipadx = 10;
            gridBagComboFilter.weightx = 5.0;
            GridBagConstraints gridBagLabelFilter = new GridBagConstraints();
            gridBagLabelFilter.gridx = 7;
            gridBagLabelFilter.anchor = 17;
            gridBagLabelFilter.insets = new Insets(0, 4, 0, 4);
            gridBagLabelFilter.gridy = 0;
            this.jLabelFilter = new JLabel();
            this.jLabelFilter.setPreferredSize(new Dimension(120, 20));
            this.jLabelFilter.setText("Filter");
            GridBagConstraints gridBagLabelPalette = new GridBagConstraints();
            gridBagLabelPalette.insets = new Insets(0, 4, 0, 4);
            gridBagLabelPalette.anchor = 17;
            gridBagLabelPalette.gridx = 6;
            gridBagLabelPalette.gridy = 0;
            this.jLabelPalette = new JLabel();
            this.jLabelPalette.setPreferredSize(new Dimension(120, 20));
            this.jLabelPalette.setText("Palette");
            GridBagConstraints gridBagComboPalette = new GridBagConstraints();
            gridBagComboPalette.fill = 0;
            gridBagComboPalette.gridx = 6;
            gridBagComboPalette.gridy = 1;
            gridBagComboPalette.anchor = 17;
            gridBagComboPalette.insets = new Insets(0, 4, 0, 4);
            gridBagComboPalette.ipadx = 10;
            gridBagComboPalette.weightx = 0.0;
            GridBagConstraints gridBagLabelSubNum = new GridBagConstraints();
            gridBagLabelSubNum.gridx = 0;
            gridBagLabelSubNum.gridy = 0;
            gridBagLabelSubNum.anchor = 17;
            gridBagLabelSubNum.insets = new Insets(0, 8, 0, 4);
            GridBagConstraints gridBagComboBoxSubNum = new GridBagConstraints();
            gridBagComboBoxSubNum.gridx = 0;
            gridBagComboBoxSubNum.gridy = 1;
            gridBagComboBoxSubNum.anchor = 17;
            gridBagComboBoxSubNum.ipadx = 10;
            gridBagComboBoxSubNum.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelAlphaThr = new GridBagConstraints();
            gridBagLabelAlphaThr.gridx = 1;
            gridBagLabelAlphaThr.gridy = 0;
            gridBagLabelAlphaThr.anchor = 17;
            gridBagLabelAlphaThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxAlphaThr = new GridBagConstraints();
            gridBagComboBoxAlphaThr.gridx = 1;
            gridBagComboBoxAlphaThr.gridy = 1;
            gridBagComboBoxAlphaThr.anchor = 17;
            gridBagComboBoxAlphaThr.ipadx = 10;
            gridBagComboBoxAlphaThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelMedLowThr = new GridBagConstraints();
            gridBagLabelMedLowThr.gridx = 2;
            gridBagLabelMedLowThr.gridy = 0;
            gridBagLabelMedLowThr.anchor = 17;
            gridBagLabelMedLowThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxMedLowThr = new GridBagConstraints();
            gridBagComboBoxMedLowThr.gridx = 2;
            gridBagComboBoxMedLowThr.gridy = 1;
            gridBagComboBoxMedLowThr.anchor = 17;
            gridBagComboBoxMedLowThr.ipadx = 10;
            gridBagComboBoxMedLowThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelHiMedThr = new GridBagConstraints();
            gridBagLabelHiMedThr.gridx = 3;
            gridBagLabelHiMedThr.gridy = 0;
            gridBagLabelHiMedThr.anchor = 17;
            gridBagLabelHiMedThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagJComboBoxHiMedThr = new GridBagConstraints();
            gridBagJComboBoxHiMedThr.gridx = 3;
            gridBagJComboBoxHiMedThr.gridy = 1;
            gridBagJComboBoxHiMedThr.anchor = 17;
            gridBagJComboBoxHiMedThr.ipadx = 10;
            gridBagJComboBoxHiMedThr.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagLabelOutFormat = new GridBagConstraints();
            gridBagLabelOutFormat.gridx = 5;
            gridBagLabelOutFormat.gridy = 0;
            gridBagLabelOutFormat.anchor = 17;
            gridBagLabelOutFormat.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagComboBoxOutFormat = new GridBagConstraints();
            gridBagComboBoxOutFormat.gridx = 5;
            gridBagComboBoxOutFormat.gridy = 1;
            gridBagComboBoxOutFormat.anchor = 17;
            gridBagComboBoxOutFormat.weightx = 0.0;
            gridBagComboBoxOutFormat.fill = 0;
            gridBagComboBoxOutFormat.ipadx = 10;
            gridBagComboBoxOutFormat.insets = new Insets(0, 4, 0, 4);
            this.jLabelSubNum = new JLabel();
            this.jLabelSubNum.setText("Subtitle");
            this.jLabelSubNum.setPreferredSize(new Dimension(100, 20));
            this.jLabelOutFormat = new JLabel();
            this.jLabelOutFormat.setText("Output Format");
            this.jLabelOutFormat.setPreferredSize(new Dimension(120, 20));
            this.jLabelMedLowThr = new JLabel();
            this.jLabelMedLowThr.setText("Med/Low Threshold");
            this.jLabelMedLowThr.setPreferredSize(new Dimension(100, 20));
            this.jLabelHiMedThr = new JLabel();
            this.jLabelHiMedThr.setText("Hi/Med Threshold");
            this.jLabelHiMedThr.setPreferredSize(new Dimension(100, 20));
            this.jLabelAlphaThr = new JLabel();
            this.jLabelAlphaThr.setText("Alpha Threshold");
            this.jLabelAlphaThr.setPreferredSize(new Dimension(100, 20));
            this.jPanelUp = new JPanel();
            this.jPanelUp.setLayout(new GridBagLayout());
            this.jPanelUp.setPreferredSize(new Dimension(600, 40));
            this.jPanelUp.setMinimumSize(new Dimension(600, 40));
            this.jPanelUp.setMaximumSize(new Dimension(600, 40));
            this.jPanelUp.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jPanelUp.add((Component)this.jLabelSubNum, gridBagLabelSubNum);
            this.jPanelUp.add((Component)this.getJComboBoxSubNum(), gridBagComboBoxSubNum);
            this.jPanelUp.add((Component)this.jLabelAlphaThr, gridBagLabelAlphaThr);
            this.jPanelUp.add((Component)this.getJComboBoxAlphaThr(), gridBagComboBoxAlphaThr);
            this.jPanelUp.add((Component)this.jLabelMedLowThr, gridBagLabelMedLowThr);
            this.jPanelUp.add((Component)this.getJComboBoxMedLowThr(), gridBagComboBoxMedLowThr);
            this.jPanelUp.add((Component)this.jLabelHiMedThr, gridBagLabelHiMedThr);
            this.jPanelUp.add((Component)this.getJComboBoxHiMedThr(), gridBagJComboBoxHiMedThr);
            this.jPanelUp.add((Component)this.jLabelOutFormat, gridBagLabelOutFormat);
            this.jPanelUp.add((Component)this.getJComboBoxOutFormat(), gridBagComboBoxOutFormat);
            this.jPanelUp.add((Component)this.getJComboBoxPalette(), gridBagComboPalette);
            this.jPanelUp.add((Component)this.jLabelPalette, gridBagLabelPalette);
            this.jPanelUp.add((Component)this.jLabelFilter, gridBagLabelFilter);
            this.jPanelUp.add((Component)this.getJComboBoxFilter(), gridBagComboFilter);
        }
        return this.jPanelUp;
    }

    private JPanel getJPanelDown() {
        if (this.jPanelDown == null) {
            GridBagConstraints gridBagLayout = new GridBagConstraints();
            gridBagLayout.anchor = 12;
            gridBagLayout.gridx = 1;
            gridBagLayout.gridy = 0;
            gridBagLayout.weightx = 1.0;
            gridBagLayout.weighty = 1.0;
            gridBagLayout.fill = 1;
            GridBagConstraints gridBagConsole = new GridBagConstraints();
            gridBagConsole.fill = 1;
            gridBagConsole.gridy = 0;
            gridBagConsole.weightx = 2.0;
            gridBagConsole.weighty = 2.0;
            gridBagConsole.gridx = 0;
            this.jPanelDown = new JPanel();
            this.jPanelDown.setLayout(new GridBagLayout());
            this.jPanelDown.setPreferredSize(new Dimension(300, 150));
            this.jPanelDown.setMinimumSize(new Dimension(300, 150));
            this.jPanelDown.add((Component)this.getJPanelLayout(), gridBagLayout);
            this.jPanelDown.add((Component)this.getJScrollPaneConsole(), gridBagConsole);
        }
        return this.jPanelDown;
    }

    private JPanel getJPanelSup() {
        if (this.jPanelSrc == null) {
            this.jPanelSrc = new GfxPane();
        }
        return this.jPanelSrc;
    }

    private JPanel getJPanelSub() {
        if (this.jPanelTrg == null) {
            this.jPanelTrg = new GfxPane();
        }
        return this.jPanelTrg;
    }

    private JComboBox getJComboBoxSubNum() {
        if (this.jComboBoxSubNum == null) {
            this.jComboBoxSubNum = new JComboBox();
            this.jComboBoxSubNum.setEnabled(false);
            this.jComboBoxSubNum.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxSubNum.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxSubNum.setToolTipText("Set subtitle number");
            this.jComboBoxSubNum.setEditable(true);
            this.jComboBoxSubNum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx;
                        int num = Core.getNumFrames();
                        try {
                            idx = Integer.parseInt(MainFrame.this.jComboBoxSubNum.getSelectedItem().toString()) - 1;
                        }
                        catch (NumberFormatException ex) {
                            idx = MainFrame.this.subIndex;
                        }
                        if (idx < 0) {
                            idx = 0;
                        }
                        if (idx >= num) {
                            idx = num - 1;
                        }
                        MainFrame.this.subIndex = idx;
                        MainFrame.this.jComboBoxSubNum.setSelectedIndex(MainFrame.this.subIndex);
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
            this.jTextSubNum.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (Core.isReady()) {
                        int idx = ToolBox.getInt(MainFrame.this.jTextSubNum.getText()) - 1;
                        if (idx < 0 || idx >= Core.getNumFrames()) {
                            MainFrame.this.jTextSubNum.setBackground(MainFrame.this.errBgnd);
                        } else {
                            MainFrame.this.subIndex = idx;
                            new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = MainFrame.this.threadSemaphore;
                                    synchronized (object) {
                                        try {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                        catch (CoreException ex) {
                                            MainFrame.this.error(ex.getMessage());
                                        }
                                        catch (Exception ex) {
                                            ToolBox.showException(ex);
                                            MainFrame.this.exit(4);
                                        }
                                    }
                                }
                            }.start();
                            MainFrame.this.jTextSubNum.setBackground(MainFrame.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxSubNum;
    }

    private JComboBox getJComboBoxAlphaThr() {
        if (this.jComboBoxAlphaThr == null) {
            this.jComboBoxAlphaThr = new JComboBox();
            this.jComboBoxAlphaThr.setEnabled(false);
            this.jComboBoxAlphaThr.setEditable(true);
            this.jComboBoxAlphaThr.setToolTipText("Set alpha threshold");
            this.jComboBoxAlphaThr.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxAlphaThr.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxAlphaThr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx;
                        try {
                            idx = Integer.parseInt(MainFrame.this.jComboBoxAlphaThr.getSelectedItem().toString());
                        }
                        catch (NumberFormatException ex) {
                            idx = Core.getAlphaThr();
                        }
                        if (idx < 0) {
                            idx = 0;
                        }
                        if (idx > 255) {
                            idx = 255;
                        }
                        Core.setAlphaThr(idx);
                        MainFrame.this.jComboBoxAlphaThr.setSelectedIndex(Core.getAlphaThr());
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
            this.jTextAlphaThr.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (Core.isReady()) {
                        int idx = ToolBox.getInt(MainFrame.this.jTextAlphaThr.getText());
                        if (idx < 0 || idx > 255) {
                            MainFrame.this.jTextAlphaThr.setBackground(MainFrame.this.errBgnd);
                        } else {
                            Core.setAlphaThr(idx);
                            new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = MainFrame.this.threadSemaphore;
                                    synchronized (object) {
                                        try {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                        catch (CoreException ex) {
                                            MainFrame.this.error(ex.getMessage());
                                        }
                                        catch (Exception ex) {
                                            ToolBox.showException(ex);
                                            MainFrame.this.exit(4);
                                        }
                                    }
                                }
                            }.start();
                            MainFrame.this.jTextAlphaThr.setBackground(MainFrame.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxAlphaThr;
    }

    private JComboBox getJComboBoxHiMedThr() {
        if (this.jComboBoxHiMedThr == null) {
            this.jComboBoxHiMedThr = new JComboBox();
            this.jComboBoxHiMedThr.setEditable(true);
            this.jComboBoxHiMedThr.setEnabled(false);
            this.jComboBoxHiMedThr.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxHiMedThr.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxHiMedThr.setToolTipText("Set medium/high luminance threshold");
            this.jComboBoxHiMedThr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx;
                        int[] lumThr = Core.getLumThr();
                        try {
                            idx = Integer.parseInt(MainFrame.this.jComboBoxHiMedThr.getSelectedItem().toString());
                        }
                        catch (NumberFormatException ex) {
                            idx = lumThr[0];
                        }
                        if (idx <= lumThr[1]) {
                            idx = lumThr[1] + 1;
                        }
                        if (idx < 0) {
                            idx = 0;
                        }
                        if (idx > 255) {
                            idx = 255;
                        }
                        lumThr[0] = idx;
                        Core.setLumThr(lumThr);
                        MainFrame.this.jComboBoxHiMedThr.setSelectedIndex(Core.getLumThr()[0]);
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
            this.jTextHiMedThr.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (Core.isReady()) {
                        int[] lumThr = Core.getLumThr();
                        int idx = ToolBox.getInt(MainFrame.this.jTextHiMedThr.getText());
                        if (idx < 0 || idx > 255 | idx <= lumThr[1]) {
                            MainFrame.this.jTextHiMedThr.setBackground(MainFrame.this.errBgnd);
                        } else {
                            lumThr[0] = idx;
                            Core.setLumThr(lumThr);
                            new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = MainFrame.this.threadSemaphore;
                                    synchronized (object) {
                                        try {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                        catch (CoreException ex) {
                                            MainFrame.this.error(ex.getMessage());
                                        }
                                        catch (Exception ex) {
                                            ToolBox.showException(ex);
                                            MainFrame.this.exit(4);
                                        }
                                    }
                                }
                            }.start();
                            MainFrame.this.jTextHiMedThr.setBackground(MainFrame.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxHiMedThr;
    }

    private JComboBox getJComboBoxMedLowThr() {
        if (this.jComboBoxMedLowThr == null) {
            this.jComboBoxMedLowThr = new JComboBox();
            this.jComboBoxMedLowThr.setEditable(true);
            this.jComboBoxMedLowThr.setEnabled(false);
            this.jComboBoxMedLowThr.setToolTipText("Set low/medium luminance threshold");
            this.jComboBoxMedLowThr.setPreferredSize(new Dimension(100, 20));
            this.jComboBoxMedLowThr.setMinimumSize(new Dimension(80, 20));
            this.jComboBoxMedLowThr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx;
                        int[] lumThr = Core.getLumThr();
                        try {
                            idx = Integer.parseInt(MainFrame.this.jComboBoxMedLowThr.getSelectedItem().toString());
                        }
                        catch (NumberFormatException ex) {
                            idx = lumThr[1];
                        }
                        if (idx >= lumThr[0]) {
                            idx = lumThr[0] - 1;
                        }
                        if (idx < 0) {
                            idx = 0;
                        }
                        if (idx > 255) {
                            idx = 255;
                        }
                        lumThr[1] = idx;
                        Core.setLumThr(lumThr);
                        int index = idx;
                        MainFrame.this.jComboBoxMedLowThr.setSelectedIndex(index);
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
            this.jTextMedLowThr.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (Core.isReady()) {
                        int[] lumThr = Core.getLumThr();
                        int idx = ToolBox.getInt(MainFrame.this.jTextMedLowThr.getText());
                        if (idx < 0 || idx > 255 | idx >= lumThr[0]) {
                            MainFrame.this.jTextMedLowThr.setBackground(MainFrame.this.errBgnd);
                        } else {
                            lumThr[1] = idx;
                            Core.setLumThr(lumThr);
                            new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = MainFrame.this.threadSemaphore;
                                    synchronized (object) {
                                        try {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                        catch (CoreException ex) {
                                            MainFrame.this.error(ex.getMessage());
                                        }
                                        catch (Exception ex) {
                                            ToolBox.showException(ex);
                                            MainFrame.this.exit(4);
                                        }
                                    }
                                }
                            }.start();
                            MainFrame.this.jTextMedLowThr.setBackground(MainFrame.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxMedLowThr;
    }

    private JComboBox getJComboBoxOutFormat() {
        if (this.jComboBoxOutFormat == null) {
            this.jComboBoxOutFormat = new JComboBox();
            this.jComboBoxOutFormat.setEnabled(false);
            this.jComboBoxOutFormat.setToolTipText("Select export format");
            this.jComboBoxOutFormat.setPreferredSize(new Dimension(120, 20));
            this.jComboBoxOutFormat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx = MainFrame.this.jComboBoxOutFormat.getSelectedIndex();
                        Core.OutputMode[] outputModeArray = Core.OutputMode.values();
                        int n = outputModeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Core.OutputMode m = outputModeArray[n2];
                            if (idx == m.ordinal()) {
                                Core.setOutputMode(m);
                                break;
                            }
                            ++n2;
                        }
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        if (Core.getOutputMode() == Core.OutputMode.VOBSUB || Core.getOutputMode() == Core.OutputMode.SUPIFO) {
                                            MainFrame.this.enableVobsubStuff(true);
                                        } else {
                                            MainFrame.this.enableVobsubStuff(false);
                                        }
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jComboBoxOutFormat;
    }

    private void printInfoSrc(int index) {
        this.jLabelInfoSrc.setText(Core.getSrcInfoStr(index));
    }

    private void printInfoTrg(int index) {
        this.jLabelInfoTrg.setText(Core.getTrgInfoStr(index));
    }

    private JPanel getJPanelUp2() {
        if (this.jPanelUp2 == null) {
            GridBagConstraints gridBagLabelInfoSup = new GridBagConstraints();
            gridBagLabelInfoSup.anchor = 17;
            gridBagLabelInfoSup.insets = new Insets(4, 8, 2, 8);
            gridBagLabelInfoSup.gridwidth = 1;
            gridBagLabelInfoSup.gridx = 0;
            gridBagLabelInfoSup.gridy = 0;
            gridBagLabelInfoSup.weightx = 1.0;
            gridBagLabelInfoSup.fill = 2;
            this.jLabelInfoSrc = new JLabel();
            this.jLabelInfoSrc.setHorizontalAlignment(2);
            this.jLabelInfoSrc.setHorizontalTextPosition(2);
            this.jPanelUp2 = new JPanel();
            this.jPanelUp2.setLayout(new GridBagLayout());
            this.jPanelUp2.setPreferredSize(new Dimension(600, 20));
            this.jPanelUp2.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.lightGray));
            this.jPanelUp2.add((Component)this.jLabelInfoSrc, gridBagLabelInfoSup);
        }
        return this.jPanelUp2;
    }

    private JPanel getJPanelMid() {
        if (this.jPanelMid == null) {
            GridBagConstraints gridBagLabelSubInfo = new GridBagConstraints();
            gridBagLabelSubInfo.gridx = 0;
            gridBagLabelSubInfo.weightx = 1.0;
            gridBagLabelSubInfo.insets = new Insets(4, 8, 2, 8);
            gridBagLabelSubInfo.fill = 2;
            gridBagLabelSubInfo.anchor = 17;
            gridBagLabelSubInfo.gridy = 0;
            this.jLabelInfoTrg = new JLabel();
            this.jLabelInfoTrg.setHorizontalTextPosition(2);
            this.jLabelInfoTrg.setHorizontalAlignment(2);
            this.jPanelMid = new JPanel();
            this.jPanelMid.setLayout(new GridBagLayout());
            this.jPanelMid.setPreferredSize(new Dimension(300, 20));
            this.jPanelMid.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jPanelMid.add((Component)this.jLabelInfoTrg, gridBagLabelSubInfo);
        }
        return this.jPanelMid;
    }

    private JMenuBar getjMenuBar() {
        if (this.jMenuBar == null) {
            this.jMenuBar = new JMenuBar();
            this.jMenuBar.add(this.getJMenuFile());
            this.jMenuBar.add(this.getJMenuEdit());
            this.jMenuBar.add(this.getJMenuPrefs());
            this.jMenuBar.add(this.getJMenuHelp());
        }
        return this.jMenuBar;
    }

    private JMenu getJMenuFile() {
        if (this.jMenuFile == null) {
            this.jMenuFile = new JMenu();
            this.jMenuFile.setName("");
            this.jMenuFile.setMnemonic('f');
            this.jMenuFile.setText("File");
            this.jMenuFile.add(this.getJMenuItemLoad());
            this.jMenuFile.add(this.getJMenuItemRecent());
            this.jMenuFile.add(this.getJMenuItemSave());
            this.jMenuFile.add(this.getJMenuItemClose());
            this.jMenuFile.add(this.getJMenuItemExit());
        }
        return this.jMenuFile;
    }

    private JMenu getJMenuPrefs() {
        if (this.jMenuPrefs == null) {
            this.jMenuPrefs = new JMenu();
            this.jMenuPrefs.setText("Settings");
            this.jMenuPrefs.setMnemonic('s');
            this.jMenuPrefs.add(this.getJMenuItemConversionSettings());
            this.jMenuPrefs.add(this.getJMenuItemSwapCrCb());
            this.jMenuPrefs.add(this.getJMenuItemFixAlpha());
            this.jMenuPrefs.add(this.getJMenuItemVerbatim());
        }
        return this.jMenuPrefs;
    }

    private JMenu getJMenuEdit() {
        if (this.jMenuEdit == null) {
            this.jMenuEdit = new JMenu();
            this.jMenuEdit.setText("Edit");
            this.jMenuEdit.setMnemonic('e');
            this.jMenuEdit.add(this.getJMenuItemEditFrame());
            this.jMenuEdit.add(this.getJMenuItemEditColors());
            this.jMenuEdit.add(this.getJMenuItemEditCurColors());
            this.jMenuEdit.add(this.getJMenuItemEditFramePalAlpha());
            this.jMenuEdit.add(this.getJMenuItemBatchMove());
            this.jMenuEdit.add(this.getJMenuItemResetCrop());
        }
        return this.jMenuEdit;
    }

    private JMenu getJMenuHelp() {
        if (this.jMenuHelp == null) {
            this.jMenuHelp = new JMenu();
            this.jMenuHelp.setText("Help");
            this.jMenuHelp.setMnemonic('h');
            this.jMenuHelp.add(this.getJMenuItemHelp());
        }
        return this.jMenuHelp;
    }

    private JMenuItem getJMenuItemHelp() {
        if (this.jMenuItemHelp == null) {
            this.jMenuItemHelp = new JMenuItem();
            this.jMenuItemHelp.setText("Help");
            this.jMenuItemHelp.setMnemonic('h');
            this.jMenuItemHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Help help = new Help();
                    help.setLocation(MainFrame.this.getX() + 30, MainFrame.this.getY() + 30);
                    help.setSize(800, 600);
                    help.setVisible(true);
                }
            });
        }
        return this.jMenuItemHelp;
    }

    private JMenuItem getJMenuItemEditFrame() {
        if (this.jMenuItemEditFrame == null) {
            this.jMenuItemEditFrame = new JMenuItem();
            this.jMenuItemEditFrame.setText("Edit Frame");
            this.jMenuItemEditFrame.setMnemonic('e');
            this.jMenuItemEditFrame.setEnabled(false);
            this.jMenuItemEditFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        EditDialog ed = new EditDialog((Frame)MainFrame.this.mainFrame, true);
                        ed.setIndex(MainFrame.this.subIndex);
                        ed.setVisible(true);
                        MainFrame.this.subIndex = ed.getIndex();
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        MainFrame.this.jComboBoxSubNum.setSelectedIndex(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jMenuItemEditFrame;
    }

    private JMenuItem getJMenuItemBatchMove() {
        if (this.jMenuItemBatchMove == null) {
            this.jMenuItemBatchMove = new JMenuItem();
            this.jMenuItemBatchMove.setText("Move all captions");
            this.jMenuItemBatchMove.setMnemonic('m');
            this.jMenuItemBatchMove.setEnabled(false);
            this.jMenuItemBatchMove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        MoveDialog ed = new MoveDialog((Frame)MainFrame.this.mainFrame, true);
                        ed.setIndex(MainFrame.this.subIndex);
                        ed.setVisible(true);
                        if (Core.getMoveCaptions()) {
                            try {
                                Core.moveAllThreaded(MainFrame.this.mainFrame);
                            }
                            catch (CoreException ex) {
                                MainFrame.this.error(ex.getMessage());
                            }
                            catch (Exception ex) {
                                ToolBox.showException(ex);
                                MainFrame.this.exit(4);
                            }
                        }
                        MainFrame.this.subIndex = ed.getIndex();
                        MainFrame.this.jLayoutPane.setScreenRatio(ed.getTrgRatio());
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        MainFrame.this.jComboBoxSubNum.setSelectedIndex(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jMenuItemBatchMove;
    }

    private JMenuItem getJMenuItemResetCrop() {
        if (this.jMenuItemResetCrop == null) {
            this.jMenuItemResetCrop = new JMenuItem();
            this.jMenuItemResetCrop.setMnemonic('r');
            this.jMenuItemResetCrop.setText("Reset crop offset");
            this.jMenuItemResetCrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.setCropOfsY(0);
                    MainFrame.this.jLayoutPane.setCropOfsY(Core.getCropOfsY());
                    MainFrame.this.jLayoutPane.repaint();
                }
            });
        }
        return this.jMenuItemResetCrop;
    }

    private JMenuItem getJMenuItemSwapCrCb() {
        if (this.jMenuItemSwapCrCb == null) {
            this.jMenuItemSwapCrCb = new JCheckBoxMenuItem();
            this.jMenuItemSwapCrCb.setText("Swap Cr/Cb");
            this.jMenuItemSwapCrCb.setMnemonic('s');
            this.jMenuItemSwapCrCb.setSelected(false);
            this.jMenuItemSwapCrCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = MainFrame.this.jMenuItemSwapCrCb.isSelected();
                    Core.setSwapCrCb(selected);
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MainFrame.this.threadSemaphore;
                            synchronized (object) {
                                try {
                                    if (Core.isReady()) {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                }
                                catch (CoreException ex) {
                                    MainFrame.this.error(ex.getMessage());
                                }
                                catch (Exception ex) {
                                    ToolBox.showException(ex);
                                    MainFrame.this.exit(4);
                                }
                            }
                        }
                    }.start();
                }
            });
        }
        return this.jMenuItemSwapCrCb;
    }

    private JMenuItem getJMenuItemVerbatim() {
        if (this.jMenuItemVerbatim == null) {
            this.jMenuItemVerbatim = new JCheckBoxMenuItem();
            this.jMenuItemVerbatim.setText("Verbatim Output");
            this.jMenuItemVerbatim.setMnemonic('v');
            this.jMenuItemVerbatim.setSelected(false);
            this.jMenuItemVerbatim.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = MainFrame.this.jMenuItemVerbatim.isSelected();
                    Core.setVerbatim(selected);
                }
            });
        }
        return this.jMenuItemVerbatim;
    }

    private JMenuItem getJMenuItemFixAlpha() {
        if (this.jMenuItemFixAlpha == null) {
            this.jMenuItemFixAlpha = new JCheckBoxMenuItem();
            this.jMenuItemFixAlpha.setText("Fix invisible frames");
            this.jMenuItemFixAlpha.setMnemonic('f');
            this.jMenuItemFixAlpha.setSelected(false);
            this.jMenuItemFixAlpha.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = MainFrame.this.jMenuItemFixAlpha.isSelected();
                    Core.setFixZeroAlpha(selected);
                }
            });
        }
        return this.jMenuItemFixAlpha;
    }

    private JMenuItem getJMenuItemConversionSettings() {
        if (this.jMenuItemConversionSettings == null) {
            this.jMenuItemConversionSettings = new JMenuItem();
            this.jMenuItemConversionSettings.setText("Conversion Settings");
            this.jMenuItemConversionSettings.setMnemonic('c');
            this.jMenuItemConversionSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double fsYOld;
                    double fsXOld;
                    final Core.Resolution rOld = Core.getOutputResolution();
                    final double fpsTrgOld = Core.getFPSTrg();
                    final boolean changeFpsOld = Core.getConvertFPS();
                    final int delayOld = Core.getDelayPTS();
                    if (Core.getApplyFreeScale()) {
                        fsXOld = Core.getFreeScaleX();
                        fsYOld = Core.getFreeScaleY();
                    } else {
                        fsXOld = 1.0;
                        fsYOld = 1.0;
                    }
                    ConversionDialog trans = new ConversionDialog((Frame)MainFrame.this.mainFrame, true);
                    trans.enableOptionMove(false);
                    trans.setVisible(true);
                    if (!trans.wasCanceled()) {
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        if (Core.isReady()) {
                                            Core.reScanSubtitles(rOld, fpsTrgOld, delayOld, changeFpsOld, fsXOld, fsYOld);
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jMenuItemConversionSettings;
    }

    private JMenuItem getJMenuItemEditColors() {
        if (this.jMenuItemEditColors == null) {
            this.jMenuItemEditColors = new JMenuItem();
            this.jMenuItemEditColors.setText("Edit default DVD Palette");
            this.jMenuItemEditColors.setMnemonic('d');
            this.jMenuItemEditColors.setDisplayedMnemonicIndex(5);
            this.jMenuItemEditColors.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorDialog cDiag = new ColorDialog(MainFrame.this.mainFrame, true);
                    String[] cName = new String[]{"white", "light gray", "dark gray", "Color 1 light", "Color 1 dark", "Color 2 light", "Color 2 dark", "Color 3 light", "Color 3 dark", "Color 4 light", "Color 4 dark", "Color 5 light", "Color 5 dark", "Color 6 light", "Color 6 dark"};
                    Color[] cColor = new Color[15];
                    Color[] cColorDefault = new Color[15];
                    int i = 0;
                    while (i < cColor.length) {
                        cColor[i] = Core.getCurrentDVDPalette().getColor(i + 1);
                        cColorDefault[i] = Core.getDefaultDVDPalette().getColor(i + 1);
                        ++i;
                    }
                    cDiag.setParameters(cName, cColor, cColorDefault);
                    cDiag.setPath(MainFrame.this.colorPath);
                    cDiag.setVisible(true);
                    if (!cDiag.wasCanceled()) {
                        cColor = cDiag.getColors();
                        MainFrame.this.colorPath = cDiag.getPath();
                        i = 0;
                        while (i < cColor.length) {
                            Core.getCurrentDVDPalette().setColor(i + 1, cColor[i]);
                            ++i;
                        }
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        if (Core.isReady()) {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jMenuItemEditColors;
    }

    private JMenuItem getJMenuItemEditCurColors() {
        if (this.jMenuItemEditCurColors == null) {
            this.jMenuItemEditCurColors = new JMenuItem();
            this.jMenuItemEditCurColors.setEnabled(false);
            this.jMenuItemEditCurColors.setText("Edit imported DVD Palette");
            this.jMenuItemEditCurColors.setMnemonic('i');
            this.jMenuItemEditCurColors.setDisplayedMnemonicIndex(5);
            this.jMenuItemEditCurColors.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorDialog cDiag = new ColorDialog(MainFrame.this.mainFrame, true);
                    String[] cName = new String[]{"Color 0", "Color 1", "Color 2", "Color 3", "Color 4", "Color 5", "Color 6", "Color 7", "Color 8", "Color 9", "Color 10", "Color 11", "Color 12", "Color 13", "Color 14", "Color 15"};
                    Color[] cColor = new Color[16];
                    Color[] cColorDefault = new Color[16];
                    int i = 0;
                    while (i < cColor.length) {
                        cColor[i] = Core.getCurSrcDVDPalette().getColor(i);
                        cColorDefault[i] = Core.getDefSrcDVDPalette().getColor(i);
                        ++i;
                    }
                    cDiag.setParameters(cName, cColor, cColorDefault);
                    cDiag.setPath(MainFrame.this.colorPath);
                    cDiag.setVisible(true);
                    if (!cDiag.wasCanceled()) {
                        cColor = cDiag.getColors();
                        MainFrame.this.colorPath = cDiag.getPath();
                        Palette p = new Palette(cColor.length, true);
                        int i2 = 0;
                        while (i2 < cColor.length) {
                            p.setColor(i2, cColor[i2]);
                            ++i2;
                        }
                        Core.setCurSrcDVDPalette(p);
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        if (Core.isReady()) {
                                            Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                            MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                            MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        }
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jMenuItemEditCurColors;
    }

    private JMenuItem getJMenuItemEditFramePalAlpha() {
        if (this.jMenuItemEditFramePalAlpha == null) {
            this.jMenuItemEditFramePalAlpha = new JMenuItem();
            this.jMenuItemEditFramePalAlpha.setEnabled(false);
            this.jMenuItemEditFramePalAlpha.setText("Edit DVD Frame Palette");
            this.jMenuItemEditFramePalAlpha.setMnemonic('f');
            this.jMenuItemEditFramePalAlpha.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FramePalDialog cDiag = new FramePalDialog(MainFrame.this.mainFrame, true);
                    cDiag.setIndex(MainFrame.this.subIndex);
                    cDiag.setVisible(true);
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MainFrame.this.threadSemaphore;
                            synchronized (object) {
                                try {
                                    if (Core.isReady()) {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                }
                                catch (CoreException ex) {
                                    MainFrame.this.error(ex.getMessage());
                                }
                                catch (Exception ex) {
                                    ToolBox.showException(ex);
                                    MainFrame.this.exit(4);
                                }
                            }
                        }
                    }.start();
                }
            });
        }
        return this.jMenuItemEditFramePalAlpha;
    }

    private void enableCoreComponents(boolean b) {
        this.jMenuItemLoad.setEnabled(b);
        this.jMenuRecent.setEnabled(b && Core.getRecentFiles().size() > 0);
        this.jMenuItemSave.setEnabled(b && Core.getNumFrames() > 0);
        this.jMenuItemClose.setEnabled(b);
        this.jMenuItemEditFrame.setEnabled(b);
        this.jMenuItemBatchMove.setEnabled(b);
        this.jComboBoxSubNum.setEnabled(b);
        this.jComboBoxOutFormat.setEnabled(b);
        this.jComboBoxFilter.setEnabled(b);
    }

    private void enableVobSubMenuCombo() {
        boolean b = (Core.getOutputMode() == Core.OutputMode.VOBSUB || Core.getOutputMode() == Core.OutputMode.SUPIFO) && (Core.getInputMode() != Core.InputMode.VOBSUB && Core.getInputMode() != Core.InputMode.SUPIFO || Core.getPaletteMode() != Core.PaletteMode.KEEP_EXISTING);
        this.jComboBoxAlphaThr.setEnabled(b);
        this.jComboBoxHiMedThr.setEnabled(b);
        this.jComboBoxMedLowThr.setEnabled(b);
        b = Core.getInputMode() == Core.InputMode.VOBSUB || Core.getInputMode() == Core.InputMode.SUPIFO;
        this.jMenuItemEditCurColors.setEnabled(b);
        this.jMenuItemEditFramePalAlpha.setEnabled(b);
    }

    private void enableVobsubStuff(boolean b) {
        boolean ready = Core.isReady();
        Core.setReady(false);
        this.jComboBoxPalette.removeAllItems();
        Core.PaletteMode[] paletteModeArray = Core.PaletteMode.values();
        int n = paletteModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Core.PaletteMode m = paletteModeArray[n2];
            if (!b || m != Core.PaletteMode.CREATE_DITHERED) {
                this.jComboBoxPalette.addItem(Core.getPaletteModeName(m));
            }
            ++n2;
        }
        if (!b || Core.getPaletteMode() != Core.PaletteMode.CREATE_DITHERED) {
            this.jComboBoxPalette.setSelectedIndex(Core.getPaletteMode().ordinal());
        } else {
            this.jComboBoxPalette.setSelectedIndex(Core.PaletteMode.CREATE_NEW.ordinal());
        }
        if (!b || Core.getInputMode() == Core.InputMode.VOBSUB || Core.getInputMode() == Core.InputMode.SUPIFO) {
            this.jComboBoxPalette.setEnabled(true);
        } else {
            this.jComboBoxPalette.setEnabled(false);
        }
        this.enableVobSubMenuCombo();
        Core.setReady(ready);
    }

    private void warningDialog() {
        int w = Core.getWarnings();
        Core.resetWarnings();
        int e = Core.getErrors();
        Core.resetErrors();
        if (w + e > 0) {
            String s = "";
            if (w > 0) {
                s = w == 1 ? String.valueOf(s) + w + " warning" : String.valueOf(s) + w + " warnings";
            }
            if (w > 0 && e > 0) {
                s = String.valueOf(s) + " and ";
            }
            if (e > 0) {
                s = e == 1 ? String.valueOf(e) + " error" : String.valueOf(e) + " errors";
            }
            s = w + e < 3 ? "There was " + s : "There were " + s;
            JOptionPane.showMessageDialog(this.mainFrame, String.valueOf(s) + "\nCheck the log for details", "Warning!", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String fname) {
        if (fname != null) {
            if (!new File(fname).exists()) {
                JOptionPane.showMessageDialog(this.mainFrame, "File '" + fname + "' does not exist", "File not found!", 2);
            } else {
                Object object = this.threadSemaphore;
                synchronized (object) {
                    block20: {
                        Core.StreamID sid;
                        boolean xml = ToolBox.getExtension(fname).equalsIgnoreCase("xml");
                        boolean idx = ToolBox.getExtension(fname).equalsIgnoreCase("idx");
                        boolean ifo = ToolBox.getExtension(fname).equalsIgnoreCase("ifo");
                        byte[] id = ToolBox.getFileID(fname, 4);
                        Core.StreamID streamID = sid = id == null ? Core.StreamID.UNKNOWN : Core.getStreamID(id);
                        if (idx || xml || ifo || sid != Core.StreamID.UNKNOWN) {
                            this.mainFrame.setTitle(String.valueOf(Core.getProgVerName()) + " - " + fname);
                            this.subIndex = 0;
                            this.loadPath = fname;
                            this.saveFilename = ToolBox.stripExtension(ToolBox.getFileName(this.loadPath));
                            this.savePath = ToolBox.getPathName(this.loadPath);
                            this.enableCoreComponents(false);
                            this.enableVobsubStuff(false);
                            try {
                                Core.readStreamThreaded(this.loadPath, this.mainFrame, sid);
                                this.warningDialog();
                                int num = Core.getNumFrames();
                                Core.setReady(false);
                                this.jComboBoxSubNum.removeAllItems();
                                int i = 1;
                                while (i <= num) {
                                    this.jComboBoxSubNum.addItem(Integer.toString(i));
                                    ++i;
                                }
                                this.jComboBoxSubNum.setSelectedIndex(this.subIndex);
                                this.jComboBoxAlphaThr.setSelectedIndex(Core.getAlphaThr());
                                this.jComboBoxHiMedThr.setSelectedIndex(Core.getLumThr()[0]);
                                this.jComboBoxMedLowThr.setSelectedIndex(Core.getLumThr()[1]);
                                if (Core.getCropOfsY() > 0 && JOptionPane.showConfirmDialog(this.mainFrame, "Reset Crop Offset?", "", 0) == 0) {
                                    Core.setCropOfsY(0);
                                }
                                ConversionDialog trans = new ConversionDialog((Frame)this.mainFrame, true);
                                trans.enableOptionMove(Core.getMoveCaptions());
                                trans.setVisible(true);
                                if (!trans.wasCanceled()) {
                                    Core.scanSubtitles();
                                    if (Core.getMoveCaptions()) {
                                        Core.moveAllThreaded(this.mainFrame);
                                    }
                                    Core.convertSup(this.subIndex, this.subIndex + 1, Core.getNumFrames());
                                    Core.setReady(true);
                                    this.jMenuItemExit.setEnabled(true);
                                    this.refreshSrcFrame(this.subIndex);
                                    this.refreshTrgFrame(this.subIndex);
                                    this.enableCoreComponents(true);
                                    if (Core.getOutputMode() == Core.OutputMode.VOBSUB || Core.getInputMode() == Core.InputMode.SUPIFO) {
                                        this.enableVobsubStuff(true);
                                    }
                                    Core.loadedHook();
                                    Core.addRecent(this.loadPath);
                                    this.updateRecentMenu();
                                } else {
                                    this.closeSub();
                                    this.printWarn("Loading cancelled by user.");
                                    Core.close();
                                }
                            }
                            catch (CoreException ex) {
                                this.jMenuItemLoad.setEnabled(true);
                                this.updateRecentMenu();
                                this.jComboBoxOutFormat.setEnabled(true);
                                this.error(ex.getMessage());
                                this.flush();
                                break block20;
                            }
                            catch (Exception ex) {
                                try {
                                    ToolBox.showException(ex);
                                    this.exit(4);
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    this.flush();
                                }
                            }
                            this.flush();
                            break block20;
                        }
                        JOptionPane.showMessageDialog(this.mainFrame, "This is not a supported SUP stream", "Wrong format!", 2);
                    }
                }
            }
        }
    }

    private JMenuItem getJMenuItemLoad() {
        if (this.jMenuItemLoad == null) {
            this.jMenuItemLoad = new JMenuItem();
            this.jMenuItemLoad.setText("Load");
            this.jMenuItemLoad.setMnemonic('l');
            this.jMenuItemLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] ext = new String[]{"idx", "ifo", "sub", "sup", "xml"};
                    MainFrame.this.console.setText("");
                    String p = ToolBox.getPathName(MainFrame.this.loadPath);
                    String fn = ToolBox.getFileName(MainFrame.this.loadPath);
                    final String fname = ToolBox.getFileName(p, fn, ext, true, MainFrame.this.mainFrame);
                    new Thread(){

                        @Override
                        public void run() {
                            MainFrame.this.load(fname);
                        }
                    }.start();
                }
            });
        }
        return this.jMenuItemLoad;
    }

    private void updateRecentMenu() {
        this.jMenuRecent.setEnabled(false);
        ArrayList<String> recentFiles = Core.getRecentFiles();
        int size = recentFiles.size();
        if (size > 0) {
            this.jMenuRecent.removeAll();
            int i = 0;
            while (i < size) {
                JMenuItem j = new JMenuItem();
                String s = recentFiles.get(i);
                j.setText(String.valueOf(i) + ": " + s);
                j.setActionCommand(s);
                j.setMnemonic(("" + i).charAt(0));
                j.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrame.this.console.setText("");
                        final String fname = e.getActionCommand();
                        new Thread(){

                            @Override
                            public void run() {
                                MainFrame.this.load(fname);
                            }
                        }.start();
                    }
                });
                this.jMenuRecent.add(j);
                ++i;
            }
            this.jMenuRecent.setEnabled(true);
        }
    }

    private JMenu getJMenuItemRecent() {
        if (this.jMenuRecent == null) {
            this.jMenuRecent = new JMenu();
            this.jMenuRecent.setText("Recent Files");
            this.jMenuRecent.setMnemonic('r');
        }
        return this.jMenuRecent;
    }

    private JMenuItem getJMenuItemSave() {
        if (this.jMenuItemSave == null) {
            this.jMenuItemSave = new JMenuItem();
            this.jMenuItemSave.setText("Save/Export");
            this.jMenuItemSave.setMnemonic('s');
            this.jMenuItemSave.setEnabled(false);
            this.jMenuItemSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean showException = true;
                    try {
                        try {
                            ExportDialog exp = new ExportDialog((Frame)MainFrame.this.mainFrame, true);
                            String path = String.valueOf(MainFrame.this.savePath) + File.separatorChar + MainFrame.this.saveFilename + "_exp.";
                            path = Core.getOutputMode() == Core.OutputMode.VOBSUB ? String.valueOf(path) + "idx" : (Core.getOutputMode() == Core.OutputMode.SUPIFO ? String.valueOf(path) + "ifo" : (Core.getOutputMode() == Core.OutputMode.BDSUP ? String.valueOf(path) + "sup" : String.valueOf(path) + "xml"));
                            exp.setFileName(path);
                            exp.setVisible(true);
                            String fn = exp.getFileName();
                            if (!exp.wasCanceled() && fn != null) {
                                File fs;
                                File fi;
                                MainFrame.this.savePath = ToolBox.getPathName(fn);
                                MainFrame.this.saveFilename = ToolBox.stripExtension(ToolBox.getFileName(fn));
                                MainFrame.this.saveFilename = MainFrame.this.saveFilename.replaceAll("_exp$", "");
                                if (Core.getOutputMode() == Core.OutputMode.VOBSUB) {
                                    fi = new File(String.valueOf(ToolBox.stripExtension(fn)) + ".idx");
                                    fs = new File(String.valueOf(ToolBox.stripExtension(fn)) + ".sub");
                                } else if (Core.getOutputMode() == Core.OutputMode.SUPIFO) {
                                    fi = new File(String.valueOf(ToolBox.stripExtension(fn)) + ".ifo");
                                    fs = new File(String.valueOf(ToolBox.stripExtension(fn)) + ".sup");
                                } else {
                                    fi = fs = new File(String.valueOf(ToolBox.stripExtension(fn)) + ".sup");
                                }
                                if (fi.exists() || fs.exists()) {
                                    showException = false;
                                    if (fi.exists() && !fi.canWrite() || fs.exists() && !fs.canWrite()) {
                                        throw new CoreException("Target is write protected.");
                                    }
                                    if (JOptionPane.showConfirmDialog(MainFrame.this.mainFrame, "Target exists! Overwrite?", "", 0) == 1) {
                                        throw new CoreException("Target exists. Aborted by user.");
                                    }
                                    showException = true;
                                }
                                Core.createSubThreaded(fn, MainFrame.this.mainFrame);
                                MainFrame.this.warningDialog();
                            }
                        }
                        catch (CoreException ex) {
                            if (showException) {
                                MainFrame.this.error(ex.getMessage());
                            }
                            MainFrame.this.flush();
                        }
                        catch (Exception ex) {
                            ToolBox.showException(ex);
                            MainFrame.this.exit(4);
                            MainFrame.this.flush();
                        }
                    }
                    finally {
                        MainFrame.this.flush();
                    }
                }
            });
        }
        return this.jMenuItemSave;
    }

    private void closeSub() {
        this.jComboBoxSubNum.removeAllItems();
        this.enableCoreComponents(false);
        this.jMenuItemLoad.setEnabled(true);
        this.updateRecentMenu();
        this.jComboBoxPalette.setEnabled(false);
        this.jComboBoxAlphaThr.setEnabled(false);
        this.jComboBoxHiMedThr.setEnabled(false);
        this.jComboBoxMedLowThr.setEnabled(false);
        this.jMenuItemEditCurColors.setEnabled(false);
        this.jMenuItemEditFramePalAlpha.setEnabled(false);
        this.jLayoutPane.setImage(null, 1, 1);
        this.jLayoutPane.repaint();
        this.jPanelTrg.setImage(null);
        this.jPanelSrc.setImage(null);
        this.jLabelInfoTrg.setText("");
        this.jLabelInfoSrc.setText("");
    }

    private JMenuItem getJMenuItemClose() {
        if (this.jMenuItemClose == null) {
            this.jMenuItemClose = new JMenuItem();
            this.jMenuItemClose.setText("Close");
            this.jMenuItemClose.setEnabled(false);
            this.jMenuItemClose.setMnemonic('c');
            this.jMenuItemClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.close();
                    MainFrame.this.closeSub();
                }
            });
        }
        return this.jMenuItemClose;
    }

    private JMenuItem getJMenuItemExit() {
        if (this.jMenuItemExit == null) {
            this.jMenuItemExit = new JMenuItem();
            this.jMenuItemExit.setText("Exit");
            this.jMenuItemExit.setMnemonic('e');
            this.jMenuItemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.exit(0);
                }
            });
        }
        return this.jMenuItemExit;
    }

    private JScrollPane getJScrollPaneConsole() {
        if (this.jScrollPaneConsole == null) {
            this.jScrollPaneConsole = new JScrollPane();
            this.jScrollPaneConsole.setViewportView(this.getConsole());
        }
        return this.jScrollPaneConsole;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJPopupMenuItemCopy());
            this.jPopupMenu.add(this.getJPopupMenuItemClear());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJPopupMenuItemCopy() {
        if (this.jPopupMenuItemCopy == null) {
            this.jPopupMenuItemCopy = new JMenuItem();
            this.jPopupMenuItemCopy.setText("Copy");
            this.jPopupMenuItemCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = MainFrame.this.console.getSelectedText();
                    try {
                        if (s != null) {
                            MainFrame.this.setClipboard(s);
                        }
                    }
                    catch (OutOfMemoryError ex) {
                        JOptionPane.showMessageDialog(MainFrame.this.mainFrame, "Out of heap! Use -Xmx256m to increase heap! ", "Error!", 2);
                    }
                }
            });
        }
        return this.jPopupMenuItemCopy;
    }

    private JMenuItem getJPopupMenuItemClear() {
        if (this.jPopupMenuItemClear == null) {
            this.jPopupMenuItemClear = new JMenuItem();
            this.jPopupMenuItemClear.setText("Clear");
            this.jPopupMenuItemClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.console.setText("");
                }
            });
        }
        return this.jPopupMenuItemClear;
    }

    private JTextArea getConsole() {
        if (this.console == null) {
            this.console = new JTextArea();
            this.console.setEditable(false);
        }
        return this.console;
    }

    private JPanel getJPanelLayout() {
        if (this.jLayoutPane == null) {
            this.jLayoutPane = new EditPane(true);
            this.jLayoutPane.setLayout(new GridBagLayout());
            this.jLayoutPane.setPreferredSize(new Dimension(180, 100));
            this.jLayoutPane.setMaximumSize(new Dimension(180, 100));
            this.jLayoutPane.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && Core.isReady()) {
                        EditDialog ed = new EditDialog((Frame)MainFrame.this.mainFrame, true);
                        ed.setIndex(MainFrame.this.subIndex);
                        ed.setVisible(true);
                        MainFrame.this.subIndex = ed.getIndex();
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshSrcFrame(MainFrame.this.subIndex);
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                        MainFrame.this.jComboBoxSubNum.setSelectedIndex(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        return this.jLayoutPane;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private JComboBox getJComboBoxPalette() {
        if (this.jComboBoxPalette == null) {
            this.jComboBoxPalette = new JComboBox();
            this.jComboBoxPalette.setEnabled(false);
            this.jComboBoxPalette.setToolTipText("Select palette mode");
            this.jComboBoxPalette.setPreferredSize(new Dimension(120, 20));
            this.jComboBoxPalette.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx = MainFrame.this.jComboBoxPalette.getSelectedIndex();
                        Core.PaletteMode[] paletteModeArray = Core.PaletteMode.values();
                        int n = paletteModeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Core.PaletteMode m = paletteModeArray[n2];
                            if (idx == m.ordinal()) {
                                Core.setPaletteMode(m);
                                break;
                            }
                            ++n2;
                        }
                        MainFrame.this.enableVobSubMenuCombo();
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jComboBoxPalette;
    }

    private JComboBox getJComboBoxFilter() {
        if (this.jComboBoxFilter == null) {
            this.jComboBoxFilter = new JComboBox();
            this.jComboBoxFilter.setEnabled(false);
            this.jComboBoxFilter.setToolTipText("Select filter for scaling");
            this.jComboBoxFilter.setPreferredSize(new Dimension(120, 20));
            this.jComboBoxFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Core.isReady()) {
                        int idx = MainFrame.this.jComboBoxFilter.getSelectedIndex();
                        Core.ScalingFilters[] scalingFiltersArray = Core.ScalingFilters.values();
                        int n = scalingFiltersArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Core.ScalingFilters s = scalingFiltersArray[n2];
                            if (idx == s.ordinal()) {
                                Core.setScalingFilter(s);
                                break;
                            }
                            ++n2;
                        }
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = MainFrame.this.threadSemaphore;
                                synchronized (object) {
                                    try {
                                        Core.convertSup(MainFrame.this.subIndex, MainFrame.this.subIndex + 1, Core.getNumFrames());
                                        MainFrame.this.refreshTrgFrame(MainFrame.this.subIndex);
                                    }
                                    catch (CoreException ex) {
                                        MainFrame.this.error(ex.getMessage());
                                    }
                                    catch (Exception ex) {
                                        ToolBox.showException(ex);
                                        MainFrame.this.exit(4);
                                    }
                                }
                            }
                        }.start();
                    }
                }
            });
        }
        return this.jComboBoxFilter;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                boolean canCopy = MainFrame.this.console.getSelectedText() != null;
                MainFrame.this.jPopupMenuItemCopy.setEnabled(canCopy);
                MainFrame.this.jPopupMenu.show(MainFrame.this.console, e.getX(), e.getY());
            }
        }
    }
}

