/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.helpAnchorListener;
import deadbeef.SupTools.Core;
import deadbeef.Tools.Props;
import deadbeef.Tools.ToolBox;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Help
extends JFrame {
    static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jPopupMenuItemCopy = null;
    private JMenuItem jPopupMenuItemOpen = null;
    private JEditorPane thisEditor = null;
    private URL helpURL;
    private Props chapters;

    private void init() {
        ClassLoader loader = Help.class.getClassLoader();
        this.helpURL = loader.getResource("help.htm");
        this.chapters = new Props();
        this.chapters.load(loader.getResource("help.ini"));
        try {
            String s;
            this.thisEditor = new JEditorPane(this.helpURL);
            this.thisEditor.setEditable(false);
            this.thisEditor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    block11: {
                        URL url = e.getURL();
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            try {
                                if (url.sameFile(Help.this.helpURL)) {
                                    Help.this.thisEditor.setPage(url);
                                    break block11;
                                }
                                Desktop.getDesktop().browse(url.toURI());
                            }
                            catch (IOException iOException) {
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                            if (url.sameFile(Help.this.helpURL)) {
                                Help.this.thisEditor.setToolTipText(url.getRef());
                            } else {
                                Help.this.thisEditor.setToolTipText(url.toExternalForm());
                            }
                        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                            Help.this.thisEditor.setToolTipText(null);
                        }
                    }
                }
            });
            this.jScrollPane.setViewportView(this.thisEditor);
            this.getJPopupMenu();
            this.jPopupMenu.addSeparator();
            int i = 0;
            while ((s = this.chapters.get("chapter_" + i, "")).length() > 0) {
                String[] str = s.split(",");
                if (str.length == 2) {
                    JMenuItem j = new JMenuItem();
                    j.setText(str[1]);
                    this.jPopupMenu.add(j);
                    helpAnchorListener h = new helpAnchorListener();
                    h.setEditor(this.thisEditor);
                    h.setUrl(new URL(String.valueOf(this.helpURL.toExternalForm()) + "#" + str[0]));
                    j.addActionListener(h);
                }
                ++i;
            }
            PopupListener popupListener = new PopupListener();
            this.thisEditor.addMouseListener(popupListener);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Help() throws HeadlessException {
        this.initialize();
        this.init();
    }

    private static void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJPopupMenuItemOpen());
            this.jPopupMenu.add(this.getJPopupMenuItemCopy());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJPopupMenuItemOpen() {
        if (this.jPopupMenuItemOpen == null) {
            this.jPopupMenuItemOpen = new JMenuItem();
            this.jPopupMenuItemOpen.setText("Open in browser");
            this.jPopupMenuItemOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufferedWriter fw = null;
                    try {
                        try {
                            String s = Help.this.thisEditor.getText();
                            File temp = File.createTempFile("bds2s_help_", ".htm");
                            fw = new BufferedWriter(new FileWriter(temp));
                            fw.write(s);
                            fw.close();
                            Desktop.getDesktop().browse(temp.toURI());
                            temp.deleteOnExit();
                        }
                        catch (IOException ex) {
                            ToolBox.showException(ex);
                            try {
                                if (fw != null) {
                                    fw.close();
                                }
                            }
                            catch (IOException ex2) {
                                ToolBox.showException(ex2);
                            }
                        }
                    }
                    finally {
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (IOException ex) {
                            ToolBox.showException(ex);
                        }
                    }
                }
            });
        }
        return this.jPopupMenuItemOpen;
    }

    private JMenuItem getJPopupMenuItemCopy() {
        if (this.jPopupMenuItemCopy == null) {
            this.jPopupMenuItemCopy = new JMenuItem();
            this.jPopupMenuItemCopy.setText("Copy");
            this.jPopupMenuItemCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = Help.this.thisEditor.getSelectedText();
                    if (s != null) {
                        Help.setClipboard(s);
                    }
                }
            });
        }
        return this.jPopupMenuItemCopy;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setSize(600, 600);
        this.setContentPane(this.getJContentPane());
        this.setTitle(String.valueOf(Core.getProgVerName()) + " Help");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 0));
            this.jContentPane.add((Component)this.getJScrollPane(), null);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
        }
        return this.jScrollPane;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Help.this.jPopupMenuItemCopy.setEnabled(Help.this.thisEditor.getSelectionStart() != Help.this.thisEditor.getSelectionEnd());
                Help.this.jPopupMenu.show(Help.this.thisEditor, e.getX(), e.getY());
            }
        }
    }
}

