/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GfxPane
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private int scale = 1;
    private BufferedImage image;
    private Color color1 = Color.BLUE;
    private Color color2 = Color.BLACK;
    private final GfxPane thisPanel = this;

    public GfxPane() {
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.draw(g);
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.draw(g);
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.color1, this.getWidth(), this.getHeight(), this.color2));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            if (this.scale == 1) {
                g.drawImage(this.image, 0, 0, this);
            } else {
                g2.drawImage(this.image, 0, 0, this.image.getWidth() * this.scale, this.image.getHeight() * this.scale, this);
            }
        }
    }

    public void setScale(int s) {
        if (s != this.scale && this.image != null) {
            this.scale = s;
            Dimension dim = new Dimension(this.scale * this.image.getWidth(), this.scale * this.image.getHeight());
            this.setPreferredSize(dim);
            this.getParent().setSize(dim);
            ((JScrollPane)this.thisPanel.getParent().getParent()).revalidate();
        }
    }

    public void setImage(BufferedImage img) {
        this.image = img;
        Dimension dim = this.image != null ? new Dimension(this.scale * this.image.getWidth(), this.scale * this.image.getHeight()) : new Dimension(1, 1);
        this.setPreferredSize(dim);
        this.getParent().setSize(dim);
        ((JScrollPane)this.thisPanel.getParent().getParent()).revalidate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int s = this.scale;
        if (e.getButton() == 1) {
            if (s < 8) {
                ++s;
            }
        } else if (s > 1) {
            --s;
        }
        if (s != this.scale) {
            this.setScale(s);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

