/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.SupTools.Core;
import deadbeef.SupTools.Palette;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class FramePalDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton jButtonOk = null;
    private JButton jButtonCancel = null;
    private JLabel jLabelColor1 = null;
    private JLabel jLabelColor2 = null;
    private JLabel jLabelColor3 = null;
    private JLabel jLabelColor4 = null;
    private JLabel jLabelAlpha1 = null;
    private JLabel jLabelAlpha2 = null;
    private JLabel jLabelAlpha3 = null;
    private JLabel jLabelAlpha4 = null;
    private JComboBox jComboBoxColor1 = null;
    private JComboBox jComboBoxColor2 = null;
    private JComboBox jComboBoxColor3 = null;
    private JComboBox jComboBoxColor4 = null;
    private JComboBox jComboBoxAlpha1 = null;
    private JComboBox jComboBoxAlpha2 = null;
    private JComboBox jComboBoxAlpha3 = null;
    private JComboBox jComboBoxAlpha4 = null;
    private JButton jButtonSetAll = null;
    private JButton jButtonResetAll = null;
    private JButton jButtonReset = null;
    private static final String[] cName = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15"};
    private int index;
    private final ImageIcon[] cIcon;
    private volatile boolean isReady = false;
    private int[] alpha;
    private int[] pal;
    private boolean canceled = true;

    public FramePalDialog(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        this.initialize();
        Point p = frame.getLocation();
        this.setLocation(p.x + frame.getWidth() / 2 - this.getWidth() / 2, p.y + frame.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        Palette pal = Core.getCurSrcDVDPalette();
        this.cIcon = new ImageIcon[16];
        int i = 0;
        while (i < pal.getSize()) {
            this.cIcon[i] = new ImageIcon(new BufferedImage(12, 12, 1));
            Color c = new Color(pal.getARGB(i) | 0xFF000000);
            this.paintIcon(this.cIcon[i], c);
            this.jComboBoxColor1.addItem(cName[i]);
            this.jComboBoxColor2.addItem(cName[i]);
            this.jComboBoxColor3.addItem(cName[i]);
            this.jComboBoxColor4.addItem(cName[i]);
            this.jComboBoxAlpha1.addItem(cName[i]);
            this.jComboBoxAlpha2.addItem(cName[i]);
            this.jComboBoxAlpha3.addItem(cName[i]);
            this.jComboBoxAlpha4.addItem(cName[i]);
            ++i;
        }
        MyListCellRenderer myListCellRenderer2 = new MyListCellRenderer();
        this.jComboBoxColor1.setRenderer(myListCellRenderer2);
        this.jComboBoxColor2.setRenderer(myListCellRenderer2);
        this.jComboBoxColor3.setRenderer(myListCellRenderer2);
        this.jComboBoxColor4.setRenderer(myListCellRenderer2);
        this.jComboBoxColor1.repaint();
        this.jComboBoxColor2.repaint();
        this.jComboBoxColor3.repaint();
        this.jComboBoxColor4.repaint();
    }

    private void paintIcon(ImageIcon i, Color c) {
        Graphics g = i.getImage().getGraphics();
        g.setColor(c);
        g.setPaintMode();
        g.fillRect(0, 0, i.getIconWidth(), i.getIconHeight());
    }

    private void initialize() {
        this.setSize(294, 209);
        this.setTitle("Edit Frame Palette");
        this.setContentPane(this.getJContentPane());
    }

    public void setIndex(int idx) {
        this.index = idx;
        this.isReady = false;
        this.alpha = new int[4];
        this.pal = new int[4];
        int[] a = Core.getFrameAlpha(this.index);
        int[] p = Core.getFramePal(this.index);
        int i = 0;
        while (i < 4) {
            if (a != null) {
                this.alpha[i] = a[i];
            }
            if (p != null) {
                this.pal[i] = p[i];
            }
            ++i;
        }
        this.jComboBoxAlpha1.setSelectedIndex(this.alpha[0]);
        this.jComboBoxAlpha2.setSelectedIndex(this.alpha[1]);
        this.jComboBoxAlpha3.setSelectedIndex(this.alpha[2]);
        this.jComboBoxAlpha4.setSelectedIndex(this.alpha[3]);
        this.jComboBoxColor1.setSelectedIndex(this.pal[0]);
        this.jComboBoxColor2.setSelectedIndex(this.pal[1]);
        this.jComboBoxColor3.setSelectedIndex(this.pal[2]);
        this.jComboBoxColor4.setSelectedIndex(this.pal[3]);
        this.isReady = true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelAlpha4 = new JLabel();
            this.jLabelAlpha4.setBounds(new Rectangle(155, 85, 36, 16));
            this.jLabelAlpha4.setText("Alpha 4");
            this.jLabelAlpha3 = new JLabel();
            this.jLabelAlpha3.setBounds(new Rectangle(155, 60, 36, 16));
            this.jLabelAlpha3.setText("Alpha 3");
            this.jLabelAlpha2 = new JLabel();
            this.jLabelAlpha2.setBounds(new Rectangle(155, 35, 36, 16));
            this.jLabelAlpha2.setText("Alpha 2");
            this.jLabelAlpha1 = new JLabel();
            this.jLabelAlpha1.setBounds(new Rectangle(155, 10, 41, 16));
            this.jLabelAlpha1.setText("Alpha 1");
            this.jLabelColor4 = new JLabel();
            this.jLabelColor4.setBounds(new Rectangle(15, 85, 45, 16));
            this.jLabelColor4.setText("Color 4");
            this.jLabelColor3 = new JLabel();
            this.jLabelColor3.setBounds(new Rectangle(15, 60, 46, 16));
            this.jLabelColor3.setText("Color 3");
            this.jLabelColor2 = new JLabel();
            this.jLabelColor2.setBounds(new Rectangle(15, 35, 46, 16));
            this.jLabelColor2.setText("Color 2");
            this.jLabelColor1 = new JLabel();
            this.jLabelColor1.setBounds(new Rectangle(15, 10, 46, 16));
            this.jLabelColor1.setText("Color 1");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJButtonOk(), null);
            this.jContentPane.add((Component)this.getJButtonCancel(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor1(), null);
            this.jContentPane.add((Component)this.jLabelColor1, null);
            this.jContentPane.add((Component)this.jLabelColor2, null);
            this.jContentPane.add((Component)this.jLabelColor3, null);
            this.jContentPane.add((Component)this.jLabelColor4, null);
            this.jContentPane.add((Component)this.jLabelAlpha1, null);
            this.jContentPane.add((Component)this.jLabelAlpha2, null);
            this.jContentPane.add((Component)this.jLabelAlpha3, null);
            this.jContentPane.add((Component)this.jLabelAlpha4, null);
            this.jContentPane.add((Component)this.getJComboBoxColor2(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor3(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor4(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha1(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha2(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha3(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha4(), null);
            this.jContentPane.add((Component)this.getJButtonSetAll(), null);
            this.jContentPane.add((Component)this.getJButtonResetAll(), null);
            this.jContentPane.add((Component)this.getJButtonReset(), null);
        }
        return this.jContentPane;
    }

    private JComboBox getJComboBoxColor1() {
        if (this.jComboBoxColor1 == null) {
            this.jComboBoxColor1 = new JComboBox();
            this.jComboBoxColor1.setBounds(new Rectangle(70, 10, 61, 16));
            this.jComboBoxColor1.setEditable(false);
            this.jComboBoxColor1.setToolTipText("Set palette index of frame color 1");
            this.jComboBoxColor1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxColor1.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).pal[0] = idx;
                    }
                }
            });
        }
        return this.jComboBoxColor1;
    }

    private JComboBox getJComboBoxColor2() {
        if (this.jComboBoxColor2 == null) {
            this.jComboBoxColor2 = new JComboBox();
            this.jComboBoxColor2.setBounds(new Rectangle(70, 35, 61, 16));
            this.jComboBoxColor2.setEditable(false);
            this.jComboBoxColor2.setToolTipText("Set palette index of frame color 2");
            this.jComboBoxColor2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxColor2.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).pal[1] = idx;
                    }
                }
            });
        }
        return this.jComboBoxColor2;
    }

    private JComboBox getJComboBoxColor3() {
        if (this.jComboBoxColor3 == null) {
            this.jComboBoxColor3 = new JComboBox();
            this.jComboBoxColor3.setBounds(new Rectangle(70, 60, 61, 16));
            this.jComboBoxColor3.setEditable(false);
            this.jComboBoxColor3.setToolTipText("Set palette index of frame color 3");
            this.jComboBoxColor3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxColor3.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).pal[2] = idx;
                    }
                }
            });
        }
        return this.jComboBoxColor3;
    }

    private JComboBox getJComboBoxColor4() {
        if (this.jComboBoxColor4 == null) {
            this.jComboBoxColor4 = new JComboBox();
            this.jComboBoxColor4.setBounds(new Rectangle(70, 85, 61, 16));
            this.jComboBoxColor4.setEditable(false);
            this.jComboBoxColor4.setToolTipText("Set palette index of frame color 4");
            this.jComboBoxColor4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxColor4.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).pal[3] = idx;
                    }
                }
            });
        }
        return this.jComboBoxColor4;
    }

    private JComboBox getJComboBoxAlpha1() {
        if (this.jComboBoxAlpha1 == null) {
            this.jComboBoxAlpha1 = new JComboBox();
            this.jComboBoxAlpha1.setBounds(new Rectangle(215, 10, 56, 16));
            this.jComboBoxAlpha1.setEditable(false);
            this.jComboBoxAlpha1.setToolTipText("Set alpha value of frame color 1");
            this.jComboBoxAlpha1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxAlpha1.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).alpha[0] = idx;
                    }
                }
            });
        }
        return this.jComboBoxAlpha1;
    }

    private JComboBox getJComboBoxAlpha2() {
        if (this.jComboBoxAlpha2 == null) {
            this.jComboBoxAlpha2 = new JComboBox();
            this.jComboBoxAlpha2.setBounds(new Rectangle(215, 35, 56, 16));
            this.jComboBoxAlpha2.setEditable(false);
            this.jComboBoxAlpha2.setToolTipText("Set alpha value of frame color 2");
            this.jComboBoxAlpha2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxAlpha2.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).alpha[1] = idx;
                    }
                }
            });
        }
        return this.jComboBoxAlpha2;
    }

    private JComboBox getJComboBoxAlpha3() {
        if (this.jComboBoxAlpha3 == null) {
            this.jComboBoxAlpha3 = new JComboBox();
            this.jComboBoxAlpha3.setBounds(new Rectangle(215, 60, 56, 16));
            this.jComboBoxAlpha3.setEditable(false);
            this.jComboBoxAlpha3.setToolTipText("Set alpha value of frame color 3");
            this.jComboBoxAlpha3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxAlpha3.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).alpha[2] = idx;
                    }
                }
            });
        }
        return this.jComboBoxAlpha3;
    }

    private JComboBox getJComboBoxAlpha4() {
        if (this.jComboBoxAlpha4 == null) {
            this.jComboBoxAlpha4 = new JComboBox();
            this.jComboBoxAlpha4.setBounds(new Rectangle(215, 85, 56, 16));
            this.jComboBoxAlpha4.setEditable(false);
            this.jComboBoxAlpha4.setToolTipText("Set alpha value of frame color 4");
            this.jComboBoxAlpha4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx;
                    if (FramePalDialog.this.isReady && (idx = ToolBox.getInt(FramePalDialog.this.jComboBoxAlpha4.getSelectedItem().toString())) >= 0 && idx < 16) {
                        ((FramePalDialog)FramePalDialog.this).alpha[3] = idx;
                    }
                }
            });
        }
        return this.jComboBoxAlpha4;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setName("jButtonOk");
            this.jButtonOk.setBounds(new Rectangle(200, 145, 75, 21));
            this.jButtonOk.setText("Ok");
            this.jButtonOk.setToolTipText("Use current settings and return");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] a = Core.getFrameAlpha(FramePalDialog.this.index);
                    int[] p = Core.getFramePal(FramePalDialog.this.index);
                    int i = 0;
                    while (i < 4) {
                        if (a != null) {
                            a[i] = FramePalDialog.this.alpha[i];
                        }
                        if (p != null) {
                            p[i] = FramePalDialog.this.pal[i];
                        }
                        ++i;
                    }
                    FramePalDialog.this.dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setName("jButtonCancel");
            this.jButtonCancel.setBounds(new Rectangle(10, 145, 75, 21));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Lose changes and return");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FramePalDialog.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonSetAll() {
        if (this.jButtonSetAll == null) {
            this.jButtonSetAll = new JButton();
            this.jButtonSetAll.setBounds(new Rectangle(200, 115, 75, 21));
            this.jButtonSetAll.setText("Set All");
            this.jButtonSetAll.setToolTipText("Apply these settings for whole stream and return");
            this.jButtonSetAll.setMnemonic('s');
            this.jButtonSetAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int j = 0;
                    while (j < Core.getNumFrames()) {
                        int[] a = Core.getFrameAlpha(j);
                        int[] p = Core.getFramePal(j);
                        int i = 0;
                        while (i < 4) {
                            if (a != null) {
                                a[i] = FramePalDialog.this.alpha[i];
                            }
                            if (p != null) {
                                p[i] = FramePalDialog.this.pal[i];
                            }
                            ++i;
                        }
                        ++j;
                    }
                    FramePalDialog.this.dispose();
                }
            });
        }
        return this.jButtonSetAll;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    private JButton getJButtonResetAll() {
        if (this.jButtonResetAll == null) {
            this.jButtonResetAll = new JButton();
            this.jButtonResetAll.setBounds(new Rectangle(105, 115, 75, 23));
            this.jButtonResetAll.setText("Reset All");
            this.jButtonResetAll.setToolTipText("Revert to original frame palettes for whole stream and return");
            this.jButtonResetAll.setMnemonic('a');
            this.jButtonResetAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int j = 0;
                    while (j < Core.getNumFrames()) {
                        int[] ao = Core.getOriginalFrameAlpha(j);
                        int[] po = Core.getOriginalFramePal(j);
                        int[] a = Core.getFrameAlpha(j);
                        int[] p = Core.getFramePal(j);
                        int i = 0;
                        while (i < 4) {
                            if (a != null && ao != null) {
                                a[i] = ao[i];
                            }
                            if (p != null && po != null) {
                                p[i] = po[i];
                            }
                            ++i;
                        }
                        ++j;
                    }
                    FramePalDialog.this.dispose();
                }
            });
        }
        return this.jButtonResetAll;
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setBounds(new Rectangle(105, 145, 75, 23));
            this.jButtonReset.setText("Reset");
            this.jButtonReset.setToolTipText("Revert to original frame palette");
            this.jButtonReset.setMnemonic('r');
            this.jButtonReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] ao = Core.getOriginalFrameAlpha(FramePalDialog.this.index);
                    int[] po = Core.getOriginalFramePal(FramePalDialog.this.index);
                    int[] a = Core.getFrameAlpha(FramePalDialog.this.index);
                    int[] p = Core.getFramePal(FramePalDialog.this.index);
                    int i = 0;
                    while (i < 4) {
                        if (a != null && ao != null) {
                            a[i] = ao[i];
                        }
                        if (p != null && po != null) {
                            p[i] = po[i];
                        }
                        ++i;
                    }
                    FramePalDialog.this.setIndex(FramePalDialog.this.index);
                }
            });
        }
        return this.jButtonReset;
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        static final long serialVersionUID = 1L;

        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            int idx = ToolBox.getInt(value.toString());
            if (idx >= 0) {
                this.setText(cName[idx]);
                this.setIcon(FramePalDialog.this.cIcon[idx]);
            }
            return retValue;
        }
    }
}

