/*
 * Decompiled with CFR 0.152.
 */
import deadbeef.GUI.MainFrame;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.Tools.Props;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

class BDSup2Sub {
    private static final String[] params = new String[]{"res", "atr", "ltr1", "ltr2", "lang", "pal", "forced", "fps", "dly", "tmin", "swap", "movin", "movout", "cropy", "palmode", "verbatim", "filter", "tmerge", "scale", "acrop", "exppal", "fixinv", "movex", "forceall"};
    private static /* synthetic */ int[] $SWITCH_TABLE$BDSup2Sub$Parameters;

    BDSup2Sub() {
    }

    private static Parameters getParam(String s) {
        s = ToolBox.trim(s).toLowerCase();
        int i = 0;
        while (i < params.length) {
            if (s.equals(params[i])) {
                return Parameters.get(i);
            }
            ++i;
        }
        return Parameters.UNKNOWN;
    }

    private static void exit(int c) {
        Core.exit();
        System.exit(c);
    }

    private static void fatalError(String e) {
        Core.exit();
        System.out.println("ERROR: " + e);
        System.exit(1);
    }

    private static void printWarnings() {
        int w = Core.getWarnings();
        Core.resetWarnings();
        int e = Core.getErrors();
        Core.resetErrors();
        if (w + e > 0) {
            String s = "";
            if (w > 0) {
                s = w == 1 ? String.valueOf(s) + w + " warning" : String.valueOf(s) + w + " warnings";
            }
            if (w > 0 && e > 0) {
                s = String.valueOf(s) + " and ";
            }
            if (e > 0) {
                s = e == 1 ? String.valueOf(e) + " error" : String.valueOf(e) + " errors";
            }
            s = w + e < 3 ? "There was " + s : "There were " + s;
            System.out.println(s);
        }
    }

    private static void setupGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block169: {
            block168: {
                if (args.length == 1) {
                    extCnt = 0;
                    pos = 0;
                    a = args[0].toLowerCase();
                    do {
                        if ((p = a.indexOf(".sup", pos)) == -1) {
                            p = a.indexOf(".sub", pos);
                        }
                        if (p == -1) {
                            p = a.indexOf(".idx", pos);
                        }
                        if (p == -1) {
                            p = a.indexOf(".xml", pos);
                        }
                        if (p != -1) {
                            pos = p + 4;
                            ++extCnt;
                            continue;
                        }
                        pos = -1;
                    } while (pos != -1 && pos < a.length());
                    if (args[0].indexOf(47) >= 0 || args[0].indexOf(32) >= 0 && extCnt > 1) {
                        inside = false;
                        s = ToolBox.trim(args[0]);
                        sb = new StringBuffer();
                        al = new ArrayList<String>();
                        i = 0;
                        while (i < s.length()) {
                            c = s.charAt(i);
                            block4 : switch (c) {
                                case ' ': {
                                    if (inside) {
                                        sb.append(" ");
                                        break;
                                    }
                                    if (sb.length() > 0) {
                                        al.add(sb.toString());
                                    }
                                    sb = new StringBuffer();
                                    j = i + 1;
                                    while (j < s.length()) {
                                        c = s.charAt(j);
                                        if (c != ' ') {
                                            i = j - 1;
                                            break block4;
                                        }
                                        ++j;
                                    }
                                    break;
                                }
                                case '\'': {
                                    inside = inside == false;
                                    break;
                                }
                                default: {
                                    sb.append(c);
                                }
                            }
                            ++i;
                        }
                        if (inside) {
                            BDSup2Sub.fatalError("Missing closing single quote");
                        }
                        if (sb.length() > 0) {
                            al.add(sb.toString());
                        }
                        args = al.toArray(args);
                    }
                }
                if (args.length != 1 || !args[0].equals("/?") && !args[0].equalsIgnoreCase("/help")) break block168;
                System.out.println(String.valueOf(Core.getProgVerName()) + " - " + Core.getAuthorDate());
                System.out.println("Syntax:");
                System.out.println("java -jar BDSup2Sub <in> <out> [options]");
                System.out.println("Options:");
                System.out.println("    /res:<n>         : set resolution to 480, 576, 720 or 1080 - default 576");
                System.out.println("                       Predefined values: keep, ntsc=480, pal=576, 1440x1080");
                System.out.println("    /fps:<t>         : synchronize target frame rate to <t> - default: auto");
                System.out.println("                       Predefined values; 24p=23.976, 25p=25, 30p=29.967");
                System.out.println("                       /fps:keep preserves the source fps (for BD&XML)");
                System.out.println("    /fps:<s>,<t>     : convert framerate from <s> to <t>");
                System.out.println("                       Predefined values; 24p=23.976, 25p=25, 30p=29.967");
                System.out.println("                       /fps:auto,<t> detects source frame rate automatically");
                System.out.println("    /dly:<t>         : set delay in ms - default: 0.0");
                System.out.println("    /filter:<f>      : set scaling filter - default: bilinear");
                System.out.println("                       Supported values: bilinear, triangle, bicubic, bell,");
                System.out.println("                       b-spline, hermite, lanczos3, mitchell");
                System.out.println("    /palmode:<s>     : palette mode: keep, create, dither - default: create");
                System.out.println("    /tmin:<t>        : set minimum display time in ms - default: 500");
                System.out.println("    /tmerge:<t>      : set max time diff for merging subs in ms - default: 200");
                System.out.println("    /movin:<r>[,<o>] : move captions inside screen ratio <r>, +/- offset <o>");
                System.out.println("    /movout:<r>[,<o>]: move captions inside screen ratio <r>, +/- offset <o>");
                System.out.println("    /movex:<t>[,<o>] : move captions horizontally.<t> may be left,right,center.");
                System.out.println("                       +/- optional offset <o> (only if moving left or right)");
                System.out.println("    /cropy:<n>       : crop the upper/lower n lines - default: 0");
                System.out.println("    /acrop:<n>       : set alpha cropping threshold - default: 10");
                System.out.println("    /scale:<x>,<y>   : scale captions with free factors - default: 1.0,1.0");
                System.out.println("    /exppal[+/-]     : export target palette in PGCEdit format - default: off");
                System.out.println("    /forced[+/-]     : export only forced subtitles - default: off (export all)");
                System.out.println("    /forceall[+/-]   : set/clear forced flag for all subs - default: off (keep)");
                System.out.println("    /swap[+/-]       : swap Cr/Cb components - default: off (don't swap)");
                System.out.println("    /fixinv[+/-]     : fix zero alpha frame palette - default: off (don't fix)");
                System.out.println("    /verbatim[+/-]   : switch on verbatim console output mode - default: off");
                System.out.println("Options only for SUB/IDX or SUP/IFO as target:");
                System.out.println("    /atr:<n>         : set alpha threshold 0..255 - default 80");
                System.out.println("    /ltr1:<n>        : set lum lo/mid threshold 0..255 - default auto");
                System.out.println("    /ltr2:<n>        : set lum mid/hi threshold 0..255 - default auto");
                System.out.println("    /lang:<s>        : set language to string <s> - default: de (only SUB/IDX)");
                System.out.println("    /pal:<s>         : load palette file <s> - default: use builtin palette");
                System.out.println("\nNote:\n");
                System.out.println("Boolean parameters like \"verbatim\" are switched off with a trailing \"-\".");
                System.out.println("\nWildcard support:");
                System.out.println("To use wildcards, enclose the whole parameter string in double quotes.");
                System.out.println("For filenames containing spaces, use single quotes around the file name.");
                System.out.println("Use \"*\" for any character and \"?\" for one character in the source name");
                System.out.println("Use exactly one \"*\" in the target file name.");
                System.out.println("Example:");
                System.out.println("java -jar BDSup2Sub.jar \"'movie* 1?.sup' dvd_*.sub /res:720 /fps:25p\"");
                break block169;
            }
            cmdLine = "";
            i = 0;
            while (i < args.length) {
                cmdLine = String.valueOf(cmdLine) + args[i] + " ";
                ++i;
            }
            System.out.println("\nCommand line:\n" + BDSup2Sub.getJarName() + " " + cmdLine + "\n");
            src = null;
            trg = null;
            alphaThr = Core.getAlphaThr();
            lumThr1 = -1;
            lumThr2 = -1;
            langIdx = -1;
            r = Core.Resolution.PAL;
            mode = null;
            defineFPStrg = false;
            screenRatio = -1.0;
            i = 0;
            while (i < args.length) {
                a = args[i];
                if (a.charAt(0) == '/') ** GOTO lbl-1000
                if (src == null) {
                    src = a;
                } else if (trg == null) {
                    trg = a;
                    ext = ToolBox.getExtension(trg);
                    if (ext == null) {
                        BDSup2Sub.fatalError("No extension given for target " + trg);
                    }
                    if (ext.equals("sup")) {
                        mode = Core.OutputMode.BDSUP;
                    } else if (ext.equals("sub") || ext.equals("idx")) {
                        mode = Core.OutputMode.VOBSUB;
                    } else if (ext.equals("xml")) {
                        mode = Core.OutputMode.XML;
                    } else if (ext.equals("ifo")) {
                        mode = Core.OutputMode.SUPIFO;
                    } else {
                        BDSup2Sub.fatalError("Unknown extension of target " + trg);
                    }
                    Core.setOutputMode(mode);
                } else lbl-1000:
                // 2 sources

                {
                    switchOn = true;
                    if (a.length() < 4 || a.charAt(0) != '/') {
                        BDSup2Sub.fatalError("Illegal argument: " + a);
                    }
                    if ((pos = a.indexOf(58)) > -1) {
                        val = a.substring(pos + 1, a.length());
                        a = a.substring(1, pos);
                    } else {
                        val = "";
                        a = a.substring(1);
                        last = a.length() - 1;
                        if (a.indexOf(43) == last) {
                            a = a.substring(0, last);
                        } else if (a.indexOf(45) == last) {
                            a = a.substring(0, last);
                            switchOn = false;
                        }
                    }
                    strSwitchOn = switchOn != false ? "ON" : "OFF";
                    p = BDSup2Sub.getParam(a);
                    ival = ToolBox.getInt(val);
                    switch (BDSup2Sub.$SWITCH_TABLE$BDSup2Sub$Parameters()[p.ordinal()]) {
                        case 2: {
                            if (ival < 0 || ival > 255) {
                                BDSup2Sub.fatalError("Illegal number range for alpha threshold: " + val);
                            } else {
                                alphaThr = ival;
                            }
                            System.out.println("OPTION: set alpha threshold to " + ival);
                            break;
                        }
                        case 3: {
                            if (ival < 0 || ival > 255) {
                                BDSup2Sub.fatalError("Illegal number range for luminance: " + val);
                            } else {
                                lumThr1 = ival;
                            }
                            System.out.println("OPTION: set low/mid luminance threshold to " + ival);
                            break;
                        }
                        case 4: {
                            if (ival < 0 || ival > 255) {
                                BDSup2Sub.fatalError("Illegal number range for luminance: " + val);
                            } else {
                                lumThr2 = ival;
                            }
                            System.out.println("OPTION: set mid/high luminance threshold to " + ival);
                            break;
                        }
                        case 1: {
                            if (val.toLowerCase().equals("keep")) {
                                Core.setConvertResolution(false);
                            } else {
                                Core.setConvertResolution(true);
                                if (val.toLowerCase().equals("pal") || ival == 576) {
                                    r = Core.Resolution.PAL;
                                    if (!defineFPStrg) {
                                        Core.setFPSTrg(25.0);
                                    }
                                } else if (val.toLowerCase().equals("ntsc") || ival == 480) {
                                    r = Core.Resolution.NTSC;
                                    if (!defineFPStrg) {
                                        Core.setFPSTrg(29.97002997002997);
                                    }
                                } else if (val.toLowerCase().equals("720p") || ival == 720) {
                                    r = Core.Resolution.HD_720;
                                    if (!defineFPStrg) {
                                        Core.setFPSTrg(23.976023976023978);
                                    }
                                } else if (val.toLowerCase().equals("1440x1080")) {
                                    r = Core.Resolution.HD_1440x1080;
                                    if (!defineFPStrg) {
                                        Core.setFPSTrg(23.976023976023978);
                                    }
                                } else if (val.toLowerCase().equals("1080p") || ival == 1080) {
                                    r = Core.Resolution.HD_1080;
                                    if (!defineFPStrg) {
                                        Core.setFPSTrg(23.976023976023978);
                                    }
                                } else {
                                    BDSup2Sub.fatalError("Illegal resolution: " + val);
                                }
                            }
                            System.out.println("OPTION: set resolution to " + Core.getResolutionName(r));
                            break;
                        }
                        case 5: {
                            langIdx = -1;
                            l = 0;
                            while (l < Core.getLanguages().length) {
                                if (Core.getLanguages()[l][1].equals(val)) {
                                    langIdx = l;
                                    break;
                                }
                                ++l;
                            }
                            if (langIdx == -1) {
                                System.out.println("ERROR: Unknown language " + val);
                                System.out.println("Use one of the following 2 character codes:");
                                l = 0;
                                while (l < Core.getLanguages().length) {
                                    System.out.println("    " + Core.getLanguages()[l][1] + " - " + Core.getLanguages()[l][0]);
                                    ++l;
                                }
                                BDSup2Sub.exit(1);
                            }
                            System.out.println("OPTION: set language to " + Core.getLanguages()[langIdx][0] + " (" + Core.getLanguages()[langIdx][1] + ")");
                            break;
                        }
                        case 6: {
                            f = new File(val);
                            if (f.exists()) {
                                id = ToolBox.getFileID(val, 4);
                                if (id == null || id[0] != 35 || id[1] != 67 || id[2] != 79 || id[3] != 76) {
                                    BDSup2Sub.fatalError("No valid palette file: " + val);
                                }
                            } else {
                                BDSup2Sub.fatalError("Palette file not found: " + val);
                            }
                            colProps = new Props();
                            colProps.load(val);
                            c = 0;
                            while (c < 15) {
                                s = colProps.get("Color_" + c, "0,0,0");
                                sp = s.split(",");
                                if (sp.length >= 3) {
                                    red = Integer.valueOf(ToolBox.trim(sp[0])) & 255;
                                    green = Integer.valueOf(ToolBox.trim(sp[1])) & 255;
                                    blue = Integer.valueOf(ToolBox.trim(sp[2])) & 255;
                                    Core.getCurrentDVDPalette().setColor(c + 1, new Color(red, green, blue));
                                }
                                ++c;
                            }
                            System.out.println("OPTION: loaded palette from " + val);
                            break;
                        }
                        case 7: {
                            Core.setExportForced(switchOn);
                            System.out.println("OPTION: export only forced subtitles: " + strSwitchOn);
                            break;
                        }
                        case 11: {
                            Core.setSwapCrCb(switchOn);
                            System.out.println("OPTION: swap Cr/Cb components: " + strSwitchOn);
                            break;
                        }
                        case 8: {
                            pos = val.indexOf(44);
                            if (pos > 0) {
                                srcStr = ToolBox.trim(val.substring(0, pos));
                                if (srcStr.toLowerCase().equals("auto")) {
                                    autoFPS = true;
                                    fpsSrc = 0.0;
                                } else {
                                    autoFPS = false;
                                    fpsSrc = Core.getFPS(srcStr);
                                    if (fpsSrc <= 0.0) {
                                        BDSup2Sub.fatalError("invalid source framerate: " + srcStr);
                                    }
                                    Core.setFPSSrc(fpsSrc);
                                }
                                fpsTrg = Core.getFPS(val.substring(pos + 1));
                                if (fpsTrg <= 0.0) {
                                    BDSup2Sub.fatalError("invalid target value: " + val.substring(pos + 1));
                                }
                                if (!autoFPS) {
                                    Core.setFPSTrg(fpsTrg);
                                }
                                Core.setConvertFPS(true);
                                System.out.println("OPTION: convert framerate from " + (autoFPS != false ? "<auto>" : ToolBox.formatDouble(fpsSrc)) + "fps to " + ToolBox.formatDouble(fpsTrg) + "fps");
                                defineFPStrg = true;
                                break;
                            }
                            if (val.toLowerCase().equals("keep")) {
                                Core.setKeepFps(true);
                                System.out.println("OPTION: use source fps as target fps");
                                break;
                            }
                            fpsTrg = Core.getFPS(val);
                            if (fpsTrg <= 0.0) {
                                BDSup2Sub.fatalError("invalid target framerate: " + val);
                            }
                            Core.setFPSTrg(fpsTrg);
                            System.out.println("OPTION: synchronize target framerate to " + ToolBox.formatDouble(fpsTrg) + "fps");
                            defineFPStrg = true;
                            break;
                        }
                        case 9: {
                            delay = 0.0;
                            try {
                                delay = Double.parseDouble(ToolBox.trim(val)) * 90.0;
                            }
                            catch (NumberFormatException ex) {
                                BDSup2Sub.fatalError("Illegal delay value: " + val);
                            }
                            delayPTS = (int)Core.syncTimePTS((long)delay, Core.getFPSTrg());
                            Core.setDelayPTS(delayPTS);
                            System.out.println("OPTION: set delay to " + ToolBox.formatDouble((double)delayPTS / 90.0));
                            break;
                        }
                        case 10: {
                            t = 0.0;
                            try {
                                t = Double.parseDouble(ToolBox.trim(val)) * 90.0;
                            }
                            catch (NumberFormatException ex) {
                                BDSup2Sub.fatalError("Illegal value for minimum display time: " + val);
                            }
                            tMin = (int)Core.syncTimePTS((long)t, Core.getFPSTrg());
                            Core.setMinTimePTS(tMin);
                            Core.setFixShortFrames(true);
                            System.out.println("OPTION: set delay to " + ToolBox.formatDouble((double)tMin / 90.0));
                            break;
                        }
                        case 12: 
                        case 13: {
                            if (p == Parameters.MOVE_OUTSIDE) {
                                Core.setMoveModeY(Core.MoveModeY.OUTSIDE);
                                sm = "outside";
                            } else {
                                Core.setMoveModeY(Core.MoveModeY.INSIDE);
                                sm = "inside";
                            }
                            pos = val.indexOf(44);
                            ratio = pos > 0 ? val.substring(0, pos) : val;
                            screenRatio = ToolBox.getDouble(ratio);
                            if (screenRatio <= 1.7777777777777777) {
                                BDSup2Sub.fatalError("invalid screen ratio: " + ratio);
                            }
                            moveOffsetY = Core.getMoveOffsetY();
                            if (pos > 0) {
                                moveOffsetY = ToolBox.getInt(val.substring(pos + 1));
                                if (moveOffsetY < 0) {
                                    BDSup2Sub.fatalError("invalid pixel offset: " + val.substring(pos + 1));
                                }
                                Core.setMoveOffsetY(moveOffsetY);
                            }
                            System.out.println("OPTION: moving captions " + sm + " " + ToolBox.formatDouble(screenRatio) + ":1 plus/minus " + moveOffsetY + " pixels");
                            break;
                        }
                        case 23: {
                            pos = val.indexOf(44);
                            mx = pos > 0 ? val.substring(0, pos) : val;
                            if (mx.equalsIgnoreCase("left")) {
                                Core.setMoveModeX(Core.MoveModeX.LEFT);
                            } else if (mx.equalsIgnoreCase("right")) {
                                Core.setMoveModeX(Core.MoveModeX.RIGHT);
                            } else if (mx.equalsIgnoreCase("center")) {
                                Core.setMoveModeX(Core.MoveModeX.CENTER);
                            } else {
                                BDSup2Sub.fatalError("invalid moveX command:" + mx);
                            }
                            moveOffsetX = Core.getMoveOffsetX();
                            if (pos > 0) {
                                moveOffsetX = ToolBox.getInt(val.substring(pos + 1));
                                if (moveOffsetX < 0) {
                                    BDSup2Sub.fatalError("invalid pixel offset: " + val.substring(pos + 1));
                                }
                                Core.setMoveOffsetX(moveOffsetX);
                            }
                            System.out.println("OPTION: moving captions to the " + mx + " plus/minus " + moveOffsetX + " pixels");
                            break;
                        }
                        case 14: {
                            cropY = ToolBox.getInt(ToolBox.trim(val));
                            if (cropY >= 0) {
                                Core.setCropOfsY(cropY);
                                System.out.println("OPTION: set delay to " + cropY);
                                break;
                            }
                            BDSup2Sub.fatalError("invalid crop y value: " + val.substring(0, pos));
                            break;
                        }
                        case 15: {
                            if (val.toLowerCase().equals("keep")) {
                                Core.setPaletteMode(Core.PaletteMode.KEEP_EXISTING);
                            } else if (val.toLowerCase().equals("create")) {
                                Core.setPaletteMode(Core.PaletteMode.CREATE_NEW);
                            } else if (val.toLowerCase().equals("dither")) {
                                Core.setPaletteMode(Core.PaletteMode.CREATE_DITHERED);
                            } else {
                                BDSup2Sub.fatalError("invalid palette mode: " + val);
                            }
                            System.out.println("OPTION: set palette mode to " + val.toLowerCase());
                            break;
                        }
                        case 16: {
                            Core.setVerbatim(switchOn);
                            System.out.println("OPTION: enabled verbatim output mode: " + strSwitchOn);
                            break;
                        }
                        case 17: {
                            sfs = null;
                            var43_76 = Core.ScalingFilters.values();
                            var42_75 = var43_76.length;
                            var41_73 = 0;
                            while (var41_73 < var42_75) {
                                sf = var43_76[var41_73];
                                if (Core.getScalingFilterName(sf).equalsIgnoreCase(val)) {
                                    sfs = sf;
                                    break;
                                }
                                ++var41_73;
                            }
                            if (sfs != null) {
                                Core.setScalingFilter(sfs);
                                System.out.println("OPTION: set scaling filter to: " + Core.getScalingFilterName(sfs));
                                break;
                            }
                            BDSup2Sub.fatalError("invalid scaling filter: " + val);
                            break;
                        }
                        case 18: {
                            t = 0.0;
                            try {
                                t = Double.parseDouble(ToolBox.trim(val)) * 90.0;
                            }
                            catch (NumberFormatException ex) {
                                BDSup2Sub.fatalError("Illegal value for maximum merge time: " + val);
                            }
                            ti = (int)(t + 0.5);
                            Core.setMergePTSdiff(ti);
                            System.out.println("OPTION: set maximum merge time to " + ToolBox.formatDouble((double)ti / 90.0));
                            break;
                        }
                        case 19: {
                            pos = val.indexOf(44);
                            if (pos > 0) {
                                scaleX = ToolBox.getDouble(val.substring(0, pos));
                                if (scaleX < 0.5 || scaleX > 2.0) {
                                    BDSup2Sub.fatalError("invalid x scaling factor: " + val.substring(0, pos));
                                }
                                if ((scaleY = ToolBox.getDouble(val.substring(pos + 1))) < 0.5 || scaleY > 2.0) {
                                    BDSup2Sub.fatalError("invalid y scaling factor: " + val.substring(pos + 1));
                                }
                                Core.setFreeScale(scaleX, scaleY);
                                System.out.println("OPTION: set free scaling factors to " + ToolBox.formatDouble(scaleX) + ", " + ToolBox.formatDouble(scaleY));
                                break;
                            }
                            BDSup2Sub.fatalError("invalid scale command (missing comma): " + val);
                            break;
                        }
                        case 20: {
                            if (ival < 0 || ival > 255) {
                                BDSup2Sub.fatalError("Illegal number range for alpha cropping threshold: " + val);
                            } else {
                                Core.setAlphaCrop(ival);
                            }
                            System.out.println("OPTION: set alpha cropping threshold to " + ival);
                            break;
                        }
                        case 21: {
                            Core.setWritePGCEditPal(switchOn);
                            System.out.println("OPTION: export target palette in PGCEDit text format: " + strSwitchOn);
                            break;
                        }
                        case 22: {
                            Core.setFixZeroAlpha(switchOn);
                            System.out.println("OPTION: fix zero alpha frame palette for SUB/IDX and SUP/IFO: " + strSwitchOn);
                            break;
                        }
                        case 24: {
                            Core.setForceAll(switchOn != false ? Core.SetState.SET : Core.SetState.CLEAR);
                            System.out.println("OPTION: set forced state of all captions to: " + strSwitchOn);
                            break;
                        }
                        default: {
                            BDSup2Sub.fatalError("Illegal argument: " + args[i]);
                        }
                    }
                }
                ++i;
            }
            Core.setOutputResolution(r);
            if (!Core.getKeepFps() && !defineFPStrg) {
                Core.setFPSTrg(Core.getDefaultFPS(r));
                System.out.println("Target frame rate set to " + ToolBox.formatDouble(Core.getFPSTrg()) + "fps");
            }
            if (trg == null) {
                BDSup2Sub.setupGUI();
                if (src != null) {
                    new MainFrame(src);
                } else {
                    new MainFrame();
                }
                return;
            }
            if (src.indexOf(42) != -1) {
                path = ToolBox.getPathName(src);
                if (path == null || path.length() == 0) {
                    path = "." + File.separatorChar;
                }
                if ((srcFiles = new File(path).listFiles(new FileFilter(ToolBox.getFileName(src)))).length == 0) {
                    BDSup2Sub.fatalError("No match found for '" + ToolBox.addSeparator(path) + src + "'");
                }
                if (trg.indexOf(42) == -1) {
                    BDSup2Sub.fatalError("No wildcards in target string!");
                }
                srcFileNames = new String[srcFiles.length];
                trgFileNames = new String[srcFiles.length];
                i = 0;
                while (i < srcFiles.length) {
                    srcFileNames[i] = String.valueOf(ToolBox.addSeparator(path)) + srcFiles[i].getName();
                    trgFileNames[i] = trg.replace("*", ToolBox.stripExtension(srcFiles[i].getName()));
                    ++i;
                }
            } else {
                srcFileNames = new String[1];
                trgFileNames = new String[1];
                srcFileNames[0] = src;
                aPos = trg.indexOf(42);
                trgFileNames[0] = aPos != -1 ? trg.replace("*", ToolBox.stripExtension(src)) : trg;
            }
            fnum = 0;
            while (fnum < srcFileNames.length) {
                src = srcFileNames[fnum];
                trg = trgFileNames[fnum];
                Core.init(null);
                try {
                    System.out.println("\nConverting " + Core.getOutputFormatName(mode) + "\n");
                    if (!new File(src).exists()) {
                        throw new CoreException("File '" + src + "' does not exist.");
                    }
                    xml = ToolBox.getExtension(src).equalsIgnoreCase("xml");
                    idx = ToolBox.getExtension(src).equalsIgnoreCase("idx");
                    ifo = ToolBox.getExtension(src).equalsIgnoreCase("ifo");
                    id = ToolBox.getFileID(src, 4);
                    v0 = sid = id == null ? Core.StreamID.UNKNOWN : Core.getStreamID(id);
                    if (!(idx || xml || ifo || sid != Core.StreamID.UNKNOWN)) {
                        throw new CoreException("File '" + src + "' is not a supported subtitle stream.");
                    }
                    Core.setCurrentStreamID(sid);
                    if (Core.getOutputMode() == Core.OutputMode.VOBSUB) {
                        fi = new File(String.valueOf(ToolBox.stripExtension(trg)) + ".idx");
                        fs = new File(String.valueOf(ToolBox.stripExtension(trg)) + ".sub");
                    } else {
                        fi = fs = new File(String.valueOf(ToolBox.stripExtension(trg)) + ".sup");
                    }
                    if ((fi.exists() || fs.exists()) && (fi.exists() && !fi.canWrite() || fs.exists() && !fs.canWrite())) {
                        throw new CoreException("Target file '" + trg + "' is write protected.");
                    }
                    if (xml || sid == Core.StreamID.XML) {
                        Core.readXml(src);
                    } else if (idx || sid == Core.StreamID.DVDSUB || sid == Core.StreamID.IDX) {
                        Core.readVobSub(src);
                    } else if (ifo || sid == Core.StreamID.IFO) {
                        Core.readSupIfo(src);
                    } else {
                        Core.readSup(src);
                    }
                    Core.scanSubtitles();
                    BDSup2Sub.printWarnings();
                    if (Core.getMoveModeX() != Core.MoveModeX.KEEP || Core.getMoveModeY() != Core.MoveModeY.KEEP) {
                        Core.setCineBarFactor((1.0 - 1.7777777777777777 / screenRatio) / 2.0);
                        Core.moveAllToBounds();
                    }
                    if (Core.getExportForced() && Core.getNumForcedFrames() == 0) {
                        throw new CoreException("No forced subtitles found.");
                    }
                    lt = Core.getLumThr();
                    if (lumThr1 > 0) {
                        lt[1] = lumThr1;
                    }
                    if (lumThr2 > 0) {
                        lt[0] = lumThr2;
                    }
                    Core.setLumThr(lt);
                    Core.setAlphaThr(alphaThr);
                    if (langIdx != -1) {
                        Core.setLanguageIdx(langIdx);
                    }
                    Core.writeSub(trg);
                }
                catch (CoreException ex) {
                    Core.printErr(ex.getMessage());
                }
                catch (Exception ex) {
                    ToolBox.showException(ex);
                    Core.printErr(ex.getMessage());
                }
                BDSup2Sub.printWarnings();
                Core.exit();
                ++fnum;
            }
            System.out.println("\nConversion of " + srcFileNames.length + " file(s) finished");
            System.exit(0);
        }
    }

    private static String getJarName() {
        BDSup2Sub c = new BDSup2Sub();
        String s = String.valueOf(c.getClass().getName().replace('.', '/')) + ".class";
        String r = "";
        URL url = c.getClass().getClassLoader().getResource(s);
        try {
            r = URLDecoder.decode(url.getPath(), "UTF-8");
            int pos = r.toLowerCase().indexOf("file:");
            if (pos != -1) {
                r = r.substring(pos + 5);
            }
            if ((pos = r.toLowerCase().indexOf(s.toLowerCase())) != -1) {
                r = r.substring(0, pos);
            }
            r = (pos = r.lastIndexOf(".jar")) != -1 ? r.substring(0, pos + 4) : String.valueOf(r) + Core.getProgName() + ".jar";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        r = r.replace('/', File.separatorChar);
        if (r.length() > 3 && r.charAt(2) == ':' && r.charAt(0) == '\\') {
            r = r.substring(1);
        }
        return r;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$BDSup2Sub$Parameters() {
        if ($SWITCH_TABLE$BDSup2Sub$Parameters != null) {
            return $SWITCH_TABLE$BDSup2Sub$Parameters;
        }
        int[] nArray = new int[Parameters.values().length];
        try {
            nArray[Parameters.ALPHATHR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.ALPHA_CROP.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.CROP_Y.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.DELAY.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.EXPORT_PAL.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.FILTER.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.FIX_ZERO_ALPHA.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.FORCED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.FORCE_ALL.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.FPS.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.LANGUAGE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.LUMTHR1.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.LUMTHR2.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.MIN_TIME.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.MOVE_INSIDE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.MOVE_OUTSIDE.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.MOVE_X.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.PALETTE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.PALETTE_MODE.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.RESOLUTION.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.SCALE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.SWAP_CR_CB.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.TMERGE.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.UNKNOWN.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parameters.VERBATIM.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$BDSup2Sub$Parameters = nArray;
        return nArray;
    }

    private static enum Parameters {
        RESOLUTION,
        ALPHATHR,
        LUMTHR1,
        LUMTHR2,
        LANGUAGE,
        PALETTE,
        FORCED,
        FPS,
        DELAY,
        MIN_TIME,
        SWAP_CR_CB,
        MOVE_INSIDE,
        MOVE_OUTSIDE,
        CROP_Y,
        PALETTE_MODE,
        VERBATIM,
        FILTER,
        TMERGE,
        SCALE,
        ALPHA_CROP,
        EXPORT_PAL,
        FIX_ZERO_ALPHA,
        MOVE_X,
        FORCE_ALL,
        UNKNOWN;

        private static final Map<Integer, Parameters> lookup;

        static {
            lookup = new HashMap<Integer, Parameters>();
            for (Parameters s : EnumSet.allOf(Parameters.class)) {
                lookup.put(s.ordinal(), s);
            }
        }

        public static Parameters get(int val) {
            return lookup.get(val);
        }
    }
}

