/*
 * (C) Finite State Machine Labs Inc. 1999 <business@fsmlabs.com>
 *
 * Released under the terms of GPL 2.
 * Open RTLinux makes use of a patented process described in
 * US Patent 5,995,745. Use of this process is governed
 * by the Open RTLinux Patent License which can be obtained from
 * www.fsmlabs.com/PATENT or by sending email to
 * licensequestions@fsmlabs.com
 */

#ifndef _MIPS_ARCH_H
#define _MIPS_ARCH_H
#include <linux/irq.h>
#include <linux/config.h>
#include <arch/constants.h>
#include <rtl_core.h>

#define RTL_NR_IRQS NR_IRQS

extern volatile int last_irq;
extern int (*hard_do_IRQ)(int, struct pt_regs *);
extern void (*__sti)(void);
extern void (*__cli)(void);
extern void (*__save_flags_ptr)(unsigned long *);
extern void (*__save_and_cli_ptr)(unsigned long *);
extern void (*__restore_flags)(ulong);

#define LOCAL_TIMER_VECTOR 0
#define RTL_RESCHEDULE_VECTOR 1
#define soft_local_disabled_irq(irq) (0)

/*
 * Global dispatch functions
 */
#define dispatch_linux_irq(regs,irq) { hard_do_IRQ(irq,regs); rtl_virt_enable(irq); }
static void __inline__ soft_dispatch_global(unsigned int irq)
{
	struct pt_regs regs;
	hard_do_IRQ(irq, &regs);
	rtl_virt_enable(irq);
}

/*
 * Local irq functions
 */
#define dispatch_rtl_local_handler(pnd,regs)
#define dispatch_local_linux_irq(regs)

#define ARCH_DEFINED_ENABLE ST0_IE
#define ARCH_DEFINED_DISABLE 0

extern irq_desc_t rtl_hard_irq_desc[NR_IRQS];

#define rtl_irq_controller_enable(irq) \
({ if (rtl_hard_irq_desc[irq].handler && rtl_hard_irq_desc[irq].handler->enable) \
	rtl_hard_irq_desc[irq].handler->enable(irq); })
#define rtl_irq_controller_disable(irq) \
({ if (rtl_hard_irq_desc[irq].handler && rtl_hard_irq_desc[irq].handler->disable) \
	rtl_hard_irq_desc[irq].handler->disable(irq); })
#define rtl_irq_controller_get_irq(regs) \
({ int i = last_irq; last_irq = -1; i; })
#define rtl_irq_controller_postirq(regs,irq)
#define rtl_irq_controller_ack(irq) \
({ if (rtl_hard_irq_desc[irq].handler && rtl_hard_irq_desc[irq].handler->ack) \
	rtl_hard_irq_desc[irq].handler->ack(irq); })
#define rtl_local_irq_controller_ack() { }

#endif /* _MIPS_ARCH_H */
