/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.PrintStream;
import jay.yydebug.yyAnimPanel;
import jay.yydebug.yyDebug;
import jay.yydebug.yyInputStream;
import jay.yydebug.yyPrintStream;

public class yyAnim
extends Frame
implements yyDebug {
    protected static int nFrames;
    public static final int IN = 1;
    public static final int OUT = 2;
    protected yyAnimPanel panel;
    protected Thread eventThread;
    protected boolean outputBreak;

    public yyAnim(String string, int n) {
        this(System.class, string, n);
    }

    public yyAnim(final Class clazz, String string, int n) {
        super(string);
        ++nFrames;
        this.outputBreak = false;
        Font font = new Font("Monospaced", 0, 12);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("yyAnim");
        MenuItem menuItem = new MenuItem("Quit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    clazz.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                }
                catch (Exception exception) {
                    System.exit(0);
                }
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.panel = new yyAnimPanel(font);
        this.add((Component)this.panel, "Center");
        if ((n & 3) != 0) {
            Component component;
            Object object;
            Panel panel = new Panel(new BorderLayout());
            switch (n) {
                case 1: {
                    panel.add((Component)new Label("terminal input"), "North");
                    break;
                }
                case 2: 
                case 3: {
                    object = (n & 1) != 0 ? "terminal i/o" : "terminal output";
                    component = new Checkbox((String)object, this.outputBreak);
                    panel.add(component, "North");
                    ((Checkbox)component).addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            yyAnim.this.eventThread = Thread.currentThread();
                            yyAnim.this.outputBreak = itemEvent.getStateChange() == 1;
                        }
                    });
                }
            }
            component = new TextArea(10, 50);
            panel.add(component, "Center");
            ((TextComponent)component).setBackground(Color.white);
            component.setFont(font);
            if ((n & 1) != 0) {
                object = new yyInputStream();
                component.addKeyListener((KeyListener)object);
                ((TextComponent)component).setEditable(true);
                try {
                    clazz.getMethod("setIn", InputStream.class).invoke(null, object);
                }
                catch (Exception exception) {
                    System.setIn((InputStream)object);
                }
            }
            if ((n & 2) != 0) {
                object = new yyPrintStream((TextArea)component){
                    final /* synthetic */ TextArea val$t;
                    {
                        this.val$t = textArea;
                    }

                    public void close() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(byte[] byArray, int n, int n2) {
                        String string = new String(byArray, n, n2);
                        this.val$t.append(string);
                        this.val$t.setCaretPosition(this.val$t.getText().length());
                        if (yyAnim.this.outputBreak && string.indexOf("\n") >= 0 && yyAnim.this.eventThread != null && Thread.currentThread() != yyAnim.this.eventThread) {
                            try {
                                yyAnimPanel yyAnimPanel2 = yyAnim.this.panel;
                                synchronized (yyAnimPanel2) {
                                    yyAnim.this.panel.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }

                    public void write(int n) {
                        this.write(new byte[]{(byte)n}, 0, 1);
                    }
                };
                try {
                    clazz.getMethod("setOut", PrintStream.class).invoke(null, object);
                }
                catch (Exception exception) {
                    System.setOut((PrintStream)object);
                }
                try {
                    clazz.getMethod("setErr", PrintStream.class).invoke(null, object);
                }
                catch (Exception exception) {
                    System.setErr((PrintStream)object);
                }
            }
            this.add((Component)panel, "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                yyAnim.this.dispose();
                if (--nFrames <= 0) {
                    try {
                        clazz.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                    }
                    catch (Exception exception) {
                        System.exit(0);
                    }
                }
            }
        });
        this.pack();
        yyAnim.setStaggeredLocation(this);
        this.show();
    }

    public static void setStaggeredLocation(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getPreferredSize();
        int n = (dimension.width - dimension2.width) / 2 + (nFrames - 1) * 32;
        if (n < 32) {
            n = 32;
        } else if (n > dimension.width - 128) {
            n = dimension.width - 128;
        }
        int n2 = (dimension.height - dimension2.height) / 2 + (nFrames - 1) * 32;
        if (n2 < 32) {
            n2 = 32;
        } else if (n2 > dimension.height - 128) {
            n2 = dimension.height - 128;
        }
        component.setLocation(n, n2);
    }

    public synchronized void lex(int n, int n2, String string, Object object) {
        this.panel.lex(n, n2, string, object);
    }

    public void shift(int n, int n2, int n3) {
        this.panel.shift(n, n2, n3);
    }

    public void discard(int n, int n2, String string, Object object) {
        this.panel.discard(n, n2, string, object);
    }

    public void shift(int n, int n2) {
        this.panel.shift(n, n2);
    }

    public synchronized void accept(Object object) {
        this.panel.accept(object);
    }

    public void error(String string) {
        this.panel.error(string);
    }

    public void reject() {
        this.panel.reject();
    }

    public synchronized void push(int n, Object object) {
        this.panel.push(n, object);
    }

    public synchronized void pop(int n) {
        this.panel.pop(n);
    }

    public synchronized void reduce(int n, int n2, int n3, String string, int n4) {
        this.panel.reduce(n, n2, n3, string, n4);
    }
}

