/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.Instance;
import IceInternal.Transceiver;

final class UnknownEndpoint
implements Endpoint {
    private Instance _instance;
    private short _type;
    private byte[] _rawBytes;
    private int _hashCode;

    public UnknownEndpoint(short s, BasicStream basicStream) {
        this._instance = basicStream.instance();
        this._type = s;
        basicStream.startReadEncaps();
        int n = basicStream.getReadEncapsSize();
        this._rawBytes = basicStream.readBlob(n);
        basicStream.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream basicStream) {
        basicStream.writeShort(this._type);
        basicStream.startWriteEncaps();
        basicStream.writeBlob(this._rawBytes);
        basicStream.endWriteEncaps();
    }

    public String toString() {
        return "";
    }

    public short type() {
        return this._type;
    }

    public int timeout() {
        return -1;
    }

    public Endpoint timeout(int n) {
        return this;
    }

    public boolean unknown() {
        return true;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Transceiver serverTransceiver(EndpointHolder endpointHolder) {
        endpointHolder.value = null;
        return null;
    }

    public Connector connector() {
        return null;
    }

    public Acceptor acceptor(EndpointHolder endpointHolder) {
        endpointHolder.value = null;
        return null;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        UnknownEndpoint unknownEndpoint = null;
        try {
            unknownEndpoint = (UnknownEndpoint)object;
        }
        catch (ClassCastException classCastException) {
            return 1;
        }
        if (this == unknownEndpoint) {
            return 0;
        }
        if (this._type < unknownEndpoint._type) {
            return -1;
        }
        if (unknownEndpoint._type < this._type) {
            return 1;
        }
        if (this._rawBytes.length < unknownEndpoint._rawBytes.length) {
            return -1;
        }
        if (unknownEndpoint._rawBytes.length < this._rawBytes.length) {
            return 1;
        }
        for (int i = 0; i < this._rawBytes.length; ++i) {
            if (this._rawBytes[i] < unknownEndpoint._rawBytes[i]) {
                return -1;
            }
            if (unknownEndpoint._rawBytes[i] >= this._rawBytes[i]) continue;
            return 1;
        }
        return 0;
    }

    private void calcHashValue() {
        this._hashCode = this._type;
        for (int i = 0; i < this._rawBytes.length; ++i) {
            this._hashCode = 5 * this._hashCode + this._rawBytes[i];
        }
    }
}

