/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.CommunicatorDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Adapter;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PlainService;
import IceGridGUI.Application.ServiceTemplateEditor;
import IceGridGUI.Application.ServiceTemplates;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServiceTemplate
extends Communicator {
    private TemplateDescriptor _templateDescriptor;
    private final boolean _ephemeral;
    private Editable _editable;
    private ServiceTemplateEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;

    public static TemplateDescriptor copyDescriptor(TemplateDescriptor templateDescriptor) {
        TemplateDescriptor copy = (TemplateDescriptor)templateDescriptor.clone();
        copy.descriptor = PlainService.copyDescriptor((ServiceDescriptor)copy.descriptor);
        return copy;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/service_template.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/service_template.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        Object clipboard;
        boolean[] actions = new boolean[20];
        actions[14] = ((TreeNode)this._parent).getAvailableActions()[14] ? true : (clipboard = this.getCoordinator().getClipboard()) != null && (clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor);
        actions[15] = true;
        if (!this._ephemeral) {
            actions[13] = true;
            actions[0] = true;
            actions[1] = true;
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(ServiceTemplate.copyDescriptor(this._templateDescriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
        }
        actions.setTarget(this);
        return _popup;
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServiceTemplateEditor)this.getRoot().getEditor(ServiceTemplateEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new ServiceTemplateEditor();
    }

    ServiceTemplate(boolean brandNew, ServiceTemplates parent, String name, TemplateDescriptor descriptor) throws UpdateFailedException {
        super(parent, name);
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this.rebuild(descriptor);
    }

    ServiceTemplate(ServiceTemplates parent, String name, TemplateDescriptor descriptor) {
        super(parent, name);
        this._ephemeral = true;
        this._editable = null;
        this._templateDescriptor = descriptor;
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(ServiceTemplate.createAttribute("id", this._id));
            writer.writeStartTag("service-template", attributes);
            ServiceTemplate.writeParameters(writer, this._templateDescriptor.parameters, this._templateDescriptor.parameterDefaults);
            ServiceDescriptor descriptor = (ServiceDescriptor)this._templateDescriptor.descriptor;
            writer.writeStartTag("service", PlainService.createAttributes(descriptor));
            if (descriptor.description.length() > 0) {
                writer.writeElement("description", descriptor.description);
            }
            ServiceTemplate.writePropertySet(writer, descriptor.propertySet, descriptor.adapters, descriptor.logs);
            ServiceTemplate.writeLogs(writer, descriptor.logs, descriptor.propertySet.properties);
            this._adapters.write(writer, descriptor.propertySet.properties);
            this._dbEnvs.write(writer);
            writer.writeEndTag("service");
            writer.writeEndTag("service-template");
        }
    }

    void rebuild(TemplateDescriptor descriptor) throws UpdateFailedException {
        this._templateDescriptor = descriptor;
        this._adapters.clear();
        this._dbEnvs.clear();
        if (!this._ephemeral) {
            this._adapters.init(this._templateDescriptor.descriptor.adapters);
            this._dbEnvs.init(this._templateDescriptor.descriptor.dbEnvs);
        }
    }

    void commit() {
        this._editable.commit();
    }

    public Object getDescriptor() {
        return this._templateDescriptor;
    }

    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._templateDescriptor.descriptor;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    public void destroy() {
        ServiceTemplates serviceTemplates = (ServiceTemplates)this._parent;
        if (this._ephemeral) {
            serviceTemplates.removeChild(this);
        } else {
            serviceTemplates.removeDescriptor(this._id);
            this.getRoot().removeServiceInstances(this._id);
            serviceTemplates.removeChild(this);
            serviceTemplates.getEditable().removeElement(this._id, this._editable, ServiceTemplate.class);
            this.getRoot().updated();
        }
    }

    List findInstances() {
        return this.getRoot().findServiceInstances(this._id);
    }

    Editable getEditable() {
        return this._editable;
    }

    Editable getEnclosingEditable() {
        return this._editable;
    }

    public Object saveDescriptor() {
        TemplateDescriptor clone = (TemplateDescriptor)this._templateDescriptor.clone();
        clone.descriptor = (ServiceDescriptor)this._templateDescriptor.descriptor.clone();
        return clone;
    }

    public void restoreDescriptor(Object savedDescriptor) {
        TemplateDescriptor clone = (TemplateDescriptor)savedDescriptor;
        this._templateDescriptor.parameters = clone.parameters;
        ServiceDescriptor sd = (ServiceDescriptor)this._templateDescriptor.descriptor;
        ServiceDescriptor csd = (ServiceDescriptor)clone.descriptor;
        sd.propertySet = csd.propertySet;
        sd.description = csd.description;
        sd.name = csd.name;
        sd.entry = csd.entry;
    }
}

