/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.Editor;
import IceGridGUI.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ParameterValuesField
extends JTable {
    private static final Object _useDefault;
    private static final Object _notSet;
    private JComboBox _useDefaultCombo = new JComboBox<Object>(new Object[]{_useDefault});
    private JComboBox _notSetCombo = new JComboBox<Object>(new Object[]{_notSet});
    private TableCellEditor _useDefaultEditor = new DefaultCellEditor(this._useDefaultCombo);
    private TableCellEditor _notSetEditor = new DefaultCellEditor(this._notSetCombo);
    private DefaultTableModel _model;
    private Vector _columnNames;
    private Editor _editor;
    private boolean[] _hasDefault;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParameterValuesField(Editor editor) {
        this._editor = editor;
        this._columnNames = new Vector(2);
        this._columnNames.add("Name");
        this._columnNames.add("Value");
        this._useDefaultCombo.setEditable(true);
        this._notSetCombo.setEditable(true);
    }

    public void set(List names, Map values, Map defaultValues, final Utils.Resolver resolver) {
        Vector vector = new Vector(names.size());
        Iterator p = names.iterator();
        this._hasDefault = new boolean[names.size()];
        int i = 0;
        while (p.hasNext()) {
            Vector<Object> row = new Vector<Object>(2);
            String name = (String)p.next();
            row.add(name);
            this._hasDefault[i] = defaultValues.get(name) != null;
            Object val = values.get(name);
            if (val == null) {
                row.add(this._hasDefault[i] ? _useDefault : _notSet);
            } else {
                row.add(Utils.substitute((String)val, resolver));
            }
            vector.add(row);
            ++i;
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            public boolean isCellEditable(int row, int column) {
                if (resolver == null) {
                    return column > 0;
                }
                return false;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ParameterValuesField.this._editor.updated();
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(resolver == null);
        this.setOpaque(resolver == null);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(resolver == null);
    }

    public Map getValues() {
        HashMap values = new HashMap();
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        Iterator<Vector> p = vector.iterator();
        while (p.hasNext()) {
            Vector row = p.next();
            String name = (String)row.elementAt(0);
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            Object val = row.elementAt(1);
            if (val == _useDefault || val == _notSet) continue;
            if (!$assertionsDisabled && val == null) {
                throw new AssertionError();
            }
            values.put(name, val);
        }
        return values;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return this._hasDefault[row] ? this._useDefaultEditor : this._notSetEditor;
        }
        return super.getCellEditor(row, column);
    }

    static {
        $assertionsDisabled = !ParameterValuesField.class.desiredAssertionStatus();
        _useDefault = new Object(){

            public String toString() {
                return "Use default";
            }
        };
        _notSet = new Object(){

            public String toString() {
                return "Not set";
            }
        };
    }
}

