/*
 * GnomeZclockPreview - A preview and format selection widget for GtkZclock
 * Copyright (C) 2000  Zack Hobson <zack@malfunktion.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef INC_GNOME_ZCLOCK_PREVIEW_H
#define INC_GNOME_ZCLOCK_PREVIEW_H

#include <gnome.h>
#include "gtk_zclock.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_ZCLOCK_PREVIEW(obj) \
		GTK_CHECK_CAST(obj, gnome_zclock_preview_get_type(), GnomeZclockPreview)
#define GNOME_ZCLOCK_PREVIEW_CLASS(klass) \
		GTK_CHECK_CAST(klass, gnome_zclock_preview_get_type(), GnomeZclockPreviewClass)
#define GNOME_IS_ZCLOCK_PREVIEW(obj) GTK_CHECK_TYPE(obj, gnome_zclock_preview_get_type())

typedef struct _GnomeZclockPreview	GnomeZclockPreview;
typedef struct _GnomeZclockPreviewClass	GnomeZclockPreviewClass;

struct _GnomeZclockPreview
{
	/* base widget */
	GnomeDialog	parent_widget;

	/* child widgets */
	GtkWidget*	table;
	GtkWidget*	entry;
	GtkWidget*	list;
	GtkWidget*	btn_box;
	GtkWidget*	add_button;
	GtkWidget*	rem_button;
	GtkWidget*	frame;
	GtkWidget*	hbox_clk;
	GtkWidget*	zclock;

	/* data */
	GList**		pglist;
	gchar**		format;
	GList*		glist;
	gint		selected;
};

struct _GnomeZclockPreviewClass
{
	GnomeDialogClass parent_class;
};

guint gnome_zclock_preview_get_type (void);
GtkWidget* gnome_zclock_preview_new (GList**, gchar**);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* INC_GNOME_ZCLOCK_PREVIEW_H */

