#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

int main(int argc, char** argv)
{
 unsigned int maxframe, frame=0;
 int width, height, i;
 char *infile;
 char fname[256], clipname[256], strname[256], junk[256];
 FILE *par, *ppm;
 int outfile=0, temp;
 unsigned char r, g, b;
 
 if(argc!=3)
 {
  fprintf(stderr, "Usage:\n\n");
  fprintf(stderr, " ppm2str <filename> <maxfrrame>\n");
  fprintf(stderr, "   eg: ppm2str caption:%%06d 500\n\n");
  exit(0);
 }
 infile=argv[1];
 sprintf(strname, "%s", infile);
 strname[strcspn(infile, ":")]='\0';
 sprintf(clipname, "%s:cliptab", strname);
 maxframe=atoi(argv[2]);
 maxframe*=2;

 while(frame<=maxframe)
 {
  sprintf(junk, infile, (int)frame>>1);
  sprintf(fname, "%s.ppm", junk);
  fprintf(stderr, "%s\n", fname);
  ppm=fopen(fname, "r");
  if(ppm)
  {
   fgets(junk, 256, ppm);
   fgets(junk, 256, ppm);
   while(junk[0]=='#')fgets(junk, 256, ppm);
   sscanf(junk, "%d %d", &width, &height);
   fgets(junk, 256, ppm);
   if(outfile==0)
   {
    outfile=open(strname, O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
    if(outfile<=0)
    {
     perror("open video file");
     exit(-1);
    }
    write(outfile, &width, sizeof(width));
    write(outfile, &height, sizeof(height));
    write(outfile, &maxframe, sizeof(maxframe));
   }
   write(outfile, &frame, sizeof(frame));
   for(i=0; i<(width*height); i++)
   {
    fread(&r, 1, 1, ppm);
    fread(&g, 1, 1, ppm);
    fread(&b, 1, 1, ppm);
    temp = (int)((int)b >> 3);
    temp |= (int)(((int)g >> 2) << 5);
    temp |= (int)(((int)r >> 3) << 11);
    r=(unsigned char)temp&0xff;
    g=(unsigned char)(temp>>8);
    write(outfile, &r, 1);
    write(outfile, &g, 1);
   }
  }
  frame+=2;
 }

 maxframe/=2;
 fprintf(stderr, "Writing str2mpeg.par\n");
 par=fopen("str2ppm.par","w");
 fprintf(par, "MPEG-1 Test Sequence, 25 frames/sec\n");
 fprintf(par, "%s\n", infile);
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "-\n");
 fprintf(par, "3\n");
 fprintf(par, "%u\n", maxframe+1);
 fprintf(par, "0\n");
 fprintf(par, "00:00:00:00\n");
 fprintf(par, "12\n");
 fprintf(par, "3\n");
 fprintf(par, "1\n");
 fprintf(par, "0\n");
 fprintf(par, "%d\n", width);
 fprintf(par, "%d\n", height);
 fprintf(par, "8\n");
#ifdef NTSC
 fprintf(par, "5\n"); /* NTSC 30fps */
#else
 fprintf(par, "3\n"); /* PAL 25fps */
#endif
 fprintf(par, "%f\n", (float)width*height*12);
 fprintf(par, "20\n");
 fprintf(par, "0\n");
 fprintf(par, "1\n");
 fprintf(par, "4\n");
 fprintf(par, "8\n");
 fprintf(par, "1\n");
 fprintf(par, "1\n");
 fprintf(par, "1\n");
 fprintf(par, "5\n");
 fprintf(par, "5\n");
 fprintf(par, "5\n");
 fprintf(par, "%d\n", width);
 fprintf(par, "%d\n", height);
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "1 1 1\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0 0 0\n");
 fprintf(par, "0\n");
 fprintf(par, "1\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "0\n");
 fprintf(par, "2 2 11 11\n");
 fprintf(par, "1 1 3  3\n");
 fprintf(par, "1 1 7  7\n");
 fprintf(par, "1 1 7  7\n");
 fprintf(par, "1 1 3  3\n");
 fclose(par);

 par=fopen(clipname,"w");
 if(!par)
 {
  perror("open cliptab");
  exit(-1);
 }
 fprintf(par, "audio_dummy %s\n", strname);
 fprintf(par, "*\n");
 fprintf(par, "B 0 0 %d\n", maxframe+1);
 fclose(par);

 par=fopen("audio_dummy.out", "w");
 if(!par)
 {
  perror("open audio_dummy");
  exit(-1);
 }
 fprintf(par, "audio_dummy\n");
 fclose(par);
 return 0;
}
