/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <VectorFont.h>

#include <qpoint.h>
#include <qpainter.h>

#include <stdarg.h>
#include <iostream>

VectorFont* VectorFont::instance_ = 0;
const int VectorFont::charWidth_ = 6;

//-----------------------------------------------------------------
VectorChar::VectorChar()
{
  polyList_.setAutoDelete( TRUE );
}

//-----------------------------------------------------------------
VectorChar::~VectorChar()
{}

//-----------------------------------------------------------------
void VectorChar::addPoly( int size, int firstx, int firsty, ... )
{
  QPointArray* points = new QPointArray(size);
  va_list ap;
  points->setPoint( 0, firstx, firsty );
  int i = 1, x, y;
  size--;
  va_start( ap, firsty );
  while ( size-- )
    {
      x = va_arg( ap, int );
      y = va_arg( ap, int );
      points->setPoint( i++, x, y );
    }
  va_end( ap );
  polyList_.append( points );
}

//-----------------------------------------------------------------
void VectorChar::draw(QPainter* p)
{
  QPointArray* points = 0;
  for ( points = polyList_.first(); points != 0; points = polyList_.next() )
    {
      p->drawPolyline( *points );
    }
}

//-----------------------------------------------------------------
VectorFont* VectorFont::instance()
{
  if ( instance_ == 0)
    {
      instance_ = new VectorFont();
      instance_->initialize();
    }
  return instance_;
}

//-----------------------------------------------------------------
VectorFont::VectorFont()
{}

//-----------------------------------------------------------------
VectorFont::~VectorFont()
{
  instance_ = 0;
}

//-----------------------------------------------------------------
void VectorFont::initialize()
{
  charMap_['i'].addPoly( 2, 2,-8, 2,-7 );
  charMap_['i'].addPoly( 3, 1,-5, 2,-5, 2,0 );
  charMap_['i'].addPoly( 2, 1,0, 3,0 );
  charMap_['A'].addPoly( 5, 0,0, 0,-4, 2,-8, 4,-4, 4,0 );
  charMap_['A'].addPoly( 2, 0,-4, 4,-4 );
  charMap_['B'].addPoly( 10, 0,0, 0,-8, 3,-8, 4,-7, 4,-5, 3,-4,
                         4,-3, 4,-1, 3,0, 0,0 );
  charMap_['B'].addPoly( 2, 0,-4, 3,-4  );
  charMap_['C'].addPoly( 6, 4,0, 2,0, 0,-2, 0,-6, 2,-8, 4,-8 );
  charMap_['D'].addPoly( 7, 0,0, 2,0, 4,-2, 4,-6, 2,-8, 0,-8, 0,0 );
  charMap_['E'].addPoly( 4, 4,-8, 0,-8, 0,0, 4,0 );
  charMap_['E'].addPoly( 2, 0,-4, 2,-4 );
  charMap_['F'].addPoly( 3, 4,-8, 0,-8, 0,0 );
  charMap_['F'].addPoly( 2, 0,-4, 2,-4 );
  charMap_['G'].addPoly( 10, 4,-7, 3,-8, 1,-8, 0,-7, 0,-1, 1,0,
                         3,0, 4,-1, 4,-4, 2,-4);
  charMap_['H'].addPoly( 2, 0,0, 0,-8 );
  charMap_['H'].addPoly( 2, 4,0, 4,-8 );
  charMap_['H'].addPoly( 2, 0,-4, 4,-4 );
  charMap_['I'].addPoly( 2, 0,0, 4,0 );
  charMap_['I'].addPoly( 2, 0,-8, 4,-8 );
  charMap_['I'].addPoly( 2, 2,0, 2,-8 );
  charMap_['J'].addPoly( 5, 4,-8, 4,-1, 3,0, 1,0, 0,-1 );
  charMap_['K'].addPoly( 2, 0,0, 0,-8 );
  charMap_['K'].addPoly( 3, 4,-8, 0,-4, 4,0 );
  charMap_['L'].addPoly( 3, 0,-8, 0,0, 4,0 );
  charMap_['M'].addPoly( 5, 0,0, 0,-8, 2,-4, 4,-8, 4,0 );
  charMap_['N'].addPoly( 4, 0,0, 0,-8, 4,0, 4,-8 );
  charMap_['O'].addPoly( 9, 1,0, 3,0, 4,-1, 4,-7, 3,-8, 1,-8,
                         0,-7, 0,-1, 1,0 );
  charMap_['P'].addPoly( 7, 0,0, 0,-8, 3,-8, 4,-7, 4,-5, 3,-4, 0,-4 );
  charMap_['Q'].addPoly( 9, 1,0, 3,0, 4,-1, 4,-7, 3,-8, 1,-8,
                         0,-7, 0,-1, 1,0 );
  charMap_['Q'].addPoly( 2, 2,-1, 4,1 );
  charMap_['R'].addPoly( 8, 0,0, 0,-8, 3,-8, 4,-7, 4,-5, 3,-4,
                         0,-4, 4,0 );
  charMap_['S'].addPoly( 12, 0,-1, 1,0, 3,0, 4,-1, 4,-3, 3,-4, 1,-4, 0,-5,
                         0,-7, 1,-8, 3,-8, 4,-7 );
  charMap_['T'].addPoly( 2, 0,-8, 4,-8 );
  charMap_['T'].addPoly( 2, 2,-8, 2,0 );
  charMap_['U'].addPoly( 6, 0,-8, 0,-1, 1,0, 3,0, 4,-1, 4,-8);
  charMap_['V'].addPoly( 3, 0,-8, 2,0, 4,-8);
  charMap_['W'].addPoly( 5, 0,-8, 0,0, 2,-4, 4,0, 4,-8);
  charMap_['X'].addPoly( 2, 0,-8, 4,0 );
  charMap_['X'].addPoly( 2, 4,-8, 0,0 );
  charMap_['Y'].addPoly( 3, 0,-8, 2,-4, 2,0 );
  charMap_['Y'].addPoly( 2, 2,-4, 4,-8 );
  charMap_['Z'].addPoly( 4, 0,-8, 4,-8, 0,0, 4,0 );
  charMap_['.'].addPoly( 2, 2,-1, 2,0 );
  charMap_['-'].addPoly( 2, 1,-4, 3,-4 );
  charMap_['='].addPoly( 2, 1,-5, 3,-5 );
  charMap_['='].addPoly( 2, 1,-3, 3,-3 );
  charMap_['?'].addPoly( 5, 0,-8, 4,-8, 4,-5, 2,-5, 2,-3 );
  charMap_['?'].addPoly( 2, 2,-1, 2,0 );
  charMap_[':'].addPoly( 2, 2,-1, 2,-2);
  charMap_[':'].addPoly( 2, 2,-6, 2,-7);
  charMap_['('].addPoly( 4, 2,-8, 0,-6, 0,-2, 2,0 );
  charMap_[')'].addPoly( 4, 2,-8, 4,-6, 4,-2, 2,0 );
  charMap_['0'].addPoly( 10, 1,0, 3,0, 4,-1, 4,-7, 3,-8, 1,-8, 0,-7, 0,-1, 1,0, 3,-8);
  charMap_['1'].addPoly( 3, 0,-6, 2,-8, 2,0 );
  charMap_['2'].addPoly( 6, 0,-8, 4,-8, 4,-4, 0,-4, 0,0, 4,0 );
  charMap_['3'].addPoly( 4, 0,-8, 4,-8, 4,0, 0,0 );
  charMap_['3'].addPoly( 2, 0,-4, 4,-4 );
  charMap_['4'].addPoly( 3, 0,-8, 0,-4, 4,-4 );
  charMap_['4'].addPoly( 2, 4,-8, 4,0 );
  charMap_['5'].addPoly( 6, 4,-8, 0,-8, 0,-4, 4,-4, 4,0, 0,0 );
  charMap_['6'].addPoly( 5, 0,-8, 0,0, 4,0, 4,-4, 0,-4 );
  charMap_['7'].addPoly( 3, 0,-8, 4,-8, 0,0 );
  charMap_['8'].addPoly( 7, 4,-4, 4,-8, 0,-8, 0,0, 4,0, 4,-4, 0,-4 );
  charMap_['9'].addPoly( 5, 4,0, 4,-8, 0,-8, 0,-4, 4,-4 );
  charMap_['_'].addPoly( 2, 0,0, 4,0 );
}

//-----------------------------------------------------------------
void VectorFont::draw(const QChar& character, QPainter* p, QPoint& point)
{
  p->save();
  p->translate(point.x(), point.y());
  if ( character != ' ' )
    {
      if ( charMap_.contains( character ) )
        {
          charMap_[character].draw(p);
        }
      else
        {
          if ( charMap_.contains( character.upper() ) )
            {
              charMap_[ character.upper() ].draw(p);
            }
          else
            {
              charMap_['?'].draw(p);
            }
        }
    }
  point.setX( point.x() + charWidth_ );
  p->restore();
}

//-----------------------------------------------------------------
void VectorFont::drawText(const QString& text, QPainter* p, QPoint point)
{
  for (unsigned int i=0; i<text.length(); i++)
    {
      QChar c = text.at(i);
      draw(c, p, point);
    }
}

//-----------------------------------------------------------------
int VectorFont::textWidth(const QString& text)
{
  int width = charWidth_ * text.length();
  return width;
}
