/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <Inductor.h>

#include <Strings.h>

#include "../images/inductor.xpm"

#include <iostream.h>

QPixmap* Inductor::pixmap_ = 0;

//-----------------------------------------------------------------
Inductor::Inductor( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
Inductor::~Inductor()
{
}

//-----------------------------------------------------------------
const QString& Inductor::getCatagory() const
{
  return Strings::LumpedCatagory;
}

//-----------------------------------------------------------------
const QString& Inductor::getName() const
{
  return Strings::InductorName;
}

//-----------------------------------------------------------------
const QPixmap& Inductor::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap(inductor_xpm);
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void Inductor::initComponent()
{
  boundingRect_ = QRect(-16, -6, 32, 12);
  addNode(-24,0);
  addNode(24,0);
  addAttribute( Strings::AttrInductance, "L" );
}

//-----------------------------------------------------------------
void Inductor::drawSymbol(QPainter* p)
{
  p->drawLine(-24,0,-14,0);
  p->drawLine(14,0,24,0);
  p->drawArc(-14,-6,12,12,2880,-2880);
  p->drawArc(-6,-6,12,12,2880,-2880);
  p->drawArc(+2,-6,12,12,2880,-2880);
  p->drawArc(-6,-6,4,12,0,-2880);
  p->drawArc(+2,-6,4,12,0,-2880);
}

//-----------------------------------------------------------------
bool Inductor::initSweep()
{
  TReal l = l_;
  l_ = getAttributeValue( "L" );
  l_ = l_ * getDimensionValue( Strings::InductanceDim );
  return (l_ != l);
}

//-----------------------------------------------------------------
void Inductor::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  TComplex y( 0, -1/(freq*l_) );
  yn->insertComponent( y, node(0)->getNodeNumber(), node(1)->getNodeNumber() );
}
