/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef RESULTDEFINITION_H
#define RESULTDEFINITION_H

#include <qlist.h>
#include <qstring.h>

class QDomElement;
class QTextStream;

class ResultDefinition
{
public:
  ResultDefinition();
  virtual ~ResultDefinition();

  enum MeasurementType { portParameters,
			 linvillStabilityFactor,
			 sternStabilityFactor };

  enum Measurement { sParameters,
		     yParameters,
		     zParameters,
		     groupDelay };

  enum MeasurementFormat { realFormat,
			   imagFormat,
			   magnitudeFormat,
			   angleFormat };

  long int id() const;

  MeasurementType   type() const;
  Measurement       measurement() const;
  MeasurementFormat format() const;
  const QString&    source() const;
  uint              to() const;
  uint              from() const;
  bool              db() const;

  void setType( MeasurementType );
  void setMeasurement( Measurement );
  void setFormat( MeasurementFormat );
  void setSource( const QString& );
  void setTo( uint );
  void setFrom( uint );
  void setDbResults( bool );

  static QString buildResultDefinitionStr( bool isSmith,
					   ResultDefinition& definition );

  static ResultDefinition* findResultDefinitionById( long int id );

  void writeToStream( QTextStream& stream );
  bool readFromDOM( QDomElement& element );

private:
  ResultDefinition( const ResultDefinition& );
  ResultDefinition& operator=( const ResultDefinition& );

private:
  long int resultId_;
  MeasurementType   measurementType_;
  Measurement       measurement_;
  MeasurementFormat format_;
  QString           dataSource_;
  uint              toPort_;
  uint              fromPort_;
  bool              dbResults_;

  static QList<ResultDefinition>* resultDefinitions_;
};

#endif
