/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef COMPONENT_H
#define COMPONENT_H

#include <SchematicElement.h>

#include <CircuitNode.h>
#include <Types.h>
#include <Matrix.h>

#include <qmap.h>
#include <qrect.h>
#include <qlist.h>
#include <qpoint.h>
#include <qstring.h>
#include <qpainter.h>

class Schematic;
class QPixmap;
class QDomElement;
class QTextStream;

class Component : public SchematicElement
{
public:
  Component( const QPoint& center );
  virtual ~Component();

  void copyData( Component& source );
  
  void setSchematic( Schematic* schematic );
  virtual void initComponent() = 0;
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn ) = 0;

  //Symbol bar support
  virtual const QString& getCatagory() const = 0;
  virtual const QString& getName() const = 0;
  virtual const QPixmap& getPixmap() const = 0;

  //Simulation support
  virtual bool initSweep() = 0;

  QPoint getCenter() const;
  int getRotation() const;
  void setRotation( int rotation );

  QRect getBoundingRect() const;
  bool  isInsideBoundingRect(QPoint) const;
 
  void draw(QPainter*);
  void moveTo(QPoint);
  void moveRel(QPoint);
  void rotate();

  //Spooling
  virtual void writeToStream( QTextStream& );
  virtual bool readFromDOM( QDomElement& );

  struct Attribute {
    QString name_;
    QString symbol_;
    QString value_;
  };
  typedef QList<Attribute> AttributeList;

  void addAttribute( const QString& name, const QString& symbol, TReal value=0 );
  Attribute* findAttribute( const QString& name );
  AttributeList& getAttributeList();

  static int getNodeSize();

protected:
  virtual void drawSymbol(QPainter*) = 0;
  CircuitNode* addNode(int, int, bool isPortNode = FALSE, 
		       bool isGndNode = FALSE, bool isFloatAllowed = FALSE);
  CircuitNode* node(uint i);

  const QString& getAttributeStr( const QString& symbol );
  TReal getAttributeValue( const QString& symbol );
  TReal getDimensionValue( const QString& name );

  void copyMemberData( Component& source );

private:
  //Not implemented
  Component( const Component& c );
  Component& operator=( const Component& c );

  void drawAttributes(QPainter* painter);

protected:
  QRect  boundingRect_;
  AttributeList attributeList_;

private:
  QPoint centerPoint_;
  static int    nodeSize_;
  int           rotation_;
  Schematic*    schematic_;

  QList<CircuitNode> nodeList_;

};

#endif
